/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.tree;

import com.huawei.ism.ui.swing.PropertyPane;
import com.huawei.ism.ui.widgets.propertypane.ProgressingPropertyPane;
import java.lang.ref.SoftReference;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;

public class IsmTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -4067738240416410998L;
    private String name = "";
    private String nodeText = null;
    private String tooltip = null;
    private transient Icon icon = null;
    private String deviceID = null;
    private transient SoftReference<PropertyPane> propertyPaneRef = null;
    private JPopupMenu popupMenu = null;

    public IsmTreeNode(String deviceID) {
        this.deviceID = deviceID;
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.popupMenu = menu;
    }

    public void updateStatus(List<IsmTreeNode> structureChangedNodes, List<IsmTreeNode> changeNodes) {
    }

    public final PropertyPane getPropertyPane() {
        PropertyPane result = null;
        if (null == this.propertyPaneRef) {
            result = this.createPropertyPane();
            this.propertyPaneRef = new SoftReference<PropertyPane>(result);
        } else {
            result = this.propertyPaneRef.get();
            if (null == result) {
                result = this.createPropertyPane();
                this.propertyPaneRef = new SoftReference<PropertyPane>(result);
            }
        }
        return result;
    }

    protected PropertyPane createPropertyPane() {
        return ProgressingPropertyPane.getInstance();
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public IsmTreeNode getParentNode() {
        return (IsmTreeNode)this.parent;
    }

    public String getText() {
        return this.nodeText;
    }

    public void setNodeText(String nodeText) {
        this.nodeText = nodeText;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setTooltipText(String tooltipStr) {
        this.tooltip = tooltipStr;
    }

    public String getTooltipText() {
        return this.tooltip;
    }
}

