/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets.settingpane;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.templets.settingpane.SettingsPane;
import com.huawei.ism.ui.templets.settingpane.SettingsRightPane;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

final class DefaultRightPane
extends SettingsRightPane {
    private static final long serialVersionUID = -716430230651084990L;
    private static DefaultRightPane instance;
    private JLabel errMsgLabel;
    private transient SettingsPane.SettingItem failedItemFor;
    private JButton button;

    private DefaultRightPane() {
    }

    public static DefaultRightPane getInstance() {
        if (null == instance) {
            instance = new DefaultRightPane();
        }
        instance.setButtonText(ResourceManager.getString("RELOAD"));
        return instance;
    }

    @Override
    protected void addHandler() {
    }

    public void setErrMsg(String errMsg) {
        String htmlHeader = "<html>";
        String htmlHeaderPair = "</html>";
        String msg = errMsg;
        if (null == errMsg || errMsg.length() == 0) {
            msg = ResourceManager.getString("-1");
        }
        int errMsgLength = this.computeErrMsgLength(errMsg);
        Dimension preferredSize = new Dimension(errMsgLength + 10, 60);
        if (490 < errMsgLength) {
            msg = "<html>" + msg + "</html>";
            preferredSize = new Dimension(500, 60);
        }
        this.errMsgLabel.setMaximumSize(preferredSize);
        this.errMsgLabel.setMinimumSize(preferredSize);
        this.errMsgLabel.setPreferredSize(preferredSize);
        this.errMsgLabel.setText(msg);
    }

    private int computeErrMsgLength(String errMsg) {
        FontMetrics fm = IsmPlafUtils.getFontMetrics(this.errMsgLabel, null, IsmFontFactory.getDialogPlain());
        return SwingUtilities.computeStringWidth(fm, errMsg);
    }

    public void setButtonText(String buttonText) {
        if (null == buttonText || buttonText.length() == 0) {
            this.button.setText(ResourceManager.getString("RELOAD"));
        } else {
            this.button.setText(buttonText);
        }
    }

    void setSettingItem(SettingsPane.SettingItem failedItem) {
        Assert.notNull(failedItem);
        this.failedItemFor = failedItem;
    }

    @Override
    protected boolean doInitTask() throws IsmException {
        return true;
    }

    protected JComponent createView() {
        return this.createContentPane();
    }

    @Override
    protected String getItemTitle() {
        return null;
    }

    protected Object createMemo() {
        return null;
    }

    protected void doResumeTask(Object memo) {
    }

    private JComponent createContentPane() {
        JPanel contentPane = UCD.createTransparentPane(new BorderLayout());
        this.errMsgLabel = new JLabel();
        this.button = UCD.createButton(ResourceManager.getString("RELOAD"));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsPane settingsPane = (SettingsPane)SwingUtilities.getAncestorOfClass(SettingsPane.class, DefaultRightPane.this.button);
                settingsPane.aboutToShow(DefaultRightPane.this.failedItemFor);
            }
        });
        contentPane.add((Component)UCD.buildHBoxCentert(this.errMsgLabel, this.button), "Center");
        return contentPane;
    }

    @Override
    protected String getDescription() {
        return null;
    }

    @Override
    protected String getHelpKey() {
        return null;
    }
}

