/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets.wizard;

import com.huawei.ism.exception.IsmException;
import com.huawei.ism.ui.module.command.AbstractCommand;
import com.huawei.ism.ui.templets.wizard.Card;
import com.huawei.ism.ui.templets.wizard.Wizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardDemo {
    private static final Logger LOGGER = LoggerFactory.getLogger(WizardDemo.class);

    static class ThirdCard
    extends Card {
        public ThirdCard() {
            this.setCardView(new Layout());
        }

        @Override
        protected Wizard.CardHead getCardHead() {
            return new Wizard.CardHead("FirstCard", "You have enter the first card, and prepare for your work.", null);
        }

        @Override
        protected Card.Step getStep() {
            return new Card.Step(3, 3, Card.StepID.SecondCard, null);
        }

        @Override
        protected boolean doInitTask() {
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException e) {
                LOGGER.error("", (Throwable)e);
            }
            return true;
        }

        @Override
        protected boolean onFinishCommand() {
            ArrayList<AbstractCommand> commands = new ArrayList<AbstractCommand>(0);
            AbstractCommand command = null;
            for (int index : new int[]{0, 1, 2, 3, 4, 6, 5, 4, 5, 6}) {
                command = this.getCommand(index);
                commands.add(command);
            }
            this.getWizard().getModel().addMutualData("CommandListIdentifier", commands);
            return true;
        }

        private AbstractCommand getCommand(int index) {
            MyDotaskCommand command = new MyDotaskCommand(index);
            return command;
        }

        @Override
        protected String getHelpKey() {
            return null;
        }

        private static class Layout
        extends JPanel {
            private static final long serialVersionUID = 1L;

            public Layout() {
                this.setLayout(new BorderLayout());
                this.add((Component)new JButton("Click to finish your work"), "North");
            }
        }

        private static final class MyDotaskCommand
        extends AbstractCommand {
            private final int index;

            private MyDotaskCommand(int index) {
                this.index = index;
            }

            @Override
            protected void executeTask() throws IsmException {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("", (Throwable)e);
                }
                if (this.index % 2 == 0) {
                    throw new IsmException(83890180L);
                }
            }

            @Override
            public String getDescription() {
                return "test" + this.index;
            }
        }
    }

    static class SecondCard
    extends Card {
        public SecondCard() {
            this.setCardView(new Layout());
        }

        @Override
        protected Wizard.CardHead getCardHead() {
            return new Wizard.CardHead("FirstCard", "You have enter the first card, and prepare for your work.", null);
        }

        @Override
        protected Card.Step getStep() {
            return new Card.Step(2, 3, Card.StepID.FirstCard, Card.StepID.ThirdCard);
        }

        @Override
        protected boolean doInitTask() {
            try {
                Thread.sleep(1200L);
            }
            catch (InterruptedException e) {
                LOGGER.error("", (Throwable)e);
            }
            return true;
        }

        @Override
        protected String getHelpKey() {
            return null;
        }

        private static class Layout
        extends JPanel {
            private static final long serialVersionUID = 1L;

            public Layout() {
                this.setLayout(new BorderLayout());
                this.add((Component)new JButton("Click to enter the third card or finish your work"), "North");
            }
        }
    }

    static class FirstCard
    extends Card {
        public FirstCard() {
            this.setCardView(new Layout());
        }

        @Override
        protected Wizard.CardHead getCardHead() {
            return new Wizard.CardHead("FirstCard", "You have enter the first card, and prepare for your work.", null);
        }

        @Override
        protected Card.Step getStep() {
            return new Card.Step(1, 3, null, Card.StepID.SecondCard);
        }

        @Override
        protected boolean doInitTask() {
            try {
                Thread.sleep(1100L);
            }
            catch (InterruptedException e) {
                LOGGER.error("", (Throwable)e);
            }
            return true;
        }

        @Override
        protected String getHelpKey() {
            return null;
        }

        private static class Layout
        extends JPanel {
            private static final long serialVersionUID = 1L;

            public Layout() {
                this.setLayout(new BorderLayout());
                this.add((Component)new JButton("Click to enter the second card or close your wizard"), "North");
            }
        }
    }
}

