/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.widgets.dialog;

import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.DeviceContext;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.templets.WizardDialog;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class DevicesCard
extends WizardDialog.Card {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{ResourceManager.getString("ALL_ARRAYS_TYPE"), ResourceManager.getString("ALL_ARRAYS_NAME"), ResourceManager.getString("IP_ADDRESS")};
    private List<String> selectedDeviceIDs = new ArrayList<String>(0);

    public DevicesCard(String[] forbiddenDeviceIDs, WizardDialog.Card previousCard, WizardDialog.Navigation ... supportedNavigation) {
        super(previousCard, supportedNavigation);
        DefaultTableModel tableModel = new DefaultTableModel(COLUMN_NAMES, 0, 1, 2);
        List<TableRow> tableRows = this.getTableRows(forbiddenDeviceIDs);
        TableRow[] rows = tableRows.toArray(new TableRow[0]);
        tableModel.setTableData(rows);
        final IsmTable table = new IsmTable(tableModel);
        table.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                List<TableRow> markedRows = table.getMarkedRows();
                DevicesCard.this.selectedDeviceIDs.clear();
                for (TableRow row : markedRows) {
                    DevicesCard.this.selectedDeviceIDs.add((String)row.getUserObject());
                }
                DevicesCard.this.updateNavigationBar();
            }
        });
        TableScrollPane tablePanel = new TableScrollPane(table, false, true);
        this.add(tablePanel);
    }

    private List<TableRow> getTableRows(String[] forbiddenDeviceIDs) {
        ArrayList<TableRow> tableData = new ArrayList<TableRow>(0);
        LauncherManager launcherManager = LauncherManager.getInstance();
        ArrayList<String> ids = new ArrayList<String>(0);
        for (String id : forbiddenDeviceIDs) {
            ids.add(id);
        }
        String deviceID = null;
        DeviceType deviceType = null;
        DefaultTableRow<String, String> rowData = null;
        for (DeviceContext context : launcherManager.getDeviceContexts()) {
            deviceID = context.getDeviceID();
            if (ids.contains(deviceID) || (deviceType = context.getDeviceType()) == null || DeviceType.isNASStorSerias(deviceType.getDescription()) || DeviceType.isVISSerias(deviceType)) continue;
            rowData = new DefaultTableRow<String, String>(COLUMN_NAMES.length, deviceID, deviceID);
            rowData.setValueAt(0, (Object)context.getDeviceModelType());
            rowData.setValueAt(1, context.getDeviceName());
            rowData.setValueAt(2, context.getPreferedIP());
            tableData.add(rowData);
        }
        return tableData;
    }

    protected List<String> getSelectedDeviceIDs() {
        if (this.selectedDeviceIDs == null) {
            this.selectedDeviceIDs = new ArrayList<String>(0);
        }
        return this.selectedDeviceIDs;
    }
}

