/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.module.event;

import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.Event;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.forms.help.HelpManager;
import com.huawei.ism.ui.module.event.EventManager;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.TimeUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.plaf.FontUIResource;

public class EventDetail
extends JPanel {
    private static final int SPACE = 8;
    private static final int MARGEN = 5;
    private static final int MIN_WIDTH = 260;
    private static final long serialVersionUID = 1L;
    private JLabel lblEventLevelValue;
    private JPanel mainPanel = UCD.createBoxLayoutPane(1);
    private JLabel lblSystemValue;
    private JLabel lblEventStartTimeValue;
    private JLabel lblEventRecoverTimeValue;
    private JLabel lblLocationValue;
    private JTextArea lblDetailsValue;
    private JLabel lblEventIDValue;
    private JTextArea lblRepairSuggestValue;
    private final boolean isCurrentEvent;
    private JButton betimesHelpBtn = null;
    private JPanel pane;

    public EventDetail(boolean isCurrentEvent) {
        this.isCurrentEvent = isCurrentEvent;
        this.initComponent();
        this.doLayoutUI();
    }

    public JLabel getLblEventLevelValue() {
        return this.lblEventLevelValue;
    }

    private void doLayoutUI() {
        JScrollPane panel = new JScrollPane();
        panel.setViewportView(this.mainPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
        this.setMinimumSize(new Dimension(260, 500));
    }

    private void initComponent() {
        this.lblEventLevelValue = new JLabel();
        this.lblSystemValue = new JLabel();
        this.lblLocationValue = new JLabel();
        this.lblEventStartTimeValue = new JLabel();
        this.lblEventRecoverTimeValue = new JLabel();
        this.lblDetailsValue = UCD.createTextArea("");
        this.lblDetailsValue.setBorder(null);
        this.lblDetailsValue.setSize(139, 36);
        this.lblRepairSuggestValue = UCD.createTextArea("");
        this.lblRepairSuggestValue.setSize(139, 36);
        this.lblRepairSuggestValue.setBorder(null);
        this.lblEventIDValue = new JLabel();
        this.betimesHelpBtn = UCD.createButton(ResourceManager.getImage("tooltips_help.png"), new Dimension(18, 18));
        this.betimesHelpBtn.setBorderPainted(false);
        this.betimesHelpBtn.setContentAreaFilled(false);
    }

    public void setData(Event event) {
        String eventID = "0x" + Long.toHexString(event.getEventID()).toUpperCase(ResourceManager.getLocale());
        this.lblEventLevelValue.setText(event.getLevel().toString());
        if (Event.Level.INFO.equals((Object)event.getLevel())) {
            this.betimesHelpBtn.setVisible(false);
        } else {
            this.betimesHelpBtn.setVisible(true);
        }
        this.lblEventIDValue.setText(eventID);
        this.lblDetailsValue.setText(event.getDetail());
        this.lblRepairSuggestValue.setText(event.getSuggestion());
        TimeZone zone = LauncherManager.getInstance().getLauncher(event.getIdentifier().getDeviceID()).getDeviceTimeZone();
        String startTime = TimeUtil.gmtToString(EventManager.getInstance().getEventTime(event, true), zone);
        this.lblEventStartTimeValue.setText(startTime);
        if (!this.isCurrentEvent && event.getRecoverTime() != 0L) {
            this.lblEventRecoverTimeValue.setText(TimeUtil.gmtToString(EventManager.getInstance().getEventTime(event, false), zone));
        }
        Launcher launcher = CommonUtil.getLauncher(event.getIdentifier().getDeviceID());
        this.lblSystemValue.setText(CommonUtil.getDeviceName(event.getIdentifier().getDeviceID()));
        this.lblLocationValue.setText(null == launcher ? "--" : launcher.getDeviceContext().getDeviceAddress());
        this.doHelpTask(event);
    }

    private void doHelpTask(Event event) {
        if (event.getLevel().isFault()) {
            String eventID = "0x" + Long.toHexString(event.getEventID()).toUpperCase(ResourceManager.getLocale());
            HelpManager.getInstance().linkEventHelp(this.betimesHelpBtn, eventID, event.getIdentifier().getDeviceID());
        }
    }

    public void clearData() {
        this.lblEventLevelValue.setText("");
        this.lblEventLevelValue.setIcon(null);
        this.lblEventIDValue.setText("");
        this.lblDetailsValue.setText("");
        this.lblRepairSuggestValue.setText("");
        this.lblEventStartTimeValue.setText("");
        this.lblEventRecoverTimeValue.setText("");
        this.lblSystemValue.setText("");
        this.lblLocationValue.setText("");
    }

    public void showMainPanel(boolean isVisible, String infoDesc) {
        this.showMainPanel(isVisible, infoDesc, false);
    }

    public void showMainPanel(boolean isVisible, String infoDesc, boolean isResize) {
        if (!isVisible) {
            this.repaintMainPanl(infoDesc);
        } else {
            this.getMainPanel(isResize);
        }
        this.repaint();
    }

    private void repaintMainPanl(String infoDesc) {
        this.mainPanel.removeAll();
        this.mainPanel.add(Box.createVerticalStrut(20));
        JLabel infoLabel = new JLabel();
        FontUIResource font = new FontUIResource("SimSun", 0, 14);
        infoLabel.setFont(font);
        infoLabel.setForeground(new Color(0xA5A5A5));
        infoLabel.setIcon(ResourceManager.getImage("Information.png"));
        infoLabel.setText(infoDesc);
        JComponent infoHbox = UCD.buildHorizotalBox(null, infoLabel);
        UCD.setJComponentSize(this.mainPanel, new Dimension(260, infoHbox.getPreferredSize().height + 20));
        this.mainPanel.add(infoHbox);
    }

    private JPanel getMainPanel(boolean isResize) {
        if (!isResize) {
            this.mainPanel.removeAll();
            this.mainPanel.add(Box.createVerticalStrut(20));
            this.pane = UCD.createRightKVPane(8, this.getPairs());
            this.mainPanel.add(this.pane);
            this.mainPanel.setBorder(UCD.createEmptyBorder(10));
            UCD.setJComponentSize(this.mainPanel, new Dimension(260, this.pane.getPreferredSize().height + 40));
        } else if (this.pane != null) {
            this.pane.repaint();
            UCD.setJComponentSize(this.mainPanel, new Dimension(280, this.pane.getPreferredSize().height + 40));
        }
        return this.mainPanel;
    }

    private List<Pair<Component, Component>> getPairs() {
        JLabel lblEventLevel = new JLabel(ResourceManager.getStringWithColon("event.detail.level.lable"));
        JLabel lblEventStartTime = new JLabel(ResourceManager.getStringWithColon("ALARM.TABLE.MODEL.ALARM.START.TIME"));
        JLabel lblEventEndTime = new JLabel(ResourceManager.getStringWithColon("ALARM.TABLE.MODEL.ALARM.RECOVER.TIME"));
        JLabel lblSystemKey = new JLabel(ResourceManager.getStringWithColon("LOGICALARRAYSPROPERTYPANE.ARRAYNAME"));
        JLabel lblLocationKey = new JLabel(ResourceManager.getStringWithColon("ARRAY_LACTION"));
        JLabel lblDetailsKey = new JLabel(ResourceManager.getString("ALARM_MANAGE_REASON"));
        JLabel lblRepairSuggestKey = new JLabel(ResourceManager.getStringWithColon("ALARM.REPAIR.INFO"));
        JComponent helpHbox = UCD.buildHorizotalBox(null, this.lblEventIDValue, this.betimesHelpBtn);
        Pair<JLabel, JLabel> eventLevelPair = new Pair<JLabel, JLabel>(lblEventLevel, this.lblEventLevelValue);
        Pair<JLabel, JLabel> systemPair = new Pair<JLabel, JLabel>(lblSystemKey, this.lblSystemValue);
        Pair<JLabel, JLabel> locationPair = new Pair<JLabel, JLabel>(lblLocationKey, this.lblLocationValue);
        Pair<JLabel, JComponent> idPair = new Pair<JLabel, JComponent>(new JLabel(ResourceManager.getStringWithColon("event.detail.id.lable")), helpHbox);
        Pair<JLabel, JLabel> startTimePair = new Pair<JLabel, JLabel>(lblEventStartTime, this.lblEventStartTimeValue);
        Pair<JLabel, JLabel> recoverTimePair = new Pair<JLabel, JLabel>(lblEventEndTime, this.lblEventRecoverTimeValue);
        Pair<JLabel, JTextArea> detailsPair = new Pair<JLabel, JTextArea>(lblDetailsKey, this.lblDetailsValue);
        Pair<JLabel, JLabel> rePairSuggestPair = new Pair<JLabel, JLabel>(lblRepairSuggestKey, new JLabel());
        Pair<Component, Component> tempPair = new Pair<Component, Component>(Box.createVerticalStrut(5), Box.createVerticalStrut(5));
        Pair<Component, Component> tempPair2 = new Pair<Component, Component>(Box.createVerticalStrut(5), Box.createVerticalStrut(5));
        Pair<Component, Component> noPair = new Pair<Component, Component>(Box.createVerticalStrut(5), Box.createVerticalStrut(5));
        Pair<JLabel, JTextArea> rePairSuggestValuePair = new Pair<JLabel, JTextArea>(new JLabel(), this.lblRepairSuggestValue);
        ArrayList<Pair<Component, Component>> listPairs = new ArrayList<Pair<Component, Component>>(0);
        listPairs.add(eventLevelPair);
        listPairs.add(tempPair2);
        listPairs.add(systemPair);
        listPairs.add(locationPair);
        listPairs.add(idPair);
        listPairs.add(tempPair);
        listPairs.add(startTimePair);
        if (!this.isCurrentEvent) {
            listPairs.add(recoverTimePair);
        }
        listPairs.add(detailsPair);
        listPairs.add(noPair);
        listPairs.add(rePairSuggestPair);
        listPairs.add(rePairSuggestValuePair);
        return listPairs;
    }
}

