/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.IPackageActivator;
import com.huawei.ism.common.bean.DeviceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Debug {
    private static final Logger LOGGER = LoggerFactory.getLogger(Debug.class);
    private static Map<String, IPackageActivator> packageActivatorMap = new HashMap<String, IPackageActivator>(0);
    private static Map<String, DeviceType> deviceTypeMap = new HashMap<String, DeviceType>(0);

    public static void initPackage() {
        ArrayList<IPackageActivator> activators = new ArrayList<IPackageActivator>(0);
        boolean arrayOnly = Boolean.valueOf(Framework.getInstance().getStrProperty("arrayonly", "false"));
        if (arrayOnly) {
            activators.add(Debug.newInstance("com.huawei.xve.XVEActivator"));
        } else {
            activators.add(Debug.newInstance("com.huawei.unistor.NexNASPackageActivator"));
            activators.add(Debug.newInstance("com.huawei.unistor.UniStorActivator"));
            activators.add(Debug.newInstance("com.huawei.ism.ArrayPackageActivator"));
        }
        String[] supportedDeviceTypes = null;
        for (IPackageActivator packageActivator : activators) {
            if (null == packageActivator) continue;
            packageActivator.doInitTask();
            for (String type : supportedDeviceTypes = packageActivator.getSupportedDeviceTypes()) {
                packageActivatorMap.put(type, packageActivator);
            }
        }
    }

    public static Collection<IPackageActivator> getActivators() {
        return packageActivatorMap.values();
    }

    private static IPackageActivator newInstance(String activatorClass) {
        try {
            Class<?> cls = Class.forName(activatorClass);
            return (IPackageActivator)cls.newInstance();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static DeviceType getDeviceTypeByIp(String ip) {
        DeviceType result = deviceTypeMap.get(ip);
        if (null == result) {
            result = DeviceType.OCEAN_STOR;
        }
        return result;
    }

    public static IPackageActivator getPackageAcivator(String deviceType) {
        if (packageActivatorMap.isEmpty()) {
            Debug.initPackage();
        }
        return packageActivatorMap.get(deviceType);
    }
}

