/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util.errortracer;

import com.huawei.ism.util.errortracer.ErrorTracer;
import com.huawei.ism.util.errortracer.TracerItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogErrorTracer
implements ErrorTracer,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogErrorTracer.class);
    private static final long serialVersionUID = -2012825271585245806L;
    private final transient List<TracerItem> itemList = new ArrayList<TracerItem>(0);

    @Override
    public void traceException(Exception exc) {
        this.traceException(null, exc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void traceException(String message, Exception exc) {
        TracerItem item = new TracerItem();
        item.setException(exc);
        item.setMessage(message);
        List<TracerItem> list = this.itemList;
        synchronized (list) {
            this.itemList.add(item);
        }
    }

    @Override
    public void traceMessage(String message) {
        this.traceException(message, null);
    }

    private void printErrorInfo() {
        StringBuffer buffer = new StringBuffer("End retrieve Array,traced exception number:" + this.itemList.size());
        for (TracerItem item : this.itemList) {
            buffer.append('\n');
            buffer.append(item.getMessage());
            buffer.append("---");
            buffer.append(item.getException());
        }
        LOGGER.info(buffer.toString());
        for (TracerItem item : this.itemList) {
            LOGGER.error("Error Trace:" + item.getMessage(), (Throwable)item.getException());
        }
    }

    @Override
    public void endTrace() {
        this.printErrorInfo();
    }

    @Override
    public void startTrace() {
        this.itemList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TracerItem> getAllTracedItems() {
        List<TracerItem> list = this.itemList;
        synchronized (list) {
            ArrayList<TracerItem> list2 = new ArrayList<TracerItem>(this.itemList.size());
            list2.addAll(this.itemList);
            return list2;
        }
    }

    @Override
    public void clearTracedItems() {
        this.itemList.clear();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

