/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util.parser;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.util.parser.XmlParser;
import com.huawei.ism.util.parser.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlDomParser
extends XmlParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlDomParser.class);
    private static final Object LOCK = new Object();
    private static DocumentBuilder documentBuilder;
    private Document doc = null;
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDomParser(String filePathRelativeToJar) throws SAXException, IOException {
        Object object = LOCK;
        synchronized (object) {
            InputStream is = null;
            try {
                is = this.loader.getResourceAsStream(filePathRelativeToJar);
                this.doc = documentBuilder.parse(is);
                this.doc.getDocumentElement().normalize();
            }
            catch (RuntimeException e) {
                LOGGER.error("parser xml document failed. ", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("parser xml document failed. ", (Throwable)e);
            }
            finally {
                StreamUtils.closeResource(null, is);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDomParser(String filePathRelativeToJar, ClassLoader cl) throws SAXException, IOException {
        Object object = LOCK;
        synchronized (object) {
            URL url = cl.getResource(filePathRelativeToJar);
            if (null == url) {
                throw new EncapsulatedRuntimeException("url is null.");
            }
            this.doc = documentBuilder.parse(url.toString());
            this.doc.getDocumentElement().normalize();
            this.setClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDomParser(InputStream is) throws SAXException, IOException {
        Object object = LOCK;
        synchronized (object) {
            this.doc = documentBuilder.parse(is);
            this.doc.getDocumentElement().normalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDomParser(File file) throws SAXException, IOException {
        Object object = LOCK;
        synchronized (object) {
            this.doc = documentBuilder.parse(file);
            this.doc.getDocumentElement().normalize();
        }
    }

    private void setClassLoader(ClassLoader cl) {
        this.loader = cl;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.loader;
    }

    @Override
    public String getAttributeValueOfElementNode(Node node, String attributeName) {
        if (attributeName != null) {
            Node attributeNode = node.getAttributes().getNamedItem(attributeName);
            return attributeNode.getTextContent();
        }
        return "";
    }

    @Override
    public String getTextContentOfChild(Element parent, String childTagName) {
        return XmlUtils.getTextContentOfChild(parent, childTagName);
    }

    @Override
    public Element treeWalkOfOneElementNode(Element node, String tagName) {
        return this.treeWalkOfOneElementNode(node, tagName, null, null);
    }

    @Override
    public Element treeWalkOfOneElementNode(Element parentNode, String tagName, String attributeName, String attributeValue) {
        NodeList nodeList = parentNode.getElementsByTagName(tagName);
        return this.treeWalkOfOneElementFromNodeList(nodeList, attributeName, attributeValue);
    }

    @Override
    public Element treeWalkOfOneElementNode(String tagName) {
        return this.treeWalkOfOneElementNode(tagName, null, null);
    }

    @Override
    public Element treeWalkOfOneElementNode(String tagName, String attributeName, String attributeValue) {
        NodeList nodeList = this.doc.getElementsByTagName(tagName);
        return this.treeWalkOfOneElementFromNodeList(nodeList, attributeName, attributeValue);
    }

    @Override
    public Collection<Element> getChildren(Element parent, String childTagName) {
        return XmlUtils.getChildren(parent, childTagName);
    }

    @Override
    public Element getChild(Element parent, String childTagName) {
        return XmlUtils.getChild(parent, childTagName);
    }

    @Override
    public Collection<Element> getChildren(Element parent) {
        return this.getChildren(parent, null);
    }

    private Element treeWalkOfOneElementFromNodeList(NodeList nodeList, String attributeName, String attributeValue) {
        Element findNode = null;
        int nodeSize = nodeList.getLength();
        for (int i = 0; i < nodeSize; ++i) {
            Element node = (Element)nodeList.item(i);
            if (null == attributeName || null == attributeValue) {
                findNode = node;
                continue;
            }
            Node attributeNode = node.getAttributes().getNamedItem(attributeName);
            if (null == attributeNode || !attributeValue.equalsIgnoreCase(attributeNode.getTextContent())) continue;
            findNode = node;
        }
        return findNode;
    }

    static {
        try {
            documentBuilder = com.huawei.ism.tool.base.utils.XmlUtils.getIgnoreWhitespaceDocBuilderFactory().newDocumentBuilder();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

