/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.kmc.common;

public enum InnerKdfAlgorithm {
    UNKNOWN_ALGORITHM("UNKNOWN_ALGORITHM", 0),
    PBKDF2_HMAC_SHA256("PBKDF2_HMAC_SHA256", 3076),
    PBKDF2_HMAC_SM3("PBKDF2_HMAC_SM3", 3079);

    private String kdfAlg;
    private int value;

    private InnerKdfAlgorithm(String kdfAlg, int value) {
        this.kdfAlg = kdfAlg;
        this.value = value;
    }

    public static InnerKdfAlgorithm searchByName(String name) {
        if (name.isEmpty()) {
            return UNKNOWN_ALGORITHM;
        }
        InnerKdfAlgorithm algTemp = null;
        try {
            algTemp = InnerKdfAlgorithm.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            algTemp = UNKNOWN_ALGORITHM;
        }
        return algTemp != null ? algTemp : UNKNOWN_ALGORITHM;
    }

    public String getKdfAlg() {
        return this.kdfAlg;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return "**not support toString**";
    }
}

