/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.encryptbase.asymmetric;

import com.huawei.encryptbase.asymmetric.AsymmetricCipherAlgorithm;
import com.huawei.encryptbase.asymmetric.AsymmetricKeyPair;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsymmetricKeyGenerator {
    private static final Logger log = LoggerFactory.getLogger(AsymmetricKeyGenerator.class);
    private static final int RSA_KEY_LEN = 4096;

    private AsymmetricKeyGenerator() {
    }

    public static AsymmetricKeyPair generateEciesPublicPrivateKey() throws Exception {
        KeyPair keyPair = AsymmetricKeyGenerator.generateEciesKeyPair();
        return AsymmetricKeyGenerator.generatePublicPrivateKey(keyPair.getPrivate(), keyPair.getPublic());
    }

    public static AsymmetricKeyPair generateRsaPublicPrivateKey() throws Exception {
        KeyPair keyPair = AsymmetricKeyGenerator.generateRsaKeyPair();
        return AsymmetricKeyGenerator.generatePublicPrivateKey(keyPair.getPrivate(), keyPair.getPublic());
    }

    private static AsymmetricKeyPair generatePublicPrivateKey(PrivateKey privateKey, PublicKey publicKey) {
        AsymmetricKeyPair asymmetricKeyPair = new AsymmetricKeyPair();
        byte[] publicKeyBytes = publicKey.getEncoded();
        String publicKeyStr = Base64.encodeBase64String((byte[])publicKeyBytes);
        byte[] priBytes = privateKey.getEncoded();
        String privateKeyStr = Base64.encodeBase64String((byte[])priBytes);
        asymmetricKeyPair.setPrivateKey(privateKeyStr);
        asymmetricKeyPair.setPublicKey(publicKeyStr);
        return asymmetricKeyPair;
    }

    public static KeyPair generateEciesKeyPair() throws Exception {
        String recommendedEccAlgorithmName = "brainpoolP512r1";
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(AsymmetricCipherAlgorithm.ECIES.getAlgorithm(), "BC");
        keyPairGenerator.initialize(new ECGenParameterSpec(recommendedEccAlgorithmName));
        return keyPairGenerator.generateKeyPair();
    }

    public static KeyPair generateRsaKeyPair() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(4096);
        return keyPairGenerator.generateKeyPair();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

