/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.crypto;

import com.huawei.us.common.codec.USCodec;
import com.huawei.us.common.crypto.USCmapReplacement;
import com.huawei.us.common.crypto.USCryptoConfig;
import com.huawei.us.common.crypto.USEncryptor;
import com.huawei.us.common.crypto.USKeyManager;
import com.huawei.us.common.password.PwdComplexUtils;
import com.huawei.us.psm.PsmKeyDecryptor;
import com.huawei.us.psm.PsmKeyEncryptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.function.Function;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.owasp.esapi.errors.EncryptionException;

public class App {
    private static final PrintStream SOUT = System.out;
    private static final String ENCRYPT_MODE = "encrypt";
    private static final String DECRYPT_MODE = "decrypt";
    private static final String FS_DECRYPT_MODE = "fs_decrypt";
    private static final String FS_ENCRYPT_MODE = "fs_encrypt";
    private static final String FS_ENCRYPT_V2_MODE = "fs_encrypt_v2";
    private static final String FS_ROOT_KEY_PATH = "root_key_path";
    private static final String FS_COMMON_SHARED_KEY_PATH = "common_shared_key_path";
    private static final String KEY_ARG = "key";
    private static final String PLAINTEXT_ARG = "text";
    private static final String GEN_NEW_WORK_KEY_MODE = "newkey";
    private static final String CIPHERTEXT_ARG = "cipher";
    private static final String NO_PWD_CHECKER_ARG = "no_password_check";

    /*
     * Loose catch block
     */
    public static void main(String[] args) {
        try {
            Options options;
            Throwable throwable;
            BufferedReader br;
            block51: {
                block52: {
                    block53: {
                        CommandLine commandLine;
                        block48: {
                            block49: {
                                block50: {
                                    block45: {
                                        block46: {
                                            block47: {
                                                block42: {
                                                    block43: {
                                                        block44: {
                                                            block39: {
                                                                block40: {
                                                                    block41: {
                                                                        block36: {
                                                                            block37: {
                                                                                block38: {
                                                                                    String lineStr;
                                                                                    br = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
                                                                                    throwable = null;
                                                                                    StringBuilder inputArgs = new StringBuilder();
                                                                                    while ((lineStr = br.readLine()) != null) {
                                                                                        inputArgs.append(lineStr);
                                                                                    }
                                                                                    String[] argsStrArray = inputArgs.toString().split(" ");
                                                                                    options = App.doOption();
                                                                                    DefaultParser commandLineParser = new DefaultParser();
                                                                                    commandLine = commandLineParser.parse(options, argsStrArray);
                                                                                    if (!commandLine.hasOption(GEN_NEW_WORK_KEY_MODE)) break block36;
                                                                                    App.genNewKey();
                                                                                    if (br == null) break block37;
                                                                                    if (throwable == null) break block38;
                                                                                    try {
                                                                                        br.close();
                                                                                    }
                                                                                    catch (Throwable throwable2) {
                                                                                        throwable.addSuppressed(throwable2);
                                                                                    }
                                                                                    break block37;
                                                                                }
                                                                                br.close();
                                                                            }
                                                                            return;
                                                                        }
                                                                        if (!commandLine.hasOption(ENCRYPT_MODE)) break block39;
                                                                        App.encData(commandLine.getOptionValues(ENCRYPT_MODE));
                                                                        if (br == null) break block40;
                                                                        if (throwable == null) break block41;
                                                                        try {
                                                                            br.close();
                                                                        }
                                                                        catch (Throwable throwable3) {
                                                                            throwable.addSuppressed(throwable3);
                                                                        }
                                                                        break block40;
                                                                    }
                                                                    br.close();
                                                                }
                                                                return;
                                                            }
                                                            if (!commandLine.hasOption(DECRYPT_MODE)) break block42;
                                                            App.decData(commandLine.getOptionValues(DECRYPT_MODE));
                                                            if (br == null) break block43;
                                                            if (throwable == null) break block44;
                                                            try {
                                                                br.close();
                                                            }
                                                            catch (Throwable throwable4) {
                                                                throwable.addSuppressed(throwable4);
                                                            }
                                                            break block43;
                                                        }
                                                        br.close();
                                                    }
                                                    return;
                                                }
                                                if (!commandLine.hasOption(FS_DECRYPT_MODE)) break block45;
                                                App.decFsData(commandLine.getOptionValues(FS_DECRYPT_MODE));
                                                if (br == null) break block46;
                                                if (throwable == null) break block47;
                                                try {
                                                    br.close();
                                                }
                                                catch (Throwable throwable5) {
                                                    throwable.addSuppressed(throwable5);
                                                }
                                                break block46;
                                            }
                                            br.close();
                                        }
                                        return;
                                    }
                                    if (!commandLine.hasOption(FS_ENCRYPT_MODE)) break block48;
                                    App.encFsData(PsmKeyEncryptor::encryptForV1, commandLine.getOptionValues(FS_ENCRYPT_MODE));
                                    if (br == null) break block49;
                                    if (throwable == null) break block50;
                                    try {
                                        br.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    break block49;
                                }
                                br.close();
                            }
                            return;
                        }
                        if (!commandLine.hasOption(FS_ENCRYPT_V2_MODE)) break block51;
                        App.encFsData(PsmKeyEncryptor::encryptForV2, commandLine.getOptionValues(FS_ENCRYPT_V2_MODE));
                        if (br == null) break block52;
                        if (throwable == null) break block53;
                        try {
                            br.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                        break block52;
                    }
                    br.close();
                }
                return;
            }
            try {
                App.helpFunc(options);
                System.exit(1);
                {
                    catch (ParseException e) {
                        SOUT.println(e.getMessage());
                        App.helpFunc(options);
                        System.exit(1);
                    }
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            catch (Throwable throwable9) {
                throw throwable9;
            }
            finally {
                if (br != null) {
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable10) {
                            throwable.addSuppressed(throwable10);
                        }
                    } else {
                        br.close();
                    }
                }
            }
        }
        catch (IOException e) {
            SOUT.println("Unable to read input! " + e.getMessage());
            System.exit(1);
        }
    }

    private static Options doOption() {
        Options options = new Options();
        Option newKeyOpt = new Option(GEN_NEW_WORK_KEY_MODE, false, "generate a new work key");
        options.addOption(newKeyOpt);
        Option encryptOpt = new Option(ENCRYPT_MODE, true, "encrypt plaintext to cipher");
        encryptOpt.setArgs(-2);
        options.addOption(encryptOpt);
        Option decryptOpt = new Option(DECRYPT_MODE, true, "decrypt cipher to plaintext");
        decryptOpt.setArgs(-2);
        options.addOption(decryptOpt);
        Option fsDecryptOpt = new Option(FS_DECRYPT_MODE, true, "decrypt fusion stage cipher to plaintext");
        fsDecryptOpt.setArgs(-2);
        options.addOption(fsDecryptOpt);
        Option fsEncryptOpt = new Option(FS_ENCRYPT_MODE, true, "encrypt plaintext to fusion stage cipher");
        fsEncryptOpt.setArgs(-2);
        options.addOption(fsEncryptOpt);
        Option fsEncryptV2Opt = new Option(FS_ENCRYPT_V2_MODE, true, "encrypt plaintext to fusion stage cipher (FS8.0)");
        fsEncryptV2Opt.setArgs(-2);
        options.addOption(fsEncryptV2Opt);
        return options;
    }

    private static void helpFunc(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("thisApp", options);
    }

    private static void decData(String[] decArgs) {
        Options options = new Options();
        Option keyOpt = new Option(KEY_ARG, true, "work key for decryption. if not given, default work key will be used");
        options.addOption(keyOpt);
        Option decryptionEnvironmentKey = new Option(CIPHERTEXT_ARG, true, "cipher text environment key for decryption");
        decryptionEnvironmentKey.setRequired(true);
        options.addOption(decryptionEnvironmentKey);
        DefaultParser commandLineParser = new DefaultParser();
        try {
            CommandLine commandLine = commandLineParser.parse(options, decArgs);
            String workKey = commandLine.getOptionValue(KEY_ARG);
            String deEnvKey = commandLine.getOptionValue(CIPHERTEXT_ARG);
            String cipherText = System.getenv(deEnvKey);
            String result = "";
            if (StringUtils.isNotEmpty((CharSequence)cipherText)) {
                try {
                    result = StringUtils.isEmpty((CharSequence)workKey) ? USEncryptor.decrypt(cipherText) : USEncryptor.decrypt((SecretKey)new SecretKeySpec(USCodec.decodeFromBase64(workKey), USCryptoConfig.ENCRYPTION_ALGORITHM), cipherText, "AES/GCM/PKCS5Padding");
                    result = USCmapReplacement.replace(result);
                }
                catch (IOException | EncryptionException e) {
                    SOUT.println("Decryption error! " + e.getMessage());
                    System.exit(1);
                }
            }
            SOUT.println(result);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("thisApp -decrypt", options);
            System.exit(1);
        }
    }

    private static void encData(String[] encArgs) {
        Options options = new Options();
        Option keyOpt = new Option(KEY_ARG, true, "work key for encryption. if not given, default work key will be used");
        options.addOption(keyOpt);
        Option plaintextOpt = new Option(PLAINTEXT_ARG, true, "plaintext for encryption");
        plaintextOpt.setRequired(true);
        options.addOption(plaintextOpt);
        Option passCheckerOpt = new Option(NO_PWD_CHECKER_ARG, false, "no password validation checker");
        passCheckerOpt.setRequired(false);
        options.addOption(passCheckerOpt);
        DefaultParser commandLineParser = new DefaultParser();
        try {
            CommandLine commandLine = commandLineParser.parse(options, encArgs);
            String workKey = commandLine.getOptionValue(KEY_ARG);
            String plaintext = commandLine.getOptionValue(PLAINTEXT_ARG);
            if (!commandLine.hasOption(NO_PWD_CHECKER_ARG) && !PwdComplexUtils.checkPwd((String)plaintext)) {
                SOUT.println("password validation checker not passed");
                System.exit(1);
            }
            String result = null;
            try {
                result = workKey == null ? USEncryptor.encrypt(plaintext) : USEncryptor.encrypt((SecretKey)new SecretKeySpec(USCodec.decodeFromBase64(workKey), USCryptoConfig.ENCRYPTION_ALGORITHM), plaintext, "AES/GCM/PKCS5Padding");
            }
            catch (IOException | InvalidKeyException | NoSuchAlgorithmException | EncryptionException e) {
                SOUT.println("Encryption error! " + e.getMessage());
                System.exit(1);
            }
            SOUT.println(result);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("thisApp -encrypt", options);
            System.exit(1);
        }
    }

    private static void encFsData(Function<String, String> encFunc, String[] encArgs) {
        Options options = new Options();
        App.addFsOptions(options);
        Option textToEnc = new Option(PLAINTEXT_ARG, true, "cipher text environment key for decryption");
        textToEnc.setRequired(true);
        options.addOption(textToEnc);
        Option passCheckerOpt = new Option(NO_PWD_CHECKER_ARG, false, "no password validation checker");
        passCheckerOpt.setRequired(false);
        options.addOption(passCheckerOpt);
        String fsRootKeyPathVal = null;
        String fsCommonSharedKeyPathVal = null;
        String plainText = null;
        DefaultParser commandLineParser = new DefaultParser();
        try {
            CommandLine commandLine = commandLineParser.parse(options, encArgs);
            fsRootKeyPathVal = commandLine.getOptionValue(FS_ROOT_KEY_PATH);
            fsCommonSharedKeyPathVal = commandLine.getOptionValue(FS_COMMON_SHARED_KEY_PATH);
            plainText = commandLine.getOptionValue(PLAINTEXT_ARG);
            if (!commandLine.hasOption(NO_PWD_CHECKER_ARG) && !PwdComplexUtils.checkPwd((String)plainText)) {
                SOUT.println("password validation checker not passed");
                System.exit(1);
            }
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("thisApp -fs_encrypt", options);
            System.exit(1);
        }
        try {
            if (StringUtils.isEmpty((CharSequence)fsRootKeyPathVal) || StringUtils.isEmpty((CharSequence)fsCommonSharedKeyPathVal) || StringUtils.isEmpty((CharSequence)plainText)) {
                SOUT.println("invalid parameters");
                System.exit(1);
            }
            PsmKeyEncryptor.init(fsRootKeyPathVal, fsCommonSharedKeyPathVal);
            SOUT.println(encFunc.apply(plainText));
        }
        catch (IOException | RuntimeException e) {
            SOUT.println("Encrypt to Psm Cipher error! " + e.getMessage());
            System.exit(1);
        }
    }

    private static void decFsData(String[] decArgs) {
        Options options = new Options();
        App.addFsOptions(options);
        Option decryptionEnvironmentKey = new Option(CIPHERTEXT_ARG, true, "cipher text environment key for decryption");
        decryptionEnvironmentKey.setRequired(true);
        options.addOption(decryptionEnvironmentKey);
        String fsRootKeyPathVal = null;
        String fsCommonSharedKeyPathVal = null;
        String cipherText = null;
        DefaultParser commandLineParser = new DefaultParser();
        try {
            CommandLine commandLine = commandLineParser.parse(options, decArgs);
            fsRootKeyPathVal = commandLine.getOptionValue(FS_ROOT_KEY_PATH);
            fsCommonSharedKeyPathVal = commandLine.getOptionValue(FS_COMMON_SHARED_KEY_PATH);
            cipherText = System.getenv(commandLine.getOptionValue(CIPHERTEXT_ARG));
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("thisApp -fs_decrypt", options);
            System.exit(1);
        }
        try {
            if (StringUtils.isEmpty((CharSequence)fsRootKeyPathVal) || StringUtils.isEmpty((CharSequence)fsCommonSharedKeyPathVal) || StringUtils.isEmpty((CharSequence)cipherText)) {
                SOUT.println("invalid parameters");
                System.exit(1);
            }
            PsmKeyDecryptor.initDecryptor(fsRootKeyPathVal, fsCommonSharedKeyPathVal);
            SOUT.println(USCmapReplacement.replace(PsmKeyDecryptor.decrypt(cipherText)));
        }
        catch (IOException | RuntimeException e) {
            SOUT.println("Decrypt cipher text of fusion stage error! " + e.getMessage());
            System.exit(1);
        }
    }

    private static void genNewKey() {
        String newKey = USKeyManager.getNewWorkKeyCipher();
        SOUT.println("New key:" + newKey);
    }

    private static void addFsOptions(Options options) {
        assert (Objects.nonNull(options));
        Option rootKeyPathOption = new Option(FS_ROOT_KEY_PATH, true, "root key path of fusion stage");
        rootKeyPathOption.setRequired(true);
        options.addOption(rootKeyPathOption);
        Option commonSharedKeyPathOption = new Option(FS_COMMON_SHARED_KEY_PATH, true, "common shared key path of fusion stage");
        commonSharedKeyPathOption.setRequired(true);
        options.addOption(commonSharedKeyPathOption);
    }
}

