/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.crypto;

import com.huawei.us.common.codec.USCodec;
import com.huawei.us.common.crypto.USCryptoBase;
import com.huawei.us.common.crypto.USCryptoConfig;
import com.huawei.us.common.crypto.USKeyManager;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.owasp.esapi.crypto.CipherText;
import org.owasp.esapi.crypto.PlainText;
import org.owasp.esapi.errors.EncryptionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class USEncryptor {
    private static final Logger logger = LoggerFactory.getLogger(USEncryptor.class);

    private USEncryptor() {
    }

    public static String encrypt(String string) throws EncryptionException, IOException, InvalidKeyException {
        try {
            return USEncryptor.encrypt(USEncryptor.getWorkKey(), string, USCryptoConfig.DEFAULT_CIPHER_TRANSFORMATION);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("default cipher transformation prefix is not AES");
        }
    }

    public static String encrypt(SecretKey secretKey, String plainText, String xform) throws EncryptionException, IOException, InvalidKeyException, NoSuchAlgorithmException {
        return USEncryptor.encryptPlainText(secretKey, new PlainText(plainText), xform);
    }

    public static String encrypt(SecretKey secretKey, byte[] plainBytes, String xform) throws EncryptionException, IOException, InvalidKeyException, NoSuchAlgorithmException {
        return USEncryptor.encryptPlainText(secretKey, new PlainText(plainBytes), xform);
    }

    private static String encryptPlainText(SecretKey secretKey, PlainText plainText, String xform) throws InvalidKeyException, NoSuchAlgorithmException, EncryptionException, IOException {
        if (!USEncryptor.isKeylenValid(secretKey)) {
            throw new InvalidKeyException("Actual key size is samller than 128 bits!");
        }
        if (!"AES".equalsIgnoreCase(xform.split("/")[0])) {
            throw new NoSuchAlgorithmException("Do not use algorithm other than AES.");
        }
        CipherText cipherText = USCryptoBase.encrypt(secretKey, plainText, xform);
        return USCodec.encodeForHex(USCodec.decodeFromBase64(cipherText.getEncodedIVCipherText()));
    }

    public static String[] encrypt(String[] plainTextArray) throws EncryptionException, IOException, InvalidKeyException, NoSuchAlgorithmException {
        return USEncryptor.encrypt(USEncryptor.getWorkKey(), plainTextArray, USCryptoConfig.DEFAULT_CIPHER_TRANSFORMATION);
    }

    public static String[] encrypt(SecretKey secretKey, String[] plainTextArray, String xform) throws EncryptionException, IOException, NoSuchAlgorithmException, InvalidKeyException {
        if (ArrayUtils.isEmpty((Object[])plainTextArray)) {
            throw new IllegalArgumentException("plainTextArray arg may not be null.");
        }
        int size = plainTextArray.length;
        String[] cipherTextArray = new String[size];
        for (int i = 0; i < size; ++i) {
            cipherTextArray[i] = USEncryptor.encrypt(secretKey, plainTextArray[i], xform);
        }
        return cipherTextArray;
    }

    public static String decrypt(String rawCipher) throws EncryptionException {
        return USEncryptor.decrypt(USEncryptor.getWorkKey(), rawCipher, USCryptoConfig.DEFAULT_CIPHER_TRANSFORMATION);
    }

    public static String decrypt(SecretKey secretKey, String rawCipher, String xform) throws EncryptionException {
        return USCryptoBase.decryptForPlainText(secretKey, rawCipher, xform).toString();
    }

    public static byte[] decryptToBytes(SecretKey secretKey, String rawCipher, String xform) throws EncryptionException {
        return USCryptoBase.decryptForPlainText(secretKey, rawCipher, xform).asBytes();
    }

    public static String[] decrypt(String[] rawCipherArray) throws EncryptionException {
        SecretKey secretKey = USEncryptor.getWorkKey();
        return USEncryptor.decrypt(secretKey, rawCipherArray, USCryptoConfig.DEFAULT_CIPHER_TRANSFORMATION);
    }

    public static String[] decrypt(SecretKey secretKey, String[] rawCipherArray, String xform) throws EncryptionException {
        if (ArrayUtils.isEmpty((Object[])rawCipherArray)) {
            throw new IllegalArgumentException("rawCipherArray arg may not be null.");
        }
        int size = rawCipherArray.length;
        String[] plaintextArray = new String[size];
        for (int i = 0; i < size; ++i) {
            plaintextArray[i] = USEncryptor.decrypt(secretKey, rawCipherArray[i], xform);
        }
        return plaintextArray;
    }

    public static String decryptForScript(String rawCipher) throws EncryptionException {
        return String.valueOf(USEncryptor.reverse(USEncryptor.cmapReplace(USEncryptor.decrypt(rawCipher))));
    }

    public static String decryptForScript(SecretKey secretKey, String rawCipher, String xform) throws EncryptionException {
        return String.valueOf(USEncryptor.reverse(USEncryptor.cmapReplace(USEncryptor.decrypt(secretKey, rawCipher, xform))));
    }

    public static String decryptByRoot(String rawCipher) throws EncryptionException, NoSuchAlgorithmException, InvalidKeyException, IOException {
        return USEncryptor.decrypt(USKeyManager.getMasterKey(), rawCipher, USCryptoConfig.DEFAULT_CIPHER_TRANSFORMATION);
    }

    private static boolean isKeylenValid(SecretKey key) {
        return key.getEncoded().length >= 16;
    }

    private static char[] cmapReplace(String input) {
        if (input == null) {
            return null;
        }
        char[] des = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        char[] ens = new char[]{'2', 'J', '5', 'L', 'n', 'c', 'h', 's', '7', 'E', 'C', 'Q', 'V', 'T', 'R', 'f', 'q', 'X', 'k', '4', 'b', 'U', 'r', 'H', 'x', 'v', 'B', 'I', 'd', '3', 'm', 'A', 'o', 't', 'K', 'M', 'g', 'e', 'F', 'D', 'a', 'S', 'u', 'w', 'G', 'z', 'Y', 'O', 'W', 'y', '8', 'l', 'Z', 'i', 'N', '0', 'j', '9', '6', '1', 'P', 'p'};
        char[] inputArr = input.toCharArray();
        block0: for (int i = 0; i < inputArr.length; ++i) {
            for (int j = 0; j < des.length; ++j) {
                if (inputArr[i] != des[j]) continue;
                inputArr[i] = ens[j];
                continue block0;
            }
        }
        return inputArr;
    }

    private static SecretKey getWorkKey() throws EncryptionException {
        try {
            return USKeyManager.getWorkKey();
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new EncryptionException("Get work key failed", "Get work key failed", (Throwable)e);
        }
    }

    private static char[] reverse(char[] input) {
        char[] output = input;
        int min = 0;
        for (int max = output.length - 1; min < max; ++min, --max) {
            char tem = output[min];
            output[min] = output[max];
            output[max] = tem;
        }
        return output;
    }

    static {
        try {
            Class<?> clazz = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
            if (clazz != null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError | RuntimeException e) {
            logger.warn("add BouncyCastleProvider failed, use default one");
        }
    }
}

