/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.crypto;

import com.huawei.us.common.codec.USCodec;
import com.huawei.wsf.core.HWDecoder;
import java.io.IOException;
import java.util.Arrays;

class USKeyUtils {
    private static final int IV_LEN = 16;

    private USKeyUtils() {
    }

    static byte[] xorBase64Strings(String key1, String key2) throws IOException {
        byte[] array1 = HWDecoder.decodeFromBase64((String)key1);
        byte[] array2 = HWDecoder.decodeFromBase64((String)key2);
        return USKeyUtils.xor(array1, array2);
    }

    static byte[] xorHexStrings(String key1, String key2) {
        byte[] array1 = USCodec.decodeForHex(key1);
        byte[] array2 = USCodec.decodeForHex(key2);
        return USKeyUtils.xor(array1, array2);
    }

    private static byte[] xor(byte[] array_1, byte[] array_2) {
        if (array_1.length != array_2.length) {
            throw new IllegalArgumentException("invalid properties");
        }
        byte[] result = new byte[array_1.length];
        int index = 0;
        for (byte bTemp : array_1) {
            result[index] = (byte)(bTemp ^ array_2[index]);
            ++index;
        }
        return result;
    }

    static byte[] getIvFromCipher(byte[] cipherBytes) {
        return Arrays.copyOfRange(cipherBytes, 0, 16);
    }

    static byte[] getContentFromCipher(byte[] cipherBytes) {
        return Arrays.copyOfRange(cipherBytes, 16, cipherBytes.length);
    }
}

