/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.Validation;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public final class LockUtils {
    private LockUtils() {
    }

    public static Lock newReentrantLock() {
        return new ReentrantLock();
    }

    public static ReadWriteLock newReentrantReadWriteLock() {
        return new ReentrantReadWriteLock();
    }

    public static Object newSynchronizedLock() {
        return new byte[0];
    }

    public static boolean synchronize(Lock lock, BooleanSupplier supplier) {
        Validation.notNull(supplier, "The supplier to get value cannot be null.", new Object[0]);
        if (lock == null) {
            return supplier.getAsBoolean();
        }
        lock.lock();
        try {
            boolean bl = supplier.getAsBoolean();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public static int synchronize(Lock lock, IntSupplier supplier) {
        Validation.notNull(supplier, "The supplier to get value cannot be null.", new Object[0]);
        if (lock == null) {
            return supplier.getAsInt();
        }
        lock.lock();
        try {
            int n = supplier.getAsInt();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public static void synchronize(Lock lock, Runnable action) {
        Validation.notNull(action, "The action to perform synchronously cannot be null.", new Object[0]);
        if (lock == null) {
            action.run();
            return;
        }
        lock.lock();
        try {
            action.run();
        }
        finally {
            lock.unlock();
        }
    }

    public static <T> T synchronize(Lock lock, Supplier<T> supplier) {
        Validation.notNull(supplier, "The supplier to get value cannot be null.", new Object[0]);
        if (lock == null) {
            return supplier.get();
        }
        lock.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }
}

