/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.CharacterUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.UUID;

public final class UuidUtils {
    public static final char SEPARATOR = '-';

    private UuidUtils() {
    }

    public static boolean isUuidCharacter(char ch) {
        return CharacterUtils.between(ch, '0', '9', true, true) || CharacterUtils.between(ch, 'a', 'f', true, true) || CharacterUtils.between(ch, 'A', 'F', true, true);
    }

    public static boolean isUuidCharacterSequence(CharSequence chars, int from, int to) {
        Validation.greaterThanOrEquals(from, 0, "The start index of char sequence cannot be negative. [from={0}]", new Object[]{from});
        Validation.between(to, from, chars.length(), "The end index of char sequence is out of range. [from={0}, to={1}, charsLength={2}]", from, to, chars.length());
        for (int i = from; i < to; ++i) {
            if (UuidUtils.isUuidCharacter(chars.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUuidString(String uuid) {
        return UuidUtils.isUuidString(uuid, false);
    }

    public static boolean isUuidString(String uuid, boolean ignoreSeparator) {
        return ignoreSeparator ? UuidUtils.isUuid32(uuid) : UuidUtils.isUuid36(uuid);
    }

    public static String randomUuidString() {
        return UUID.randomUUID().toString();
    }

    private static boolean isUuid32(String uuid) {
        if (StringUtils.isBlank(uuid) || uuid.length() != 32) {
            return false;
        }
        return UuidUtils.isUuidCharacterSequence(uuid, 0, 32);
    }

    private static boolean isUuid36(String uuid) {
        if (StringUtils.isBlank(uuid) || uuid.length() != 36) {
            return false;
        }
        int[] lengths = new int[]{8, 4, 4, 4, 12};
        boolean ret = UuidUtils.isUuidCharacterSequence(uuid, 0, lengths[0]);
        int index = lengths[0];
        for (int i = 1; ret && i < lengths.length; ++i) {
            int start = index + 1;
            int end = start + lengths[i];
            ret = uuid.charAt(index) == '-' && UuidUtils.isUuidCharacterSequence(uuid, start, end);
            index = end;
        }
        return ret;
    }
}

