/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util.support;

import com.huawei.fitframework.core.common.util.Disposable;
import com.huawei.fitframework.core.common.util.DisposedCallback;

class DisposedCallbackGroup
implements DisposedCallback {
    private final DisposedCallback callback1;
    private final DisposedCallback callback2;

    private DisposedCallbackGroup(DisposedCallback callback1, DisposedCallback callback2) {
        this.callback1 = callback1;
        this.callback2 = callback2;
    }

    @Override
    public void onDisposed(Disposable disposable) {
        this.callback1.onDisposed(disposable);
        this.callback2.onDisposed(disposable);
    }

    static DisposedCallback combine(DisposedCallback current, DisposedCallback another) {
        if (current == null) {
            return another;
        }
        if (another == null) {
            return current;
        }
        return new DisposedCallbackGroup(current, another);
    }

    static DisposedCallback remove(DisposedCallback current, DisposedCallback another) {
        if (current == another) {
            return null;
        }
        if (!(current instanceof DisposedCallbackGroup)) {
            return current;
        }
        DisposedCallbackGroup group = (DisposedCallbackGroup)current;
        DisposedCallback removedCallback1 = DisposedCallbackGroup.remove(group.callback1, another);
        if (removedCallback1 != group.callback1) {
            return DisposedCallbackGroup.combine(removedCallback1, group.callback2);
        }
        DisposedCallback removedCallback2 = DisposedCallbackGroup.remove(group.callback2, another);
        if (removedCallback2 == group.callback2) {
            return group;
        }
        return DisposedCallbackGroup.combine(group.callback1, removedCallback2);
    }
}

