/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicegraph.ui.components;

import com.huawei.ism.tool.devicegraph.Constants;
import com.huawei.ism.tool.devicegraph.config.DeviceGraphConfig;
import com.huawei.ism.tool.devicegraph.ui.components.EnclosureGraph;
import com.huawei.ism.tool.devicegraph.util.GraphUtils;
import com.huawei.ism.tool.framework.pubservice.hardware.IEnclosureInfo;
import com.huawei.ism.tool.framework.pubservice.hardware.IHardwareInfo;
import com.mxgraph.view.mxGraph;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RackPanel
extends JPanel {
    private static final long serialVersionUID = 1036030268210424219L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RackPanel.class);
    private static final String RACK_BACK_IMAGE = Constants.RACK_BACK_IMAGE;
    private static final String RACK_FRONT_IMAGE = Constants.RACK_FRONT_IMAGE;
    private boolean isBack;
    private boolean isIdSMB0;
    private int rackIndex;
    private String bayId;
    private List<EnclosureGraph> graphList = new ArrayList<EnclosureGraph>();
    private List<IEnclosureInfo> enclosureList = new ArrayList<IEnclosureInfo>();
    private List<IHardwareInfo> allSubModules = new ArrayList<IHardwareInfo>();

    public RackPanel(List<IEnclosureInfo> enclosureList, List<IHardwareInfo> allSubModules, int rackIndex, String bayId, boolean isBack) {
        this.isBack = isBack;
        this.rackIndex = rackIndex;
        this.bayId = bayId;
        this.enclosureList.addAll(enclosureList);
        this.allSubModules.addAll(allSubModules);
        this.initEnclosure(enclosureList, rackIndex);
        Dimension rackDimension = new Dimension(Constants.RACK_WIDTH, Constants.RACK_HEIGHT);
        GraphUtils.setChangelessSize(this, rackDimension);
        this.setOpaque(false);
    }

    public int getRackIndex() {
        return this.rackIndex;
    }

    public boolean isSMB0() {
        return this.isIdSMB0;
    }

    public List<IEnclosureInfo> getEnclosureList() {
        return this.enclosureList;
    }

    public List<EnclosureGraph> getEnclosureGraphList() {
        return this.graphList;
    }

    private void initEnclosure(List<IEnclosureInfo> enList, int rackIdx) {
        this.setLayout(null);
        this.graphList.clear();
        for (IEnclosureInfo info : GraphUtils.sort(enList)) {
            List<IHardwareInfo> subModules = this.getSubModulesInEn(info.getName());
            try {
                EnclosureGraph graph = new EnclosureGraph(info, subModules, this.isBack, new mxGraph());
                graph.setSize(graph.getEnclosureWidth(), graph.getEnclosureHeight());
                graph.setLocation(GraphUtils.getEnclosureCoordinateX(graph));
                graph.setRackIndex(rackIdx);
                this.graphList.add(graph);
                this.add(graph);
            }
            catch (Exception e) {
                LOGGER.error("initEnclosure error: ", e);
            }
        }
    }

    private List<IHardwareInfo> getSubModulesInEn(String enName) {
        ArrayList<IHardwareInfo> subModules = new ArrayList<IHardwareInfo>();
        for (IHardwareInfo subModule : this.allSubModules) {
            String[] locArrays = subModule.getLocation().split("\\.");
            if (!enName.equals(locArrays[0])) continue;
            subModules.add(subModule);
        }
        return subModules;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Image img;
        super.paintComponent(graphics);
        String imgName = RACK_FRONT_IMAGE;
        if (this.isBack) {
            imgName = RACK_BACK_IMAGE;
        }
        if ((img = DeviceGraphConfig.getInstance().getImage(imgName).getImage()) != null) {
            graphics.drawImage(img, 0, 0, Constants.RACK_WIDTH, Constants.RACK_HEIGHT, this);
        }
    }

    public void setSMB0(boolean smb) {
        this.isIdSMB0 = smb;
    }

    public String getBayId() {
        return this.bayId;
    }

    public List<IHardwareInfo> getAllSubModules() {
        return this.allSubModules;
    }
}

