/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicegraph.util;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import org.slf4j.Logger;

public final class DeviceOperationUtils {
    public static final int INVALID_BAY_INDEX = -1;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DeviceOperationUtils.class);
    private static final String SYS_BAY_PREFIX = "SMB";
    private static final String DISK_BAY_PREFIX = "DKB";
    private static final String DISK_BAY_SPLIT_REGEX = "_";

    private DeviceOperationUtils() {
    }

    public static int getSysBayIndex(String bayId) {
        int bayIndex = 0;
        try {
            if (bayId.startsWith(SYS_BAY_PREFIX)) {
                bayIndex = Integer.parseInt(bayId.substring(SYS_BAY_PREFIX.length(), SYS_BAY_PREFIX.length() + 1));
            } else if (bayId.startsWith(DISK_BAY_PREFIX)) {
                bayIndex = Integer.parseInt(bayId.substring(DISK_BAY_PREFIX.length(), DISK_BAY_PREFIX.length() + 1));
            } else {
                LOGGER.error("The input bayId is invalid: " + bayId);
                bayIndex = -1;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), e);
            bayIndex = -1;
        }
        return bayIndex;
    }

    public static int getDiskBayIndex(String bayId) {
        int bayIndex = 0;
        if (!bayId.startsWith(DISK_BAY_PREFIX)) {
            LOGGER.error("The input bayId is invalid: " + bayId);
            return -1;
        }
        try {
            bayIndex = Integer.parseInt(bayId.substring(bayId.length() - 1));
            if (bayId.contains(DISK_BAY_SPLIT_REGEX)) {
                String[] bayInfoList = bayId.split(DISK_BAY_SPLIT_REGEX);
                bayIndex = Integer.parseInt(bayInfoList[bayInfoList.length - 1]);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), e);
            bayIndex = -1;
        }
        return bayIndex;
    }
}

