/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.driver;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicecenter.driver.cmd.CallToolThread;
import com.huawei.ism.tool.devicecenter.driver.manager.CmdManager;
import com.huawei.ism.tool.devicecenter.driver.model.DriverParams;
import com.huawei.ism.tool.devicecenter.driver.model.DriverResult;
import com.huawei.ism.tool.devicecenter.driver.model.ModelDriver;
import com.huawei.ism.tool.devicecenter.driver.model.TaskType;
import com.huawei.ism.tool.devicecenter.driver.model.ThirdPartyTool;
import com.huawei.ism.tool.devicecenter.driver.model.ToolService;
import com.huawei.ism.tool.devicecenter.driver.utils.DriverContext;
import com.huawei.ism.tool.devicecenter.driver.utils.DriverUtils;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.service.DeviceControl;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CmdModelDriver
extends ModelDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmdModelDriver.class);
    private String workPath = "";
    private ThirdPartyTool tool;
    private ToolService service;
    private static final String TEMP = "temp";
    private static final String DRIVER_DEBUG_BACKUP = "driverDebugBackup";

    public CmdModelDriver(ThirdPartyTool pTool, ToolService serviceParam) {
        this.tool = pTool;
        this.service = serviceParam;
        super.setOverTime(serviceParam.getServiceTimeout());
        for (TaskType taskType : TaskType.values()) {
            if (!serviceParam.getServiceName().equalsIgnoreCase(taskType.getName())) continue;
            super.setDriverType(taskType);
        }
    }

    @Override
    public String exec(List<AbstractDevice> deviceList, List<KeyValue<String, String>> paramList, String taskId, String pWorkPath) {
        DriverParams param = new DriverParams(deviceList, paramList);
        param.setDecryptCode(DriverUtils.generateTaskKey(128));
        this.setWorkPath(this.getDriverWorkpath(pWorkPath, taskId));
        String taskFilePath = null;
        try {
            taskFilePath = this.createTaskFile(param);
        }
        catch (ToolException e) {
            LOGGER.error("create taskFile.xml error, driver will not execute.");
            return "";
        }
        this.callToolRun(param, taskFilePath);
        if (taskFilePath.contains(DriverContext.WORK_ROOTPATH)) {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append(DriverContext.WORK_ROOTPATH).append(File.separator).append(taskId);
            DeviceControl.getInstance().setFilePath(strBuilder.toString());
        }
        return "";
    }

    private void callToolRun(DriverParams param, String taskFilePath) {
        String toolPath = DriverContext.TOOL_ROOT_PATH + File.separator + this.tool.getName();
        File file = new File(toolPath);
        try {
            toolPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("Standardization path failure.");
            return;
        }
        String batId = CmdManager.createStartDriverCmd(taskFilePath, toolPath, this.service, param);
        DriverContext.getInstance().getCmdDriverExcutor().execute(new CallToolThread(batId));
    }

    private String createTaskFile(DriverParams param) throws ToolException {
        String taskFilePath = null;
        taskFilePath = this.constructTaskFilePath();
        boolean isCreatedTaskFileSuccessful = false;
        isCreatedTaskFileSuccessful = DriverUtils.createTaskFile(taskFilePath, this.workPath, param, this.getDriverType());
        if (!isCreatedTaskFileSuccessful) {
            throw new ToolException("create taskFile.xml error.");
        }
        LOGGER.info("taskFile.xml create success.");
        return taskFilePath;
    }

    private String constructTaskFilePath() {
        File workpathDir = new File(this.workPath);
        if (!workpathDir.exists()) {
            FileUtils.createDir((File)workpathDir);
        }
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(this.workPath).append(File.separator).append("taskFile.xml");
        return pathBuilder.toString();
    }

    @Override
    public DriverResult queryResult(String pWorkpath, String taskId) {
        DriverResult result = new DriverResult();
        result.setOverTime(this.getOverTime());
        StringBuffer taskProgressFilePath = new StringBuffer();
        taskProgressFilePath.append(this.getDriverWorkpath(pWorkpath, taskId)).append(File.separator).append("Progress.xml");
        File taskProgressFile = new File(taskProgressFilePath.toString());
        if (!taskProgressFile.exists()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("taskProgressFile is not exsit " + taskProgressFilePath.toString());
            }
            return result;
        }
        result = this.parseProgress(taskProgressFile, this.getOverTime());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DriverResult parseProgress(File progressfile, long overTime) {
        DriverResult result = null;
        FileInputStream input = null;
        try {
            input = new FileInputStream(progressfile);
            Document doc = com.huawei.ism.tool.base.utils.XmlUtils.parseDocument((InputStream)input);
            if (null == doc) {
                DriverResult driverResult = null;
                return driverResult;
            }
            doc.getDocumentElement().normalize();
            Element progressEle = XmlUtils.getRootElement(doc, "progress");
            result = DriverUtils.parseProgressTotalInfo(progressEle, overTime);
            Collection<Element> deviceElementList = XmlUtils.getChildren(progressEle, "device");
            result.setDeviceProgressList(DriverUtils.parseDeviceProgress(deviceElementList));
            if (result.getDeviceProgressList().isEmpty()) {
                LOGGER.warn("No result found");
                DriverResult driverResult = null;
                return driverResult;
            }
        }
        catch (Exception e) {
            LOGGER.error("analysis progress file error.", (Throwable)e);
            DriverResult driverResult = null;
            return driverResult;
        }
        finally {
            StreamUtils.closeResource(null, (Closeable)input);
        }
        return result;
    }

    private String getDriverWorkpath(String pWorkPath, String taskId) {
        StringBuilder pathBuilder = new StringBuilder();
        if (StringUtils.isNULLStr((String)pWorkPath)) {
            pathBuilder.append(DriverContext.WORK_ROOTPATH).append(File.separator).append(taskId).append(File.separator).append(this.tool.getName());
            return pathBuilder.toString();
        }
        pathBuilder.append(pWorkPath);
        return pathBuilder.toString();
    }

    public String getWorkPath() {
        return this.workPath;
    }

    public void setWorkPath(String workPath) {
        this.workPath = workPath;
    }

    public ToolService getService() {
        return this.service;
    }

    public void setService(ToolService service) {
        this.service = service;
    }

    public int getTimeout() {
        return this.service.getServiceTimeout();
    }

    public ThirdPartyTool getTool() {
        return this.tool;
    }

    public void setTool(ThirdPartyTool tool) {
        this.tool = tool;
    }

    @Override
    public void clearProcessFile(String workpath, String taskId, boolean deleteDir) {
        File file;
        File parentFile;
        String driverWorkpath = this.getDriverWorkpath(workpath, taskId);
        StringBuffer taskProgressFilePath = new StringBuffer();
        taskProgressFilePath.append(driverWorkpath).append(File.separator).append("Progress.xml");
        File taskProgressFile = new File(taskProgressFilePath.toString().trim());
        if (taskProgressFile.exists()) {
            FileUtils.deleteFile((File)taskProgressFile);
        }
        StringBuffer deviceFilePath = new StringBuffer();
        deviceFilePath.append(driverWorkpath).append(File.separator).append("taskFile.xml");
        File deviceFile = new File(deviceFilePath.toString().trim());
        if (deviceFile.exists()) {
            FileUtils.deleteFile((File)deviceFile);
        }
        if (deleteDir && (parentFile = (file = new File(driverWorkpath)).getParentFile()).exists()) {
            FileUtils.deleteFile((File)parentFile);
        }
    }

    @Override
    public void backupProcessFile(String workpath, String taskId) {
        String driverWorkpath = this.getDriverWorkpath(workpath, taskId);
        StringBuilder driverMidwayFileBackup = new StringBuilder().append(ApplicationContext.getInstance().getWorkPath()).append(File.separator).append(TEMP).append(File.separator).append(DRIVER_DEBUG_BACKUP);
        String driverMidwayFileBackupPath = driverMidwayFileBackup.toString();
        String driverFileBackupTimePath = driverMidwayFileBackup.append(File.separator).append(taskId).toString();
        String regularizedWorkPath = FilePathUtils.checkFile((String)driverWorkpath);
        String copyDir = FilePathUtils.checkFile((String)driverMidwayFileBackupPath);
        if (null == regularizedWorkPath || null == copyDir) {
            return;
        }
        FileUtils.createDir((String)copyDir);
        FileUtils.createDir((String)driverFileBackupTimePath);
        File taskProgressFile = new File(regularizedWorkPath);
        if (taskProgressFile.exists()) {
            FileUtils.copyDir((String)regularizedWorkPath, (String)copyDir);
        }
    }
}

