/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.driver.cmd;

import com.huawei.ism.tool.devicecenter.driver.cmd.CMDProccess;
import com.huawei.ism.tool.devicecenter.driver.cmd.Proccessor;
import com.huawei.ism.tool.devicecenter.driver.utils.DriverUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Optional;
import org.slf4j.Logger;

public class SHProcessor
extends Proccessor {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SHProcessor.class);
    private static final String TEMP_PATH = ApplicationContext.getInstance().getTmpPath() + File.separator + "cmd" + File.separator;
    private String cmd = null;
    private String name = "";

    public SHProcessor(String name, String cmd) {
        this.name = name;
        this.cmd = cmd;
    }

    private Optional<File> generateSh() {
        if (this.cmd == null) {
            return Optional.empty();
        }
        File file = DriverUtils.getCanonicalFile(TEMP_PATH);
        if (file == null) {
            LOGGER.error("TEMP_PATH is null.");
            return Optional.empty();
        }
        if (!file.exists() && !file.mkdirs()) {
            LOGGER.error("Create TEMP_PATH fail.");
            return Optional.empty();
        }
        String canonicalPath = null;
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("get canonical path file not found exception. file is: {}.", (Object)file.getName());
        }
        catch (IOException e) {
            LOGGER.error("get canonical path io exception.", (Throwable)e);
        }
        if (canonicalPath == null) {
            return Optional.empty();
        }
        SecureRandom random = new SecureRandom();
        long rand = random.nextLong();
        String filepath = canonicalPath + File.separator + "toolkit_dc" + rand + ".sh";
        File canonicalFile = DriverUtils.getCanonicalFile(filepath);
        DriverUtils.createFile(DriverUtils.getCanonicalFilePath(canonicalFile));
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(canonicalFile), StandardCharsets.UTF_8));){
            writer.write(this.cmd);
            writer.newLine();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("get path file not found exception. file is: {}.", (Object)canonicalFile.getName());
        }
        catch (IOException e) {
            LOGGER.error("write io exception.", (Throwable)e);
        }
        return Optional.of(canonicalFile);
    }

    @Override
    public CMDProccess getProcess() throws IOException {
        Optional<File> optionalFile = this.generateSh();
        if (!optionalFile.isPresent()) {
            return null;
        }
        File file = optionalFile.get();
        String cpath = file.getCanonicalPath();
        Process process = super.exec("bash " + cpath);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("exec sh " + this.name + ' ' + file.getName());
        }
        CMDProccess cp = new CMDProccess();
        cp.setProcess(process);
        cp.setFile(file);
        return cp;
    }
}

