/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.driver.manager;

import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.devicecenter.driver.cmd.BATProcessor;
import com.huawei.ism.tool.devicecenter.driver.cmd.CMDProccess;
import com.huawei.ism.tool.devicecenter.driver.cmd.Proccessor;
import com.huawei.ism.tool.devicecenter.driver.cmd.SHProcessor;
import com.huawei.ism.tool.devicecenter.driver.model.DriverParams;
import com.huawei.ism.tool.devicecenter.driver.model.ToolService;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import java.io.File;
import java.io.IOException;
import java.text.Normalizer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class CmdManager {
    public static final String START_FOR_BAT = "startForBat";
    public static final String START_FOR_SH = "startForSh";
    private static final String JAR_SUFFIX = ".jar";
    private static final String EXE_SUFFIX = ".exe";
    private static final String BAT_SUFFIX = ".bat";
    private static final String SH_SUFFIX = ".sh";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static Map<String, Proccessor> cmdProcesses = new ConcurrentHashMap<String, Proccessor>();
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CmdManager.class);

    public static String createStartDriverCmd(String toolWorkPath, String toolPath, ToolService service, DriverParams param) {
        StringBuffer cmd = CmdManager.getCommand(toolWorkPath, toolPath, service, param);
        String processesId = "startForSh_" + service.getServiceDomain();
        if (!ApplicationContext.getInstance().isWindowsOS()) {
            cmdProcesses.put(processesId, new SHProcessor(START_FOR_SH, cmd.toString()));
        } else {
            processesId = "startForBat_" + service.getServiceDomain();
            cmdProcesses.put(processesId, new BATProcessor(START_FOR_BAT, cmd.toString()));
        }
        return processesId;
    }

    private static StringBuffer getCommand(String toolWorkPath, String toolPath, ToolService service, DriverParams param) {
        StringBuffer cmd = new StringBuffer();
        if (service.getServiceDomain().equals("STORAGE")) {
            return CmdManager.getStorageCmd(toolWorkPath, toolPath, service, param);
        }
        if (service.getServiceDomain().equals("SERVER")) {
            return CmdManager.getServerCmd(toolWorkPath, toolPath, service, param);
        }
        return cmd;
    }

    private static StringBuffer getStorageCmd(String toolWorkPath, String toolPath, ToolService service, DriverParams param) {
        StringBuffer cmd = new StringBuffer();
        cmd.append("cd /d \"").append(toolPath).append('\"').append(NEW_LINE);
        cmd.append(CmdManager.getStartDriverCmd(service));
        cmd.append(" -callTool=toolkitDC");
        cmd.append(" -taskfile=\"").append(toolWorkPath).append('\"');
        cmd.append(" -securityKey=").append(param.getDecryptCode());
        if (service.getServiceName().equals("inspector")) {
            cmd.append(" -sence=").append("basic");
        } else {
            cmd.append(" -sence=").append(service.getServiceName());
        }
        return cmd;
    }

    private static StringBuffer getServerCmd(String toolWorkPath, String toolPath, ToolService service, DriverParams param) {
        StringBuffer cmd = new StringBuffer();
        StringBuilder cmdLog = new StringBuilder();
        if (ApplicationContext.getInstance().isWindowsOS()) {
            cmd.append("cd /d \"").append(toolPath).append('\"').append(NEW_LINE);
            cmd.append("set language=").append(LanguageManager.getInstance().getCurrentLanguage().getLanguage()).append(NEW_LINE);
            OSCmdUtils.addOptimizationParam((StringBuffer)cmd);
            cmd.append(CmdManager.getStartDriverCmd(service));
            cmd.append(" SmartKit");
            cmdLog = CmdManager.cmdServerBuildPublic(cmd, toolWorkPath, service, param);
        } else {
            cmd.append("#!/bin/sh").append(NEW_LINE);
            cmd.append("cd ").append(toolPath).append(NEW_LINE);
            cmd.append("language=").append(LanguageManager.getInstance().getCurrentLanguage().getLanguage()).append(NEW_LINE);
            cmd.append("sh ").append(CmdManager.getStartDriverCmd(service));
            cmdLog = CmdManager.cmdServerBuildPublic(cmd, toolWorkPath, service, param);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("cmdLog is {}.", (Object)cmdLog);
        }
        return cmd;
    }

    private static StringBuilder cmdServerBuildPublic(StringBuffer cmd, String toolWorkPath, ToolService service, DriverParams param) {
        StringBuilder cmdLog = new StringBuilder();
        if (ApplicationContext.getInstance().isWindowsOS()) {
            cmd.append(" -taskfile=\"").append(toolWorkPath).append('\"');
        } else {
            cmd.append(" -taskfile=").append(toolWorkPath);
        }
        cmdLog.append(cmd);
        cmd.append(" -securityKey=").append(param.getDecryptCode());
        cmdLog.append(" -securityKey=").append("undefined");
        cmd.append(" -sence=").append(service.getServiceName());
        cmdLog.append(" -sence=").append(service.getServiceName());
        return cmdLog;
    }

    private static String getStartDriverCmd(ToolService service) {
        if (ApplicationContext.getInstance().isWindowsOS()) {
            return CmdManager.getStartCmd(VerifyUtil.isEmpty((String)service.getPreferCommand()) ? service.getServiceCommand() : service.getPreferCommand());
        }
        return CmdManager.getStartCmd(service.getServiceLinuxCommand());
    }

    public static CMDProccess getProcess(String name) throws IOException {
        Proccessor cmdProccess = cmdProcesses.get(name);
        CMDProccess proccess = null;
        if (cmdProccess != null) {
            proccess = cmdProccess.getProcess();
        }
        if (proccess == null) {
            ToolLoggerFactory.getLogger(CmdManager.class).error("Failed to exec cmd:" + name);
        }
        return proccess;
    }

    private static String getStartCmd(String comand) {
        if (comand.endsWith(JAR_SUFFIX)) {
            StringBuffer startCommand = new StringBuffer();
            String toolkitPath = ApplicationContext.getInstance().getWorkPath();
            File jreDir = new File("jre");
            String java = jreDir.exists() ? (toolkitPath + File.separator + "jre\\bin\\java").replace(" ", "\" \"") : "java";
            startCommand.append(java).append(" -jar ").append(comand);
            return Normalizer.normalize(startCommand, Normalizer.Form.NFKC);
        }
        if (comand.endsWith(EXE_SUFFIX) || comand.endsWith(BAT_SUFFIX) || comand.endsWith(SH_SUFFIX)) {
            return comand;
        }
        return "";
    }
}

