/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.driver.manager;

import com.huawei.ism.tool.devicecenter.driver.CmdModelDriver;
import com.huawei.ism.tool.devicecenter.driver.manager.ThirdPartyToolManager;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.driver.model.ModelDriver;
import com.huawei.ism.tool.devicecenter.driver.model.TaskType;
import com.huawei.ism.tool.devicecenter.driver.model.ThirdPartyTool;
import com.huawei.ism.tool.devicecenter.driver.model.ToolService;
import com.huawei.ism.tool.devicecenter.driver.utils.DriverUtils;
import java.util.HashMap;
import java.util.Map;

public class DriverManage {
    private static DriverManage instance = new DriverManage();
    private Map<String, ModelDriver> driverMap = new HashMap<String, ModelDriver>();

    public DriverManage() {
        this.init();
    }

    public static DriverManage getInstance() {
        if (null == instance) {
            instance = new DriverManage();
        }
        return instance;
    }

    private void init() {
        for (ThirdPartyTool thirdPartyTool : ThirdPartyToolManager.getInstance().getThirdPartTools()) {
            for (ToolService service : thirdPartyTool.getToolServiceParams()) {
                ModelDriver driver = this.createCmdDriver(thirdPartyTool, service);
                this.addDriver(driver);
            }
        }
    }

    private ModelDriver createCmdDriver(ThirdPartyTool tool, ToolService service) {
        CmdModelDriver driver = null;
        driver = new CmdModelDriver(tool, service);
        driver.setDriverId(DriverUtils.generateDriverID(service.getServiceName(), service.getServiceDomain()));
        return driver;
    }

    public void addDriver(ModelDriver driver) {
        this.driverMap.put(driver.getDriverId(), driver);
    }

    public boolean delDriver(ModelDriver driver) {
        if (this.driverMap.containsKey(driver.getDriverId())) {
            this.driverMap.remove(driver.getDriverId());
            return true;
        }
        return false;
    }

    public ModelDriver getDriver(TaskType driverType, ITDeviceType field) {
        return this.getDriverById(DriverUtils.generateDriverID(driverType, field));
    }

    private ModelDriver getDriverById(String id) {
        if (this.driverMap.containsKey(id)) {
            return this.driverMap.get(id);
        }
        return null;
    }

    public Map<String, ModelDriver> getDriverMap() {
        return this.driverMap;
    }

    public void setDriverMap(Map<String, ModelDriver> driverMap) {
        this.driverMap = driverMap;
    }

    public void reInitDriverManager() {
        this.driverMap.clear();
        ThirdPartyToolManager.getInstance().reSearchTools();
        for (ThirdPartyTool thirdPartyTool : ThirdPartyToolManager.getInstance().getThirdPartTools()) {
            for (ToolService service : thirdPartyTool.getToolServiceParams()) {
                ModelDriver driver = this.createCmdDriver(thirdPartyTool, service);
                this.addDriver(driver);
            }
        }
    }
}

