/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.driver.model;

import com.huawei.ism.tool.devicecenter.driver.model.CommonStatus;
import com.huawei.ism.tool.devicecenter.driver.model.DeviceProgress;
import com.huawei.ism.tool.devicecenter.driver.model.TaskResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.stream.Collectors;

public class DriverResult {
    private long overTime;
    private CommonStatus status;
    private int progress;
    private Date updateTime;
    private TaskResult result;
    private String errMsg;
    private List<DeviceProgress> deviceProgressList = new ArrayList<DeviceProgress>();
    private boolean downReport = false;

    public DeviceProgress getDeviceProgressByDeviceIp(String ip) {
        if (null == this.deviceProgressList) {
            return new DeviceProgress();
        }
        for (DeviceProgress deviceProgress : this.deviceProgressList) {
            if (!deviceProgress.getIp().equalsIgnoreCase(ip)) continue;
            return deviceProgress;
        }
        return new DeviceProgress();
    }

    public List<DeviceProgress> getDeviceProgressList() {
        return this.deviceProgressList;
    }

    public void setDeviceProgressList(List<DeviceProgress> deviceProgressList) {
        this.deviceProgressList = deviceProgressList;
    }

    public CommonStatus getStatus() {
        return this.status;
    }

    public void setStatus(CommonStatus status) {
        this.status = status;
    }

    public Date getUpdateTime() {
        if (null != this.updateTime) {
            return (Date)this.updateTime.clone();
        }
        return null;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = (Date)updateTime.clone();
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public TaskResult getResult() {
        return this.result;
    }

    public void setResult(TaskResult result) {
        this.result = result;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public long getOverTime() {
        return this.overTime;
    }

    public void setOverTime(long overTime) {
        this.overTime = overTime;
    }

    public void clear() {
        this.setStatus(CommonStatus.WAITING);
        this.setErrMsg("");
        this.setProgress(0);
        this.setResult(TaskResult.ALL_FAILED);
        this.setUpdateTime(new Date());
        this.deviceProgressList.clear();
    }

    public boolean isDownReport() {
        return this.downReport;
    }

    public void setDownReport(boolean downReport) {
        this.downReport = downReport;
    }

    public void refreshProgress() {
        IntSummaryStatistics collect = this.getDeviceProgressList().stream().map(DeviceProgress::getProgress).collect(Collectors.summarizingInt(progress -> progress));
        this.progress = (int)collect.getAverage();
    }
}

