/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.driver.utils;

import com.huawei.ism.tool.base.utils.XmlWriter;
import com.huawei.ism.tool.devicecenter.driver.model.DriverParams;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.driver.model.TaskType;
import com.huawei.ism.tool.devicecenter.driver.utils.DriverUtils;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.HMMDevice;
import com.huawei.ism.tool.devicecenter.entity.IBMCDevice;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DevEleParseThread
implements Callable<List<Element>> {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DevEleParseThread.class);
    private List<AbstractDevice> deviceList = new ArrayList<AbstractDevice>();
    private Document document;
    private DriverParams param;
    private TaskType taskType;
    private CountDownLatch latch;

    public DevEleParseThread(List<AbstractDevice> pDeviceList, Document pDocument, DriverParams pParam, TaskType pTaskType, CountDownLatch pLatch) {
        this.deviceList.addAll(pDeviceList);
        this.document = pDocument;
        this.param = pParam;
        this.taskType = pTaskType;
        this.latch = pLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Element> call() {
        try {
            ArrayList<Element> deviceElementList = new ArrayList<Element>();
            for (AbstractDevice device : this.deviceList) {
                if (ITDeviceType.SERVER_IBMC == device.getItDeviceType()) {
                    deviceElementList.add(DriverUtils.createDeviceElement((IBMCDevice)device, this.document, this.param, this.taskType));
                } else if (ITDeviceType.SERVER_HMM == device.getItDeviceType()) {
                    deviceElementList.add(DriverUtils.createDeviceElement((HMMDevice)device, this.document, this.param, this.taskType));
                } else {
                    deviceElementList.add(XmlWriter.createTagElement((Document)this.document, (String)"device"));
                }
                this.sleepSomeTime(50L);
            }
            this.deviceList = null;
            ArrayList<Element> arrayList = deviceElementList;
            return arrayList;
        }
        finally {
            this.latch.countDown();
        }
    }

    private void sleepSomeTime(long sleepTime) {
        try {
            TimeUnit.MILLISECONDS.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            LOGGER.error("sleep is error!");
        }
    }
}

