/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.driver.utils;

import java.util.Arrays;
import java.util.Collection;

public enum DeviceAliasMapper {
    TCE("tce", "e9000h(tce)", "e9000h", "tce", "tce(e9000h)"),
    HMM("hmm", "hmm"),
    IBMC("ibmc", "ibmc"),
    OS("os", "os"),
    CMC("cmc", "cmc"),
    IES("ies", "ies"),
    SWITCH("switch", "switch"),
    UNKNOWN("unknown", "unknown");

    String id;
    String[] aliases;

    private DeviceAliasMapper(String id, String ... aliases) {
        this.id = id;
        this.aliases = aliases;
    }

    public boolean hasMatchedAlias(String context) {
        return Arrays.stream(this.aliases).anyMatch(context::contains);
    }

    public boolean hasMatchedAlias(Collection context) {
        return Arrays.stream(this.aliases).anyMatch(context::contains);
    }

    public static String getDeviceIdByAlias(String alias) {
        return DeviceAliasMapper.getDeviceTypeByAlias(alias).getId();
    }

    public static DeviceAliasMapper getDeviceTypeByAlias(String alias) {
        return Arrays.stream(DeviceAliasMapper.values()).filter(deviceType -> Arrays.asList(deviceType.getAliases()).contains(alias)).findAny().orElse(UNKNOWN);
    }

    public String getId() {
        return this.id;
    }

    public String[] getAliases() {
        return this.aliases;
    }
}

