/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.driver.utils;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.XmlWriter;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.CommonStatus;
import com.huawei.ism.tool.devicecenter.driver.model.DeviceProgress;
import com.huawei.ism.tool.devicecenter.driver.model.DeviceResult;
import com.huawei.ism.tool.devicecenter.driver.model.DriverParams;
import com.huawei.ism.tool.devicecenter.driver.model.DriverResult;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.driver.model.PortCheckStatus;
import com.huawei.ism.tool.devicecenter.driver.model.PortsCheckResult;
import com.huawei.ism.tool.devicecenter.driver.model.TaskResult;
import com.huawei.ism.tool.devicecenter.driver.model.TaskType;
import com.huawei.ism.tool.devicecenter.driver.model.ThirdPartyTool;
import com.huawei.ism.tool.devicecenter.driver.model.ToolService;
import com.huawei.ism.tool.devicecenter.entity.HMMDevice;
import com.huawei.ism.tool.devicecenter.entity.IBMCDevice;
import com.huawei.ism.tool.devicecenter.entity.ServerComputeNode;
import com.huawei.ism.tool.devicecenter.entity.ServerExchangeModule;
import com.huawei.ism.tool.devicecenter.utils.TaskXmlUtil;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.IniReader;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import com.huawei.json.JSONObject;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DriverUtils {
    private static final Logger log = LoggerFactory.getLogger(DriverUtils.class);
    private static final String[] CERTS = new String[]{"pem", "cer", "crt", "der", "p7b", "p12"};
    private static final int P12_PWD_LEN = 8;
    private static final int TWO_DAY_HOURS = 48;
    private static final int A_MONTH_HOURS = 720;
    private static final int HEX = 255;
    private static final char FILL = '0';
    private static final int BITS_TO_BYTE_TO_HEX_RATIO = 16;
    private static final char HEX_LESS_0X10_FILL_0 = '0';
    private static final String LEVEL_KEY = "levels";
    private static final String SERVICES_KEY = "services";
    private static final String SUPPORT_SERVICE_KEY = "supportService";
    private static final String[] SERVICE_NAME = new String[]{"devAdd", "devCheck", "logCollect", "inspector"};
    private static final String[] DOMAIN_NAME = new String[]{"STORAGE", "SERVER"};
    private static final String TOOL_NAME = "Inspection";
    private static final String REMOTE_DC = "RemoteServiceDC";

    public static ToolService parseToolService(Element serviceEle) {
        ToolService toolService = new ToolService();
        toolService.setServiceName(DriverUtils.checkServiceName(com.huawei.ism.tool.base.utils.XmlUtils.getTextContentOfChild((Element)serviceEle, (String)"serviceName")));
        toolService.setServiceDomain(DriverUtils.checkServiceDomain(com.huawei.ism.tool.base.utils.XmlUtils.getTextContentOfChild((Element)serviceEle, (String)"domain")));
        toolService.setServiceCommand(com.huawei.ism.tool.base.utils.XmlUtils.getTextContentOfChild((Element)serviceEle, (String)"command"));
        toolService.setPreferCommand(com.huawei.ism.tool.base.utils.XmlUtils.getTextContentOfChild((Element)serviceEle, (String)"preferCommand"));
        toolService.setServiceLinuxCommand(com.huawei.ism.tool.base.utils.XmlUtils.getTextContentOfChild((Element)serviceEle, (String)"linuxCommand"));
        toolService.setServiceProtocol(com.huawei.ism.tool.base.utils.XmlUtils.getTextContentOfChild((Element)serviceEle, (String)"protocol"));
        toolService.setServiceTimeout(Integer.valueOf(com.huawei.ism.tool.base.utils.XmlUtils.getTextContentOfChild((Element)serviceEle, (String)"timeout")));
        return toolService;
    }

    public static String generateDriverID(TaskType driverType, ITDeviceType driverField) {
        StringBuffer idbuf = new StringBuffer();
        idbuf.append(driverType.getName()).append('_').append(driverField.getName());
        return idbuf.toString().toUpperCase(Locale.ENGLISH);
    }

    public static String generateDriverID(String serviceName, String domain) {
        StringBuffer idbuf = new StringBuffer();
        idbuf.append(serviceName).append('_').append(domain);
        return idbuf.toString().toUpperCase(Locale.ENGLISH);
    }

    public static ThirdPartyTool parseToolIni(File tooliniFilePath) {
        ThirdPartyTool tool = new ThirdPartyTool();
        IniReader ir = new IniReader(tooliniFilePath);
        String toolName = ir.getString("tool.name");
        if (toolName.equals(TOOL_NAME)) {
            toolName = REMOTE_DC;
        }
        if (DriverUtils.isValidFileName(toolName)) {
            tool.setName(toolName);
        }
        return tool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ToolService> parseServiceConfig(File toolConfigFile) {
        ArrayList<ToolService> toolServiceList = new ArrayList<ToolService>();
        FileInputStream input = null;
        try {
            input = new FileInputStream(toolConfigFile);
            Document doc = com.huawei.ism.tool.base.utils.XmlUtils.parseDocument((InputStream)input);
            doc.getDocumentElement().normalize();
            Element serviceParamsEle = XmlUtils.getRootElement(doc, "serviceParams");
            Collection serviceElementList = com.huawei.ism.tool.base.utils.XmlUtils.getChildren((Element)serviceParamsEle, (String)"service");
            for (Element serviceEle : serviceElementList) {
                ToolService toolService = DriverUtils.parseToolService(serviceEle);
                toolServiceList.add(toolService);
            }
            ArrayList<ToolService> arrayList = toolServiceList;
            return arrayList;
        }
        catch (FileNotFoundException e) {
            log.error("can not open serviceConfig.xml");
        }
        finally {
            StreamUtils.closeResource(null, (Closeable)input);
        }
        return toolServiceList;
    }

    public static List<DeviceProgress> parseDeviceProgress(Collection<Element> deviceElementList) {
        ArrayList<DeviceProgress> deviceProgressList = new ArrayList<DeviceProgress>();
        for (Element deviceEle : deviceElementList) {
            String storageProgress;
            DeviceProgress deviceProgress = new DeviceProgress();
            String staticAttribute = com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)deviceEle, (String)"staticIp");
            String httpsAttribute = com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)deviceEle, (String)"HttpsPort");
            String deviceIpAttribute = com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)deviceEle, (String)"ip");
            String deviceErrorMsg = com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)deviceEle, (String)"errMsg");
            DeviceResult deviceResult = DriverUtils.transStr2DeviceResult(com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)deviceEle, (String)"result"));
            CommonStatus deviceStatus = DriverUtils.transStr2CommonStatus(com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)deviceEle, (String)"status"));
            if (staticAttribute != null && !"".equals(staticAttribute)) {
                deviceProgress.setStaticIp(staticAttribute);
            }
            if (httpsAttribute != null && !"".equals(httpsAttribute)) {
                deviceProgress.setHttpsPort(httpsAttribute);
            }
            if (!CommonStatus.RUNNING.equals((Object)deviceStatus)) {
                log.info("BMC IP:{},status:{},result:{},errMsg:{} ", new Object[]{deviceIpAttribute, deviceStatus, deviceResult, deviceErrorMsg});
            }
            deviceProgress.setIp(deviceIpAttribute);
            deviceProgress.setSerialNo(com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)deviceEle, (String)"serialNo"));
            deviceProgress.setErrMsg(deviceErrorMsg);
            deviceProgress.setResult(deviceResult);
            deviceProgress.setStatus(deviceStatus);
            deviceProgress.setUpdateTime(new Date(Long.parseLong(com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)deviceEle, (String)"updateTime"))));
            deviceProgress.setFingerPrint(com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)deviceEle, (String)"fingerPrint"));
            deviceProgress.setSshHostKey(com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)deviceEle, (String)"sshHostKey"));
            String passRate = com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)deviceEle, (String)"passRate");
            if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)passRate)) {
                deviceProgress.setPassRate(0);
            } else {
                deviceProgress.setPassRate(Integer.valueOf(passRate));
            }
            String externalResult = com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)deviceEle, (String)"externalResult");
            if (!com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)externalResult)) {
                JSONObject externalResultObject = new JSONObject(externalResult);
                deviceProgress.setExternalResult(externalResultObject);
            }
            if ((storageProgress = com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)deviceEle, (String)"progress")) != null) {
                deviceProgress.setProgress(Integer.valueOf(storageProgress));
            } else {
                String process = com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)deviceEle, (String)"passRate");
                deviceProgress.setProgress(com.huawei.ism.tool.base.utils.StringUtils.str2Int((String)process.replaceAll("%", ""), (int)0));
            }
            String devPortsCheckResult = com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)deviceEle, (String)"devPortsCheckResult");
            if (!com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)devPortsCheckResult)) {
                deviceProgress.setDevPortsCheckResult(DriverUtils.transStr2PortsCheckResult(devPortsCheckResult));
            }
            if (deviceProgressList.contains(deviceProgress)) {
                deviceProgress.setSnRepeatFlag(true);
            }
            deviceProgressList.add(deviceProgress);
        }
        return deviceProgressList;
    }

    private static PortsCheckResult transStr2PortsCheckResult(String devPortsCheckResult) {
        JSONObject devPortsStatusJsonObject = new JSONObject(devPortsCheckResult);
        PortsCheckResult portsCheckResult = new PortsCheckResult();
        portsCheckResult.setNet(devPortsStatusJsonObject.getInt("Net"));
        portsCheckResult.setSsh(PortCheckStatus.of(devPortsStatusJsonObject.getStringOrDefault("Ssh", PortCheckStatus.FAILED.getStatus())));
        portsCheckResult.setRedfish(PortCheckStatus.of(devPortsStatusJsonObject.getStringOrDefault("Redfish", PortCheckStatus.FAILED.getStatus())));
        portsCheckResult.setIpmi(PortCheckStatus.of(devPortsStatusJsonObject.getStringOrDefault("Ipmi", PortCheckStatus.FAILED.getStatus())));
        portsCheckResult.setSnmp(PortCheckStatus.of(devPortsStatusJsonObject.getStringOrDefault("Snmp", PortCheckStatus.FAILED.getStatus())));
        return portsCheckResult;
    }

    private static CommonStatus transStr2CommonStatus(String result) {
        CommonStatus status = CommonStatus.WAITING;
        if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)result)) {
            return status;
        }
        if (result.equalsIgnoreCase("finished")) {
            status = CommonStatus.FINISHED;
        }
        if (result.equalsIgnoreCase("running")) {
            status = CommonStatus.RUNNING;
        }
        return status;
    }

    private static DeviceResult transStr2DeviceResult(String result) {
        DeviceResult deviceResult = DeviceResult.FAILED;
        if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)result)) {
            return deviceResult;
        }
        if (result.equalsIgnoreCase("unsupported")) {
            deviceResult = DeviceResult.UNSUPPORTED;
        } else if (result.equalsIgnoreCase("success")) {
            deviceResult = DeviceResult.SUCCESS;
        } else if (result.equalsIgnoreCase("part_success")) {
            deviceResult = DeviceResult.PART_SUCCESS;
        }
        return deviceResult;
    }

    public static DriverResult parseProgressTotalInfo(Element progressEle, long overTime) {
        DriverResult result = new DriverResult();
        result.setOverTime(overTime);
        result.setStatus(DriverUtils.transStr2CommonStatus(com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)progressEle, (String)"status")));
        result.setProgress(com.huawei.ism.tool.base.utils.StringUtils.str2Int((String)com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)progressEle, (String)"progress"), (int)0));
        result.setUpdateTime(new Date(Long.parseLong(com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)progressEle, (String)"updateTime"))));
        result.setResult(DriverUtils.transStr2TaskResult(com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)progressEle, (String)"result")));
        result.setErrMsg(com.huawei.ism.tool.base.utils.XmlUtils.getAttribute((Element)progressEle, (String)"errMsg"));
        return result;
    }

    private static TaskResult transStr2TaskResult(String result) {
        TaskResult taskResult = TaskResult.ALL_SUCCESS;
        if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)result)) {
            return taskResult;
        }
        if (result.equalsIgnoreCase("part_successful")) {
            taskResult = TaskResult.PART_SUCCESS;
        }
        if (result.equalsIgnoreCase("all_failed")) {
            taskResult = TaskResult.ALL_FAILED;
        }
        return taskResult;
    }

    public static boolean createTaskFile(String taskfilePath, String workPath, DriverParams param, TaskType taskType) throws ToolException {
        DriverUtils.cleanProgressFile(workPath);
        File file = new File(taskfilePath);
        if (file.exists()) {
            FileUtils.deleteFile(file);
        }
        try {
            boolean isFileCreated = file.createNewFile();
            if (!isFileCreated) {
                throw new ToolException("create taskfile.xml error.");
            }
        }
        catch (IOException e) {
            log.error("create taskfile.xml error", (Throwable)e);
            return false;
        }
        boolean taskFileFlag = TaskXmlUtil.createHwServerXml(taskfilePath, param);
        if (!DeviceCenterContext.shouldDeleteTaskFile()) {
            String taskFileTarget = taskfilePath.replace("taskFile.xml", "taskFile_bak.xml");
            StreamUtils.copyFile((File)file, (File)new File(taskFileTarget));
        }
        return taskFileFlag;
    }

    private static <T> List<List<T>> averageAssign(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int remaider = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<T> value = null;
            if (remaider > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remaider;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            result.add(value);
        }
        return result;
    }

    private static void cleanProgressFile(String workPath) {
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(workPath).append(File.separator).append("Progress.xml");
        File progressFile = new File(pathBuilder.toString());
        if (progressFile.exists()) {
            FileUtils.deleteFile(progressFile);
        }
    }

    public static String getCanonicalFilePath(File file) {
        if (file == null) {
            return "";
        }
        String canonicalPath = "";
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            log.error("get file path error", (Throwable)e);
        }
        return canonicalPath;
    }

    public static boolean createFile(String filePath) {
        try {
            File file = new File(filePath);
            return file.createNewFile();
        }
        catch (IOException e) {
            log.error("create new file io error.", (Throwable)e);
            return false;
        }
    }

    public static File getCanonicalFile(String filePath) {
        String strPath = Normalizer.normalize(filePath, Normalizer.Form.NFKC);
        File file = new File(strPath);
        File canonicalFile = null;
        try {
            canonicalFile = file.getCanonicalFile();
        }
        catch (IOException e) {
            log.error("get Canonical file error", (Throwable)e);
        }
        return canonicalFile;
    }

    public static Element createDeviceElement(HMMDevice device, Document document, DriverParams param, TaskType taskType) {
        Element deviceEle = XmlWriter.createTagElement((Document)document, (String)"device-e9000");
        deviceEle.setAttribute("HMMIp", device.getIp());
        deviceEle.setAttribute("HMMUserName", device.getAccount().getUserName());
        deviceEle.setAttribute("HMMUserPassword", AESEncrypt.encrypt128((String)device.getAccount().getPassword()));
        deviceEle.setAttribute("SNMPv2Community", AESEncrypt.encrypt128((String)device.getHmmSnmpv2Community()));
        deviceEle.setAttribute("SNMPPort", String.valueOf(device.getSnmpPort()));
        deviceEle.setAttribute("SSHPort", String.valueOf(device.getSshPort()));
        deviceEle.setAttribute("VMMPort", String.valueOf(device.getVmmPort()));
        Element computeNodeElement = XmlWriter.createTagElement((Document)document, (String)"computeNodeList");
        if (device.getServerComputeNodes().size() > 0) {
            for (ServerComputeNode computeNode : device.getServerComputeNodes()) {
                computeNodeElement.appendChild(DriverUtils.createServerE9000ComputeNodeElement(computeNode, document, param, taskType));
            }
        }
        deviceEle.appendChild(computeNodeElement);
        Element switchPlaneElement = XmlWriter.createTagElement((Document)document, (String)"switchPlaneList");
        if (device.getServerExchangeModules().size() > 0) {
            for (ServerExchangeModule switchPlane : device.getServerExchangeModules()) {
                switchPlaneElement.appendChild(DriverUtils.createServerE9000SwitchPlaneElement(switchPlane, document, param, taskType));
            }
        }
        deviceEle.appendChild(switchPlaneElement);
        return deviceEle;
    }

    private static Element createServerE9000SwitchPlaneElement(ServerExchangeModule switchPlane, Document document, DriverParams param, TaskType taskType) {
        Element switchElement = XmlWriter.createTagElement((Document)document, (String)"switchPlane");
        switchElement.setAttribute("SlotId", String.valueOf(switchPlane.getSlot()));
        switchElement.setAttribute("SSHPort", String.valueOf(switchPlane.getSshPort()));
        switchElement.setAttribute("SwitchPlaneIP", switchPlane.getSwitchingPlaneIp());
        switchElement.setAttribute("SwitchPlaneUserName", switchPlane.getAccount().getUserName());
        if (TaskType.DEV_ADD == taskType) {
            switchElement.setAttribute("SwitchPlaneUserPassword", AESEncrypt.encrypt128((String)switchPlane.getAccount().getPassword()));
        } else {
            switchElement.setAttribute("SwitchPlaneUserPassword", AESEncrypt.encrypt128((String)switchPlane.getAccount().getPassword()));
            switchElement.setAttribute("selectedFlag", String.valueOf(switchPlane.isExchangeSwitchChooseFlag()));
        }
        switchElement.setAttribute("SwitchPlaneType", switchPlane.getSwitchingPlane());
        return switchElement;
    }

    private static Element createServerE9000ComputeNodeElement(ServerComputeNode computeNode, Document documnet, DriverParams param, TaskType taskType) {
        Element computeElement = XmlWriter.createTagElement((Document)documnet, (String)"computeNode");
        computeElement.setAttribute("SlotId", String.valueOf(computeNode.getSlot()));
        computeElement.setAttribute("BMCIp", computeNode.getIp());
        computeElement.setAttribute("BMCUserName", computeNode.getAccount().getUserName());
        computeElement.setAttribute("BMCUserPassword", AESEncrypt.encrypt128((String)computeNode.getAccount().getPassword()));
        computeElement.setAttribute("SNMPv2Community", AESEncrypt.encrypt128((String)computeNode.getIbmcSnmpv2Community()));
        computeElement.setAttribute("SNMPPort", String.valueOf(computeNode.getSnmpPort()));
        computeElement.setAttribute("SSHPort", String.valueOf(computeNode.getSshPort()));
        computeElement.setAttribute("IPMIPort", String.valueOf(computeNode.getIpmiPort()));
        computeElement.setAttribute("VMMPort", String.valueOf(computeNode.getVmmPort()));
        computeElement.setAttribute("OS_Type", "");
        computeElement.setAttribute("OS_IP", "");
        computeElement.setAttribute("OS_UserName", "");
        computeElement.setAttribute("OS_UserPassword", AESEncrypt.encrypt128((String)""));
        computeElement.setAttribute("OS_RootPassword", AESEncrypt.encrypt128((String)""));
        computeElement.setAttribute("selectedFlag", String.valueOf(computeNode.isComputeNodeChooseFlag()));
        return computeElement;
    }

    public static Element createDeviceElement(IBMCDevice device, Document document, DriverParams param, TaskType taskType) {
        Element deviceEle = XmlWriter.createTagElement((Document)document, (String)"device");
        deviceEle.setAttribute("BMCIp", device.getIp());
        deviceEle.setAttribute("BMCUserName", device.getAccount().getUserName());
        deviceEle.setAttribute("BMCUserPassword", AESEncrypt.encrypt128((String)device.getAccount().getPassword()));
        deviceEle.setAttribute("SNMPv2Community", AESEncrypt.encrypt128((String)device.getIbmcSnmpv2Community()));
        deviceEle.setAttribute("SNMPPort", String.valueOf(device.getSnmpPort()));
        deviceEle.setAttribute("SSHPort", String.valueOf(device.getSshPort()));
        deviceEle.setAttribute("IPMIPort", String.valueOf(device.getIpmiPort()));
        deviceEle.setAttribute("VMMPort", String.valueOf(device.getVmmPort()));
        deviceEle.setAttribute("OS_Type", "");
        deviceEle.setAttribute("OS_IP", "");
        deviceEle.setAttribute("OS_UserName", "");
        deviceEle.setAttribute("OS_UserPassword", AESEncrypt.encrypt((String)""));
        deviceEle.setAttribute("OS_RootPassword", AESEncrypt.encrypt((String)""));
        return deviceEle;
    }

    public static List<KeyValue<String, String>> standerCloudPara(List<KeyValue<String, String>> inputPara) {
        ArrayList<KeyValue<String, String>> standerPara = new ArrayList<KeyValue<String, String>>();
        String cloudStartTime = "";
        String cloudEndTime = "";
        String taskMode = "";
        String supportService = "";
        String services = "";
        String levels = "";
        for (KeyValue<String, String> keyvalue : inputPara) {
            switch ((String)keyvalue.getKey()) {
                case "collectStartTime": {
                    cloudStartTime = (String)keyvalue.getValue();
                    break;
                }
                case "collectEndTime": {
                    cloudEndTime = (String)keyvalue.getValue();
                    break;
                }
                case "collectScene": {
                    taskMode = (String)keyvalue.getValue();
                    break;
                }
                case "supportService": {
                    supportService = (String)keyvalue.getValue();
                    break;
                }
                case "services": {
                    services = (String)keyvalue.getValue();
                    break;
                }
                case "levels": {
                    levels = (String)keyvalue.getValue();
                    break;
                }
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        SimpleDateFormat sdfss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if ("1".equals(taskMode)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(11, -1);
            cloudStartTime = sdfss.format(calendar.getTime());
            cloudEndTime = sdfss.format(new Date());
        }
        standerPara.add(new KeyValue((Object)"taskMode", (Object)taskMode));
        standerPara.add(new KeyValue((Object)SUPPORT_SERVICE_KEY, (Object)supportService));
        standerPara.add(new KeyValue((Object)SERVICES_KEY, (Object)services));
        standerPara.add(new KeyValue((Object)LEVEL_KEY, (Object)levels));
        DriverUtils.calendarConfig(standerPara, cloudStartTime, cloudEndTime, sdf, sdfss);
        return standerPara;
    }

    private static void calendarConfig(List<KeyValue<String, String>> standerPara, String cloudStartTime, String cloudEndTime, SimpleDateFormat sdf, SimpleDateFormat sdfss) {
        try {
            if (cloudStartTime.equals("")) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(sdfss.parse(cloudEndTime));
                calendar.add(11, -48);
                standerPara.add((KeyValue<String, String>)new KeyValue((Object)"startTime", (Object)StringUtils.formatDate(calendar.getTime(), "yyyy-MM-dd HH:mm")));
                standerPara.add((KeyValue<String, String>)new KeyValue((Object)"endTime", (Object)sdf.format(sdfss.parse(cloudEndTime))));
            } else {
                standerPara.add((KeyValue<String, String>)new KeyValue((Object)"startTime", (Object)sdf.format(sdfss.parse(cloudStartTime))));
                standerPara.add((KeyValue<String, String>)new KeyValue((Object)"endTime", (Object)sdf.format(sdfss.parse(cloudEndTime))));
            }
        }
        catch (ParseException e) {
            log.error("CloudLogCollect parseException", (Throwable)e);
        }
    }

    @Deprecated
    public static String generateTaskKey(int secretKeyBitsLen) {
        return "undefined";
    }

    private static List<KeyValue<String, String>> paresParamList(List<KeyValue<String, String>> paramList) {
        ArrayList<KeyValue<String, String>> storageParamList = new ArrayList<KeyValue<String, String>>();
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat sdfss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String storageStartTime = "";
        String storageEndTime = "";
        int taskMode = 1;
        for (KeyValue<String, String> keyvalue : paramList) {
            if (((String)keyvalue.getKey()).equals("collectStartTime")) {
                storageStartTime = (String)keyvalue.getValue();
                continue;
            }
            if (((String)keyvalue.getKey()).equals("collectEndTime")) {
                storageEndTime = (String)keyvalue.getValue();
                continue;
            }
            if (!((String)keyvalue.getKey()).equals("collectScene")) continue;
            taskMode = Integer.valueOf((String)keyvalue.getValue());
        }
        if (1 == taskMode) {
            storageParamList.add(new KeyValue((Object)"collectMode", (Object)"log"));
            return storageParamList;
        }
        if (storageStartTime.equals("")) {
            storageParamList.add((KeyValue<String, String>)new KeyValue((Object)"collectMode", (Object)"fulllog"));
        } else {
            try {
                sb.append(sdfss.parse(storageStartTime).getTime());
                sb.append(',');
                sb.append(sdfss.parse(storageEndTime).getTime());
            }
            catch (ParseException e) {
                log.error("ParseDate Exception", (Throwable)e);
            }
            String timeValue = sb.toString();
            storageParamList.add((KeyValue<String, String>)new KeyValue((Object)"collectMode", (Object)"bytime"));
            storageParamList.add((KeyValue<String, String>)new KeyValue((Object)"time", (Object)timeValue));
        }
        return storageParamList;
    }

    private static Element getParamElement(Document doc, KeyValue<String, String> param) {
        if (null == param) {
            return null;
        }
        Element paramEle = doc.createElement("param");
        String paramKey = "";
        if (!com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)((String)param.getKey()))) {
            paramKey = Normalizer.normalize((CharSequence)param.getKey(), Normalizer.Form.NFKC);
        }
        String paramValue = "";
        if (!com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)((String)param.getValue()))) {
            paramValue = Normalizer.normalize((CharSequence)param.getValue(), Normalizer.Form.NFKC);
        }
        paramEle.setAttribute("key", paramKey);
        paramEle.setAttribute("value", paramValue);
        return paramEle;
    }

    public static List<KeyValue<String, String>> standerTimePara(List<KeyValue<String, String>> inputPara) {
        Calendar calendar;
        ArrayList<KeyValue<String, String>> standerPara = new ArrayList<KeyValue<String, String>>();
        String startTime = "";
        String endTime = "";
        String taskMode = "";
        for (KeyValue<String, String> keyvalue : inputPara) {
            switch ((String)keyvalue.getKey()) {
                case "collectStartTime": {
                    startTime = (String)keyvalue.getValue();
                    break;
                }
                case "collectEndTime": {
                    endTime = (String)keyvalue.getValue();
                    break;
                }
                case "collectScene": {
                    taskMode = (String)keyvalue.getValue();
                    break;
                }
            }
        }
        standerPara.add(new KeyValue((Object)"taskMode", (Object)taskMode));
        SimpleDateFormat sdfFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        SimpleDateFormat sdfss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if ("1".equals(taskMode)) {
            calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(11, -1);
            startTime = sdfss.format(calendar.getTime());
            endTime = sdfss.format(new Date());
        }
        try {
            if (startTime.equals("")) {
                calendar = Calendar.getInstance();
                calendar.setTime(sdfss.parse(endTime));
                calendar.add(11, -720);
                standerPara.add((KeyValue<String, String>)new KeyValue((Object)"startTime", (Object)StringUtils.formatDate(calendar.getTime(), "yyyy-MM-dd HH:mm")));
                standerPara.add((KeyValue<String, String>)new KeyValue((Object)"endTime", (Object)sdfFormate.format(sdfss.parse(endTime))));
            } else {
                standerPara.add((KeyValue<String, String>)new KeyValue((Object)"startTime", (Object)sdfFormate.format(sdfss.parse(startTime))));
                standerPara.add((KeyValue<String, String>)new KeyValue((Object)"endTime", (Object)sdfFormate.format(sdfss.parse(endTime))));
            }
        }
        catch (ParseException e) {
            log.error("CloudLogCollect parseException", (Throwable)e);
        }
        return standerPara;
    }

    public static boolean isValidFileName(String fileName) {
        if (fileName == null || fileName.length() > 255) {
            return false;
        }
        return fileName.matches("[^\\s\\\\/:\\*\\?\\\"<>\\|](\\x20|[^\\s\\\\/:\\*\\?\\\"<>\\|])*[^\\s\\\\/:\\*\\?\\\"<>\\|\\.]$");
    }

    private static String checkServiceName(String serviceName) {
        for (String str : SERVICE_NAME) {
            if (!serviceName.equals(str)) continue;
            return serviceName;
        }
        return "";
    }

    private static String checkServiceDomain(String domainName) {
        for (String str : DOMAIN_NAME) {
            if (!domainName.equals(str)) continue;
            return domainName;
        }
        return "";
    }

    public static boolean isContainCouldCerts() {
        CerFileFilter cloudFilter;
        String cloudCertPath = ApplicationContext.getInstance().getWorkPath() + File.separator + "dccerts" + File.separator + "cloud";
        File cloudDir = new File(cloudCertPath);
        File[] cloudCertFilesList = cloudDir.listFiles(cloudFilter = new CerFileFilter());
        if (null == cloudCertFilesList || cloudCertFilesList.length == 0) {
            log.error("cloud certs is not exist!");
            return false;
        }
        return true;
    }

    private static class CerFileFilter
    implements FilenameFilter {
        private CerFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            String suffixs = "";
            try {
                suffixs = name.substring(name.lastIndexOf(46) + 1);
            }
            catch (Exception e) {
                return false;
            }
            List<String> certsList = Arrays.asList(CERTS);
            return certsList.contains(suffixs);
        }
    }
}

