/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.entity;

import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.entity.Account;
import com.huawei.ism.tool.devicecenter.entity.IBMCDevice;
import com.huawei.ism.tool.devicecenter.entity.TceDevice;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDevice
implements Cloneable {
    private Account account = new Account();
    private ITDeviceType itDeviceType;
    private Integer deviceId;
    private String ip = "";
    private String port = "";
    private boolean taskAvailable = true;
    private String typeJsonKey = "";
    private List<MultiRouteNode> sshForwardList = new ArrayList<MultiRouteNode>();

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public String getIp() {
        return this.ip;
    }

    public ITDeviceType getItDeviceType() {
        return this.itDeviceType;
    }

    public void setItDeviceType(ITDeviceType itDeviceType) {
        this.itDeviceType = itDeviceType;
    }

    public Integer getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(Integer deviceId) {
        this.deviceId = deviceId;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getShaCode() {
        return "";
    }

    public boolean isTaskAvailable() {
        return this.taskAvailable;
    }

    public void setTaskAvailable(boolean taskAvailable) {
        this.taskAvailable = taskAvailable;
    }

    public abstract String getDeviceSn();

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractDevice) {
            String objSn = ((AbstractDevice)obj).getDeviceSn();
            ITDeviceType objType = ((AbstractDevice)obj).getItDeviceType();
            String objIp = ((AbstractDevice)obj).getIp();
            String thisSn = this.getDeviceSn();
            ITDeviceType thisType = this.getItDeviceType();
            String thisIp = this.getIp();
            if (ITDeviceType.SERVER_OS.equals((Object)objType) && ITDeviceType.SERVER_OS.equals((Object)thisType)) {
                return (objIp + objSn).equals(thisIp + thisSn);
            }
            if (thisIp.equals(objIp) && !AbstractDevice.isPortProxy(obj)) {
                return true;
            }
            if (!(this.isSnEmpty(objSn) || this.isSnEmpty(thisSn) || VerifyUtil.isEmpty((Object)((Object)objType)))) {
                return objType.equals((Object)thisType) && thisSn.equals(objSn);
            }
        } else {
            return false;
        }
        return false;
    }

    private static boolean isPortProxy(Object obj) {
        if (obj instanceof TceDevice) {
            return ((TceDevice)obj).getDevice().getHwServerDev().isPortProxy();
        }
        if (obj instanceof IBMCDevice) {
            return ((IBMCDevice)obj).getHwServerDev().isPortProxy();
        }
        return false;
    }

    private boolean isSnEmpty(String sn) {
        return VerifyUtil.isEmpty((String)sn) || "--".equals(sn);
    }

    public int hashCode() {
        String ipAddr = this.ip;
        char[] chars = ipAddr.toCharArray();
        int hashTemp = 0;
        for (char c : chars) {
            hashTemp += c;
        }
        String thisSn = this.getDeviceSn();
        return super.hashCode() + hashTemp + thisSn.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getTypeJsonKey() {
        return this.typeJsonKey;
    }

    public void setTypeJsonKey(String typeJsonKey) {
        this.typeJsonKey = typeJsonKey;
    }

    public String toString() {
        return "AbstractDevice{itDeviceType=" + (Object)((Object)this.itDeviceType) + ", deviceId=" + this.deviceId + ", ip='" + this.ip + '\'' + ", port='" + this.port + '\'' + ", taskAvailable=" + this.taskAvailable + '}';
    }

    public void setSshForwardList(List<MultiRouteNode> sshForwardList) {
        this.sshForwardList = sshForwardList;
    }

    public List<MultiRouteNode> getSshForwardList() {
        return this.sshForwardList;
    }
}

