/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.devicecenter.entity.CMCDevice;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.connection.ssh.SshKnownHostsManager;

public class CMCDevice2Json {
    @JSONField(name="ip")
    private String ip = "";
    @JSONField(name="type")
    private String type = "";
    @JSONField(name="productType")
    private String productType = "";
    @JSONField(name="serialNumber")
    private String serialNumber = "";
    @JSONField(name="cpldVersion")
    private String cpldVersion = "";
    @JSONField(name="softwareVersion")
    private String software;
    @JSONField(name="sshPort")
    private String sshPort = "";
    @JSONField(name="snmpPort")
    private String snmpPort = "";
    @JSONField(name="ipmiPort")
    private String ipmiPort = "";
    @JSONField(name="vmmPort")
    private String vmmPort = "";
    @JSONField(name="httpsPort")
    private String httpsPort = "";
    @JSONField(name="snmpV2Community")
    private String snmpV2Community = "";
    @JSONField(name="username")
    private String cmcUserName = "";
    @JSONField(name="password")
    private String pwd = "";
    @JSONField(name="snmpPrivPwd")
    private String snmpPrivPwd = "";
    @JSONField(name="onlySecurityAlgorithms")
    private String onlySecurityAlgorithms = "";
    @JSONField(name="sshHostKey")
    private String sshHostKey = "";
    @JSONField(name="isVerifySshHostKey")
    private String isVerifySshHostKey = "";
    @JSONField(name="redfishUserName")
    private String redFishUserName = "";
    @JSONField(name="redfishPwd")
    private String redFishPwd = "";
    @JSONField(name="isSupportAccountSeparation")
    private String isSupportAccountSeparation;

    public CMCDevice2Json(CMCDevice cmcDev) {
        this.initField(cmcDev);
    }

    private void initField(CMCDevice device) {
        this.ip = device.getIp();
        this.type = "cmc";
        this.productType = device.getProductName();
        this.serialNumber = device.getSerialNumber();
        this.cpldVersion = device.getCpld();
        this.software = device.getSoftware();
        this.sshPort = device.getHwServerDev().getSshPort() + "";
        this.snmpPort = device.getHwServerDev().getSnmpPort() + "";
        this.ipmiPort = device.getHwServerDev().getIpmiPort() + "";
        this.vmmPort = device.getHwServerDev().getVmmPort() + "";
        this.httpsPort = device.getHwServerDev().getRedFishPort();
        this.snmpV2Community = AESEncrypt.encrypt((String)device.getHwServerDev().getCommunity());
        this.cmcUserName = device.getHwServerDev().getUserName();
        this.pwd = AESEncrypt.encrypt((String)device.getHwServerDev().getUserPwd());
        this.snmpPrivPwd = AESEncrypt.encrypt((String)device.getHwServerDev().getSnmpPrivPwd());
        this.onlySecurityAlgorithms = Boolean.toString(device.getHwServerDev().isOnlySecurityAlgSupportedFlag());
        if (ApplicationContext.getInstance().isVerifySshHostKey()) {
            this.sshHostKey = AESEncrypt.encrypt((String)SshKnownHostsManager.getHostKeyInfo(device.getIp()));
            this.isVerifySshHostKey = AESEncrypt.encrypt((String)(SshKnownHostsManager.isVerifySshHostKeyInfo(device.getIp()) + ""));
        }
        if (device.getHwServerDev().isSupportAccountSeparation()) {
            this.redFishUserName = device.getHwServerDev().getRedFishUserName();
            this.redFishPwd = AESEncrypt.encrypt((String)device.getHwServerDev().getRedFishPwd());
        } else {
            this.redFishUserName = device.getHwServerDev().getUserName();
            this.redFishPwd = AESEncrypt.encrypt((String)device.getHwServerDev().getUserPwd());
        }
        this.isSupportAccountSeparation = Boolean.toString(device.getHwServerDev().isSupportAccountSeparation());
    }

    public String getIp() {
        return this.ip;
    }

    public String getType() {
        return this.type;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public String getProductType() {
        return this.productType;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getCpldVersion() {
        return this.cpldVersion;
    }

    public void setCpldVersion(String cpldVersion) {
        this.cpldVersion = cpldVersion;
    }

    public String getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(String sshPort) {
        this.sshPort = sshPort;
    }

    public String getSnmpPort() {
        return this.snmpPort;
    }

    public void setSnmpPort(String snmpPort) {
        this.snmpPort = snmpPort;
    }

    public String getIpmiPort() {
        return this.ipmiPort;
    }

    public void setIpmiPort(String ipmiPort) {
        this.ipmiPort = ipmiPort;
    }

    public String getVmmPort() {
        return this.vmmPort;
    }

    public void setVmmPort(String vmmPort) {
        this.vmmPort = vmmPort;
    }

    public String getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(String httpsPort) {
        this.httpsPort = httpsPort;
    }

    public String getSnmpV2Community() {
        return this.snmpV2Community;
    }

    public void setSnmpV2Community(String snmpV2Community) {
        this.snmpV2Community = snmpV2Community;
    }

    public String getCmcUserName() {
        return this.cmcUserName;
    }

    public void setCmcUserName(String cmcUserName) {
        this.cmcUserName = cmcUserName;
    }

    public String getPwd() {
        return this.pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public String getSoftware() {
        return this.software;
    }

    public void setSoftware(String software) {
        this.software = software;
    }

    public String getSnmpPrivPwd() {
        return this.snmpPrivPwd;
    }

    public String toString() {
        return "CMCDevice2Json{ip='" + this.ip + '\'' + ", type='" + this.type + '\'' + ", productType='" + this.productType + '\'' + ", serialNumber='" + this.serialNumber + '\'' + ", cpldVersion='" + this.cpldVersion + '\'' + ", software='" + this.software + '\'' + ", sshPort='" + this.sshPort + '\'' + ", snmpPort='" + this.snmpPort + '\'' + ", ipmiPort='" + this.ipmiPort + '\'' + ", vmmPort='" + this.vmmPort + '\'' + ", httpsPort='" + this.httpsPort + '\'' + '}';
    }

    public String getOnlySecurityAlgorithms() {
        return this.onlySecurityAlgorithms;
    }

    public void setOnlySecurityAlgorithms(String onlySecurityAlgorithms) {
        this.onlySecurityAlgorithms = onlySecurityAlgorithms;
    }

    public void setSshHostKey(String sshHostKey) {
        this.sshHostKey = sshHostKey;
    }

    public String getSshHostKey() {
        return this.sshHostKey;
    }

    public void setIsVerifySshHostKey(String isVerifySshHostKey) {
        this.isVerifySshHostKey = isVerifySshHostKey;
    }

    public String getIsVerifySshHostKey() {
        return this.isVerifySshHostKey;
    }

    public String getRedFishUserName() {
        return this.redFishUserName;
    }

    public void setRedFishUserName(String redFishUserName) {
        this.redFishUserName = redFishUserName;
    }

    public String getRedFishPwd() {
        return this.redFishPwd;
    }

    public void setRedFishPwd(String redFishPwd) {
        this.redFishPwd = redFishPwd;
    }

    public String getIsSupportAccountSeparation() {
        return this.isSupportAccountSeparation;
    }

    public void setIsSupportAccountSeparation(String isSupportAccountSeparation) {
        this.isSupportAccountSeparation = isSupportAccountSeparation;
    }
}

