/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.entity;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.entity.ServerComputeNode;
import com.huawei.ism.tool.devicecenter.entity.ServerExchangeModule;
import java.util.ArrayList;
import java.util.List;

public class HMMDevice
extends AbstractDevice {
    private transient List<ServerExchangeModule> serverExchangeModules = new ArrayList<ServerExchangeModule>();
    private List<ServerComputeNode> serverComputeNodes = new ArrayList<ServerComputeNode>();
    public static final String IMPI_DEFAULT_PORT = "623";
    public static final String SNMP_DEFAULT_PORT = "161";
    public static final String SSH_DEFAULT_PORT = "22";
    public static final String VMM_DEFAULT_PORT = "8208";
    private String vmmPort = "8208";
    private String sshPort = "22";
    private String snmpPort = "161";
    private String ipmiPort = "623";
    private String hmmSnmpv2Community = "";
    private boolean hmmChooseFlag = true;
    private boolean hmmTotalCollect = true;
    @JSONField(name="productVersion")
    private String productVersion = "";
    @JSONField(name="productName")
    private String productName = "";
    @JSONField(name="serialNumber")
    private String deviceSerialNumber = "";
    @JSONField(name="cpld")
    private String deviceCpld = "";
    @JSONField(name="software")
    private String deviceSW = "";
    @JSONField(name="masterHMM")
    private String masterHMM = "";
    @JSONField(name="slaveHMM")
    private String slaveHMM = "";
    private com.huawei.json.JSONObject resultDetail;
    private HwServerDevice hwServerDev = new HwServerDevice();

    public HMMDevice() {
        this.setItDeviceType(ITDeviceType.SERVER_HMM);
        this.setTypeJsonKey(ITDeviceType.SERVER_HMM.getDeviceTypeJsonKey());
    }

    public void setServerExchangeModules(List<ServerExchangeModule> serverExchangeModules) {
        this.serverExchangeModules = serverExchangeModules;
    }

    public void setServerComputeNodes(List<ServerComputeNode> serverComputeNodes) {
        this.serverComputeNodes = serverComputeNodes;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getDeviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    public void setDeviceSerialNumber(String deviceSerialNumber) {
        this.deviceSerialNumber = deviceSerialNumber;
    }

    public String getDeviceCpld() {
        return this.deviceCpld;
    }

    public void setDeviceCpld(String deviceCpld) {
        this.deviceCpld = deviceCpld;
    }

    public String getDeviceSW() {
        return this.deviceSW;
    }

    public void setDeviceSW(String deviceSW) {
        this.deviceSW = deviceSW;
    }

    public String getMasterHMM() {
        return this.masterHMM;
    }

    public void setMasterHMM(String masterHMM) {
        this.masterHMM = masterHMM;
    }

    public String getSlaveHMM() {
        return this.slaveHMM;
    }

    public void setSlaveHMM(String slaveHMM) {
        this.slaveHMM = slaveHMM;
    }

    public ServerComputeNode getComputeNodeBySlotId(String slotId) {
        for (ServerComputeNode computeNode : this.serverComputeNodes) {
            if (!slotId.equals(computeNode.getSlot())) continue;
            return computeNode;
        }
        return new ServerComputeNode();
    }

    public ServerComputeNode getComputeNodeByIP(String ip) {
        for (ServerComputeNode computeNode : this.serverComputeNodes) {
            if (!ip.equals(computeNode.getIp())) continue;
            return computeNode;
        }
        return null;
    }

    public List<ServerExchangeModule> getSwitchPlaneBySlotId(String slotId) {
        ArrayList<ServerExchangeModule> serverExchangeModule = new ArrayList<ServerExchangeModule>();
        for (ServerExchangeModule switchPlane : this.serverExchangeModules) {
            if (!slotId.equals(switchPlane.getSlot())) continue;
            serverExchangeModule.add(switchPlane);
        }
        return serverExchangeModule;
    }

    public ServerExchangeModule getSwitchPlaneByKey(String key) {
        for (ServerExchangeModule switchPlane : this.serverExchangeModules) {
            if (!key.equals(switchPlane.getSlot() + "_" + switchPlane.getSwitchingPlane())) continue;
            return switchPlane;
        }
        return null;
    }

    public void addServerComputeNodes(ServerComputeNode serverComputeNode) {
        this.serverComputeNodes.add(serverComputeNode);
    }

    public void removeServerComputerNode(ServerComputeNode serverComputeNode) {
        this.serverComputeNodes.remove(serverComputeNode);
    }

    public void clearServerComputeNodes() {
        this.serverComputeNodes.clear();
    }

    public void addServerComputeNodes(List<ServerComputeNode> serverComputeNodeList) {
        this.serverComputeNodes.addAll(serverComputeNodeList);
    }

    public void addServerExchangeModule(ServerExchangeModule serverExchangeModule) {
        this.serverExchangeModules.add(serverExchangeModule);
    }

    public void removeServerExchangeModule(ServerExchangeModule serverExchangeModule) {
        this.serverExchangeModules.remove(serverExchangeModule);
    }

    public void clearServerExchangeModule() {
        this.serverExchangeModules.clear();
    }

    public void addServerExchangeModules(List<ServerExchangeModule> serverExchangeModule) {
        this.serverExchangeModules.addAll(serverExchangeModule);
    }

    public List<ServerComputeNode> getServerComputeNodes() {
        return new ArrayList<ServerComputeNode>(this.serverComputeNodes);
    }

    public List<ServerExchangeModule> getServerExchangeModules() {
        return new ArrayList<ServerExchangeModule>(this.serverExchangeModules);
    }

    public String getVmmPort() {
        return this.vmmPort;
    }

    public void setVmmPort(String vmmPort) {
        this.vmmPort = vmmPort;
    }

    public String getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(String sshPort) {
        this.sshPort = sshPort;
    }

    public String getSnmpPort() {
        return this.snmpPort;
    }

    public void setSnmpPort(String snmpPort) {
        this.snmpPort = snmpPort;
    }

    public String getHmmSnmpv2Community() {
        return this.hmmSnmpv2Community;
    }

    public void setHmmSnmpv2Community(String hmmSnmpv2Community) {
        this.hmmSnmpv2Community = hmmSnmpv2Community;
    }

    public boolean isHmmChooseFlag() {
        return this.hmmChooseFlag;
    }

    public void setHmmChooseFlag(boolean hmmChooseFlag) {
        this.hmmChooseFlag = hmmChooseFlag;
    }

    public boolean isHmmTotalCollect() {
        return this.hmmTotalCollect;
    }

    public void setHmmTotalCollect(boolean hmmTotalCollect) {
        this.hmmTotalCollect = hmmTotalCollect;
    }

    public HwServerDevice getHwServerDev() {
        return this.hwServerDev;
    }

    public void setHwServerDev(HwServerDevice hwServerDev) {
        this.hwServerDev = hwServerDev;
    }

    public String getIpmiPort() {
        return this.ipmiPort;
    }

    public void setIpmiPort(String ipmiPort) {
        this.ipmiPort = ipmiPort;
    }

    @Override
    public String getDeviceSn() {
        return this.deviceSerialNumber;
    }

    public com.huawei.json.JSONObject getResultDetail() {
        return this.resultDetail;
    }

    public void setResultDetail(com.huawei.json.JSONObject resultDetail) {
        this.resultDetail = resultDetail;
    }

    public void refreshDeviceInfoBySelectJson(JSONObject jsonObj) {
        this.setDeviceCpld(jsonObj.containsKey((Object)"cpldVersion") ? jsonObj.getString("cpldVersion") : this.getDeviceCpld());
        this.setDeviceSW(jsonObj.containsKey((Object)"softwareVersion") ? jsonObj.getString("softwareVersion") : this.getDeviceSW());
        this.setMasterHMM(jsonObj.containsKey((Object)"masterHMM") ? jsonObj.getString("masterHMM") : this.getMasterHMM());
        this.setSlaveHMM(jsonObj.containsKey((Object)"slaveHMM") ? jsonObj.getString("slaveHMM") : this.getSlaveHMM());
        if (jsonObj.containsKey((Object)"slotsInfos")) {
            JSONArray jsonArray = jsonObj.getJSONArray("slotsInfos");
            for (int objIdx = 0; objIdx < jsonArray.size(); ++objIdx) {
                JSONObject computeNodeJsonObj = jsonArray.getJSONObject(objIdx);
                this.refreshComputeNodeByJsonObj(computeNodeJsonObj);
            }
        }
    }

    private void refreshComputeNodeByJsonObj(JSONObject computeNodeJsonObj) {
        String slotId = computeNodeJsonObj.getString("slotId");
        for (ServerComputeNode computeNode : this.serverComputeNodes) {
            if (!computeNode.getSlot().equals(slotId)) continue;
            computeNode.setCpld(computeNodeJsonObj.containsKey((Object)"cpldVersion") ? computeNodeJsonObj.getString("cpldVersion") : computeNode.getCpld());
            computeNode.setBios(computeNodeJsonObj.containsKey((Object)"biosVersion") ? computeNodeJsonObj.getString("biosVersion") : computeNode.getBios());
            computeNode.setMasterBMC(computeNodeJsonObj.containsKey((Object)"masterBMC") ? computeNodeJsonObj.getString("masterBMC") : computeNode.getMasterBMC());
            computeNode.setSlaveBMC(computeNodeJsonObj.containsKey((Object)"slaveBMC") ? computeNodeJsonObj.getString("slaveBMC") : computeNode.getSlaveBMC());
        }
    }

    @Override
    public String toString() {
        return "HMMDevice{serverExchangeModules=" + this.serverExchangeModules + ", serverComputeNodes=" + this.serverComputeNodes + ", vmmPort='" + this.vmmPort + '\'' + ", sshPort='" + this.sshPort + '\'' + ", snmpPort='" + this.snmpPort + '\'' + ", ipmiPort='" + this.ipmiPort + '\'' + ", hmmChooseFlag=" + this.hmmChooseFlag + ", hmmTotalCollect=" + this.hmmTotalCollect + ", productVersion='" + this.productVersion + '\'' + ", deviceSerialNumber='" + this.deviceSerialNumber + '\'' + ", deviceCpld='" + this.deviceCpld + '\'' + ", deviceSW='" + this.deviceSW + '\'' + ", masterHMM='" + this.masterHMM + '\'' + ", slaveHMM='" + this.slaveHMM + '\'' + ", resultDetail=" + this.resultDetail + ", hwServerDev=" + this.hwServerDev + '}';
    }
}

