/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.LogFilterHandle;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicecenter.entity.ComputeNodePlate;
import com.huawei.ism.tool.devicecenter.entity.HMMDevice;
import com.huawei.ism.tool.devicecenter.entity.ServerExchangeModule;
import com.huawei.ism.tool.devicecenter.entity.SwitchPlate;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.connection.ssh.SshKnownHostsManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMMDevice2Json {
    private static final Logger LOGGER = LoggerFactory.getLogger(HMMDevice2Json.class);
    @JSONField(name="ip")
    private String ip = "";
    @JSONField(name="type")
    private String type = "";
    @JSONField(name="productType")
    private String productType = "";
    @JSONField(name="serialNumber")
    private String serialNumber = "";
    @JSONField(name="cpldVersion")
    private String cpldVersion = "";
    @JSONField(name="softwareVersion")
    private String softwareVersion = "";
    @JSONField(name="sshPort")
    private String sshPort = "";
    @JSONField(name="snmpPort")
    private String snmpPort = "";
    @JSONField(name="ipmiPort")
    private String ipmiPort = "";
    @JSONField(name="vmmPort")
    private String vmmPort = "";
    @JSONField(name="httpsPort")
    private String httpsPort = "";
    @JSONField(name="snmpV2Community")
    private String hmmJsonSnmpV2Community = "";
    @JSONField(name="username")
    private String hmmUserName = "";
    @JSONField(name="password")
    private String hmmDevPwd = "";
    @JSONField(name="swichPlanes")
    private List<SwitchPlane2Json> swichPlanes = new ArrayList<SwitchPlane2Json>();
    @JSONField(name="slotApplyToOthers")
    private boolean slotApplyToOthers = true;
    @JSONField(name="slotsInfos")
    private List<ComputeNodeJson> slotsInfos = new ArrayList<ComputeNodeJson>();
    @JSONField(name="masterHMM")
    private String masterHMM;
    @JSONField(name="slaveHMM")
    private String slaveHMM;
    @JSONField(name="refreshFlag")
    private String refreshFlag;
    @JSONField(name="isPortProxy")
    private Boolean isPortProxy = false;
    @JSONField(name="proxyIp")
    private String proxyIp = "";
    @JSONField(name="onlySecurityAlgorithms")
    private String onlySecurityAlgorithms;
    @JSONField(name="sshHostKey")
    private String sshHostKey = "";
    @JSONField(name="isVerifySshHostKey")
    private String isVerifySshHostKey = "";
    @JSONField(name="redfishUserName")
    private String redFishUserName = "";
    @JSONField(name="redfishPwd")
    private String redFishPwd = "";
    @JSONField(name="isSupportAccountSeparation")
    private String isSupportAccountSeparation;

    public HMMDevice2Json(HMMDevice hmmDev) {
        this.initField(hmmDev);
        Map<String, SwitchPlate> switchPlateMap = hmmDev.getHwServerDev().getSwitchPlateMap();
        this.initSwitchPlanes(hmmDev, switchPlateMap);
        List<Object> computeNodePlateList = new ArrayList();
        if (null != hmmDev.getHwServerDev()) {
            this.setSlotApplyToOthers(hmmDev.getHwServerDev().isApplyToOtherNodes());
            computeNodePlateList = hmmDev.getHwServerDev().getComputeNodePlateList();
        }
        for (ComputeNodePlate plate : computeNodePlateList) {
            ComputeNodeJson computeNodeJson = new ComputeNodeJson();
            computeNodeJson.setSlotId(plate.getSlotId());
            computeNodeJson.setSlotSSHPort(plate.getSlotSSHPort());
            computeNodeJson.setSlotSNMPPort(plate.getSlotSNMPPort());
            computeNodeJson.setSlotHttpsPort(plate.getSlotHttpsPort());
            computeNodeJson.setSlotIPMIPort(plate.getSlotIPMIPort());
            computeNodeJson.setSlotUser(plate.getSlotUser());
            computeNodeJson.setSlotPasswd(AESEncrypt.encrypt((String)plate.getSlotPasswd()));
            computeNodeJson.setSlotSnmpPrivPwd(AESEncrypt.encrypt((String)plate.getSlotSnmpPrivPwd()));
            this.slotsInfos.add(computeNodeJson);
        }
    }

    private void initSwitchPlanes(HMMDevice hmmDev, Map<String, SwitchPlate> switchPlateMap) {
        for (Map.Entry<String, SwitchPlate> entry : switchPlateMap.entrySet()) {
            String key = entry.getKey();
            key = String.valueOf(key.charAt(key.length() - 1));
            SwitchPlate swPlate = entry.getValue();
            List<ServerExchangeModule> exchanges = hmmDev.getSwitchPlaneBySlotId("" + key);
            String productNameType = "";
            String soltId = "";
            if (!exchanges.isEmpty()) {
                productNameType = exchanges.get(0).getProduceName();
                soltId = exchanges.get(0).getSlot();
            } else {
                LOGGER.info(LogFilterHandle.vaildLog((String)("exchanges size = " + exchanges.size())));
            }
            SwitchPlane2Json switchPlane2Json = new SwitchPlane2Json();
            switchPlane2Json.setJsonBmcUsername(swPlate.getBmcUserName());
            switchPlane2Json.setBmcPwd(AESEncrypt.encrypt((String)swPlate.getBmcPwd()));
            SwPlane fbSwPlane = new SwPlane();
            this.fbSwPlanConfig(swPlate, productNameType, switchPlane2Json, fbSwPlane);
            SwPlane baseSwPlane = new SwPlane();
            this.basePlanConfig(swPlate, productNameType, switchPlane2Json, baseSwPlane);
            SwPlane fcSwPlane = new SwPlane();
            fcSwPlane.setType("fc");
            fcSwPlane.setProductType(productNameType);
            fcSwPlane.setSwPlaneUserName(swPlate.getFcUserName());
            fcSwPlane.setSwPlanePwd(AESEncrypt.encrypt((String)swPlate.getFcPwd()));
            fcSwPlane.setSshPort("");
            if (!fcSwPlane.judeUserPwdEmpty()) {
                switchPlane2Json.getSwPlanes().add(fcSwPlane);
            }
            if (StringUtils.isNULLStr((String)soltId)) {
                switchPlane2Json.setSlotId(key);
            } else {
                switchPlane2Json.setSlotId(soltId);
            }
            this.swichPlanes.add(switchPlane2Json);
        }
    }

    private void basePlanConfig(SwitchPlate swPlate, String productNameType, SwitchPlane2Json switchPlane2Json, SwPlane baseSwPlane) {
        baseSwPlane.setType("base");
        baseSwPlane.setProductType(productNameType);
        baseSwPlane.setSwPlaneUserName(swPlate.getBaseUserName());
        baseSwPlane.setSwPlanePwd(AESEncrypt.encrypt((String)swPlate.getBasePwd()));
        baseSwPlane.setSshPort("");
        if (!baseSwPlane.judeUserPwdEmpty()) {
            switchPlane2Json.getSwPlanes().add(baseSwPlane);
        }
    }

    private void fbSwPlanConfig(SwitchPlate swPlate, String productNameType, SwitchPlane2Json switchPlane2Json, SwPlane fbSwPlane) {
        fbSwPlane.setType("farbic");
        fbSwPlane.setProductType(productNameType);
        fbSwPlane.setSwPlaneUserName(swPlate.getFabricUserName());
        fbSwPlane.setSwPlanePwd(AESEncrypt.encrypt((String)swPlate.getFabricPwd()));
        fbSwPlane.setSshPort("");
        if (!fbSwPlane.judeUserPwdEmpty()) {
            switchPlane2Json.getSwPlanes().add(fbSwPlane);
        }
    }

    private void initField(HMMDevice device) {
        this.ip = device.getIp();
        this.type = "hmm";
        this.productType = device.getProductName();
        this.serialNumber = device.getDeviceSerialNumber();
        this.cpldVersion = device.getDeviceCpld();
        this.softwareVersion = device.getDeviceSW();
        this.sshPort = device.getHwServerDev().getSshPort() + "";
        this.snmpPort = device.getHwServerDev().getSnmpPort() + "";
        this.httpsPort = device.getHwServerDev().getRedFishPort();
        this.ipmiPort = device.getHwServerDev().getIpmiPort() + "";
        this.vmmPort = device.getHwServerDev().getVmmPort() + "";
        this.hmmJsonSnmpV2Community = AESEncrypt.encrypt((String)device.getHwServerDev().getCommunity());
        this.hmmUserName = device.getHwServerDev().getUserName();
        this.hmmDevPwd = AESEncrypt.encrypt((String)device.getHwServerDev().getUserPwd());
        this.onlySecurityAlgorithms = Boolean.toString(device.getHwServerDev().isOnlySecurityAlgSupportedFlag());
        this.isPortProxy = device.getHwServerDev().isPortProxy();
        if (this.isPortProxy.booleanValue()) {
            this.proxyIp = device.getHwServerDev().getStartIPAddress();
        }
        if (ApplicationContext.getInstance().isVerifySshHostKey()) {
            this.sshHostKey = AESEncrypt.encrypt((String)SshKnownHostsManager.getHostKeyInfo(device.getIp()));
            this.isVerifySshHostKey = AESEncrypt.encrypt((String)(SshKnownHostsManager.isVerifySshHostKeyInfo(device.getIp()) + ""));
        }
        if (device.getHwServerDev().isSupportAccountSeparation()) {
            this.redFishUserName = device.getHwServerDev().getRedFishUserName();
            this.redFishPwd = AESEncrypt.encrypt((String)device.getHwServerDev().getRedFishPwd());
        } else {
            this.redFishUserName = device.getHwServerDev().getUserName();
            this.redFishPwd = AESEncrypt.encrypt((String)device.getHwServerDev().getUserPwd());
        }
        this.isSupportAccountSeparation = Boolean.toString(device.getHwServerDev().isSupportAccountSeparation());
    }

    public String getProductType() {
        return this.productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getCpldVersion() {
        return this.cpldVersion;
    }

    public void setCpldVersion(String cpldVersion) {
        this.cpldVersion = cpldVersion;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public String getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(String sshPort) {
        this.sshPort = sshPort;
    }

    public String getSnmpPort() {
        return this.snmpPort;
    }

    public void setSnmpPort(String snmpPort) {
        this.snmpPort = snmpPort;
    }

    public String getIpmiPort() {
        return this.ipmiPort;
    }

    public void setIpmiPort(String ipmiPort) {
        this.ipmiPort = ipmiPort;
    }

    public String getVmmPort() {
        return this.vmmPort;
    }

    public void setVmmPort(String vmmPort) {
        this.vmmPort = vmmPort;
    }

    public String getHmmJsonSnmpV2Community() {
        return this.hmmJsonSnmpV2Community;
    }

    public void setHmmJsonSnmpV2Community(String hmmJsonSnmpV2Community) {
        this.hmmJsonSnmpV2Community = hmmJsonSnmpV2Community;
    }

    public String getHmmUserName() {
        return this.hmmUserName;
    }

    public void setHmmUserName(String hmmUserName) {
        this.hmmUserName = hmmUserName;
    }

    public String getHmmDevPwd() {
        return this.hmmDevPwd;
    }

    public void setHmmDevPwd(String hmmDevPwd) {
        this.hmmDevPwd = hmmDevPwd;
    }

    public List<SwitchPlane2Json> getSwichPlanes() {
        return this.swichPlanes;
    }

    public void setSwichPlanes(List<SwitchPlane2Json> swichPlanes) {
        this.swichPlanes = swichPlanes;
    }

    public boolean isSlotApplyToOthers() {
        return this.slotApplyToOthers;
    }

    public void setSlotApplyToOthers(boolean slotApplyToOthers) {
        this.slotApplyToOthers = slotApplyToOthers;
    }

    public List<ComputeNodeJson> getSlotsInfos() {
        return this.slotsInfos;
    }

    public void setSlotsInfos(List<ComputeNodeJson> slotsInfos) {
        this.slotsInfos = slotsInfos;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(String httpsPort) {
        this.httpsPort = httpsPort;
    }

    public String getMasterHMM() {
        return this.masterHMM;
    }

    public void setMasterHMM(String masterHMM) {
        this.masterHMM = masterHMM;
    }

    public String getSlaveHMM() {
        return this.slaveHMM;
    }

    public void setSlaveHMM(String slaveHMM) {
        this.slaveHMM = slaveHMM;
    }

    public String getRefreshFlag() {
        return this.refreshFlag;
    }

    public void setRefreshFlag(String refreshFlag) {
        this.refreshFlag = refreshFlag;
    }

    public String getOnlySecurityAlgorithms() {
        return this.onlySecurityAlgorithms;
    }

    public void setOnlySecurityAlgorithms(String onlySecurityAlgorithms) {
        this.onlySecurityAlgorithms = onlySecurityAlgorithms;
    }

    public String toString() {
        return "HMMDevice2Json{ip='" + this.ip + '\'' + ", type='" + this.type + '\'' + ", productType='" + this.productType + '\'' + ", serialNumber='" + this.serialNumber + '\'' + ", cpldVersion='" + this.cpldVersion + '\'' + ", softwareVersion='" + this.softwareVersion + '\'' + ", sshPort='" + this.sshPort + '\'' + ", snmpPort='" + this.snmpPort + '\'' + ", ipmiPort='" + this.ipmiPort + '\'' + ", vmmPort='" + this.vmmPort + '\'' + ", httpsPort='" + this.httpsPort + '\'' + ", swichPlanes=" + this.swichPlanes + ", slotApplyToOthers=" + this.slotApplyToOthers + ", slotsInfos=" + this.slotsInfos + ", masterHMM='" + this.masterHMM + '\'' + ", slaveHMM='" + this.slaveHMM + '\'' + ", refreshFlag='" + this.refreshFlag + '\'' + '}';
    }

    public void setIsPortProxy(Boolean isPortProxy) {
        this.isPortProxy = isPortProxy;
    }

    public Boolean getIsPortProxy() {
        return this.isPortProxy;
    }

    public void setProxyIp(String proxyIp) {
        this.proxyIp = proxyIp;
    }

    public String getProxyIp() {
        return this.proxyIp;
    }

    public void setSshHostKey(String sshHostKey) {
        this.sshHostKey = sshHostKey;
    }

    public String getSshHostKey() {
        return this.sshHostKey;
    }

    public void setIsVerifySshHostKey(String isVerifySshHostKey) {
        this.isVerifySshHostKey = isVerifySshHostKey;
    }

    public String getIsVerifySshHostKey() {
        return this.isVerifySshHostKey;
    }

    public String getRedFishUserName() {
        return this.redFishUserName;
    }

    public void setRedFishUserName(String redFishUserName) {
        this.redFishUserName = redFishUserName;
    }

    public String getRedFishPwd() {
        return this.redFishPwd;
    }

    public void setRedFishPwd(String redFishPwd) {
        this.redFishPwd = redFishPwd;
    }

    public String getIsSupportAccountSeparation() {
        return this.isSupportAccountSeparation;
    }

    public void setIsSupportAccountSeparation(String isSupportAccountSeparation) {
        this.isSupportAccountSeparation = isSupportAccountSeparation;
    }

    class ComputeNodeJson {
        @JSONField(name="slotId")
        private String slotId = "";
        @JSONField(name="username")
        private String slotUser = "";
        @JSONField(name="password")
        private String slotPasswd = "";
        @JSONField(name="snmpPrivPassword")
        private String slotSnmpPrivPwd = "";
        @JSONField(name="sshPort")
        private String slotSSHPort = "";
        @JSONField(name="ipmiPort")
        private String slotIPMIPort = "";
        @JSONField(name="httpsPort")
        private String slotHttpsPort = "";
        @JSONField(name="snmpPort")
        private String slotSNMPPort = "";
        @JSONField(name="cpldVersion")
        private String cpldVersion;
        @JSONField(name="biosVersion")
        private String biosVersion;
        @JSONField(name="masterBMC")
        private String masterBMC;
        @JSONField(name="slaveBMC")
        private String slaveBMC;

        ComputeNodeJson() {
        }

        public String getSlotId() {
            return this.slotId;
        }

        public void setSlotId(String slotId) {
            this.slotId = slotId;
        }

        public String getSlotUser() {
            return this.slotUser;
        }

        public void setSlotUser(String slotUser) {
            this.slotUser = slotUser;
        }

        public String getSlotPasswd() {
            return this.slotPasswd;
        }

        public void setSlotPasswd(String slotPasswd) {
            this.slotPasswd = slotPasswd;
        }

        public String getSlotSSHPort() {
            return this.slotSSHPort;
        }

        public void setSlotSSHPort(String slotSSHPort) {
            this.slotSSHPort = slotSSHPort;
        }

        public String getSlotIPMIPort() {
            return this.slotIPMIPort;
        }

        public void setSlotIPMIPort(String slotIPMIPort) {
            this.slotIPMIPort = slotIPMIPort;
        }

        public String getSlotHttpsPort() {
            return this.slotHttpsPort;
        }

        public void setSlotHttpsPort(String slotHttpsPort) {
            this.slotHttpsPort = slotHttpsPort;
        }

        public String getSlotSNMPPort() {
            return this.slotSNMPPort;
        }

        public void setSlotSNMPPort(String slotSNMPPort) {
            this.slotSNMPPort = slotSNMPPort;
        }

        public String getSlotSnmpPrivPwd() {
            return this.slotSnmpPrivPwd;
        }

        public void setSlotSnmpPrivPwd(String slotSnmpPrivPwd) {
            this.slotSnmpPrivPwd = slotSnmpPrivPwd;
        }

        public String getCpldVersion() {
            return this.cpldVersion;
        }

        public void setCpldVersion(String cpldVersion) {
            this.cpldVersion = cpldVersion;
        }

        public String getBiosVersion() {
            return this.biosVersion;
        }

        public void setBiosVersion(String biosVersion) {
            this.biosVersion = biosVersion;
        }

        public String getMasterBMC() {
            return this.masterBMC;
        }

        public void setMasterBMC(String masterBMC) {
            this.masterBMC = masterBMC;
        }

        public String getSlaveBMC() {
            return this.slaveBMC;
        }

        public void setSlaveBMC(String slaveBMC) {
            this.slaveBMC = slaveBMC;
        }
    }

    class SwPlane {
        @JSONField(name="type")
        private String type = "";
        @JSONField(name="productType")
        private String productType = "";
        @JSONField(name="username")
        private String swPlaneUserName = "";
        @JSONField(name="password")
        private String swPlanePwd = "";
        @JSONField(name="sshPort")
        private String sshPort = "";

        SwPlane() {
        }

        public boolean judeUserPwdEmpty() {
            return "".equals(this.swPlaneUserName) && "".equals(this.swPlanePwd);
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getProductType() {
            return this.productType;
        }

        public void setProductType(String productType) {
            this.productType = productType;
        }

        public String getSwPlaneUserName() {
            return this.swPlaneUserName;
        }

        public void setSwPlaneUserName(String swPlaneUserName) {
            this.swPlaneUserName = swPlaneUserName;
        }

        public String getSwPlanePwd() {
            return this.swPlanePwd;
        }

        public void setSwPlanePwd(String swPlanePwd) {
            this.swPlanePwd = swPlanePwd;
        }

        public String getSshPort() {
            return this.sshPort;
        }

        public void setSshPort(String sshPort) {
            this.sshPort = sshPort;
        }
    }

    class SwitchPlane2Json {
        @JSONField(name="slotId")
        private String slotId = "";
        @JSONField(name="bmcUsername")
        private String jsonBmcUsername = "";
        @JSONField(name="bmcPassword")
        private String bmcPwd = "";
        @JSONField(name="plane")
        private List<SwPlane> swPlanes = new ArrayList<SwPlane>();

        SwitchPlane2Json() {
        }

        public String getSlotId() {
            return this.slotId;
        }

        public void setSlotId(String slotId) {
            this.slotId = slotId;
        }

        public String getJsonBmcUsername() {
            return this.jsonBmcUsername;
        }

        public void setJsonBmcUsername(String jsonBmcUsername) {
            this.jsonBmcUsername = jsonBmcUsername;
        }

        public String getBmcPwd() {
            return this.bmcPwd;
        }

        public void setBmcPwd(String bmcPwd) {
            this.bmcPwd = bmcPwd;
        }

        public List<SwPlane> getSwPlanes() {
            return this.swPlanes;
        }

        public void setSwPlanes(List<SwPlane> swPlanes) {
            this.swPlanes = swPlanes;
        }
    }
}

