/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.devicecenter.entity.IBMCDevice;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.connection.ssh.SshKnownHostsManager;

public class IBMCDevice2Json {
    @JSONField(name="ip")
    private String ip = "";
    @JSONField(name="type")
    private String type = "";
    @JSONField(name="productType")
    private String productType = "";
    @JSONField(name="serialNumber")
    private String serialNumber = "";
    @JSONField(name="cpldVersion")
    private String cpldVersion = "";
    @JSONField(name="biosVersion")
    private String biosVersion = "";
    @JSONField(name="masterBMC")
    private String masterBMC = "";
    @JSONField(name="slaveBMC")
    private String slaveBMC = "";
    @JSONField(name="sshPort")
    private String sshPort = "";
    @JSONField(name="snmpPort")
    private String snmpPort = "";
    @JSONField(name="ipmiPort")
    private String ipmiPort = "";
    @JSONField(name="vmmPort")
    private String vmmPort = "";
    @JSONField(name="httpsPort")
    private String httpsPort = "";
    @JSONField(name="snmpV2Community")
    private String snmpV2Community = "";
    @JSONField(name="username")
    private String ibmcUserName = "";
    @JSONField(name="password")
    private String pwd = "";
    @JSONField(name="snmpPrivPassword")
    private String snmpPwd = "";
    @JSONField(name="onlySecurityAlgorithms")
    private String onlySecurityAlgorithms = "";
    @JSONField(name="sshHostKey")
    private String sshHostKey = "";
    @JSONField(name="isVerifySshHostKey")
    private String isVerifySshHostKey = "";
    @JSONField(name="redfishUserName")
    private String redFishUserName = "";
    @JSONField(name="redfishPwd")
    private String redFishPwd = "";
    @JSONField(name="isSupportAccountSeparation")
    private String isSupportAccountSeparation;
    @JSONField(name="isPortProxy")
    private Boolean isPortProxy = false;
    @JSONField(name="proxyIp")
    private String proxyIp = "";

    public IBMCDevice2Json(IBMCDevice ibmcDev) {
        this.initField(ibmcDev);
    }

    private void initField(IBMCDevice device) {
        this.ip = device.getIp();
        this.type = "ibmc";
        this.httpsPort = device.getHwServerDev().getRedFishPort();
        this.productType = device.getProductName();
        this.cpldVersion = device.getCpld();
        this.serialNumber = device.getDeviceSerialNumber();
        this.biosVersion = device.getBios();
        this.masterBMC = device.getMasterBMC();
        this.slaveBMC = device.getSlaveBMC();
        this.sshPort = device.getHwServerDev().getSshPort() + "";
        this.snmpPort = device.getHwServerDev().getSnmpPort() + "";
        this.ipmiPort = device.getHwServerDev().getIpmiPort() + "";
        this.vmmPort = device.getHwServerDev().getVmmPort() + "";
        this.snmpV2Community = AESEncrypt.encrypt((String)device.getHwServerDev().getCommunity());
        this.ibmcUserName = device.getHwServerDev().getUserName();
        this.pwd = AESEncrypt.encrypt((String)device.getHwServerDev().getUserPwd());
        this.snmpPwd = AESEncrypt.encrypt((String)device.getHwServerDev().getSnmpPrivPwd());
        this.onlySecurityAlgorithms = Boolean.toString(device.getHwServerDev().isOnlySecurityAlgSupportedFlag());
        if (ApplicationContext.getInstance().isVerifySshHostKey()) {
            this.sshHostKey = AESEncrypt.encrypt((String)SshKnownHostsManager.getHostKeyInfo(device.getIp()));
            this.isVerifySshHostKey = AESEncrypt.encrypt((String)(SshKnownHostsManager.isVerifySshHostKeyInfo(device.getIp()) + ""));
        }
        if (device.getHwServerDev().isSupportAccountSeparation()) {
            this.redFishUserName = device.getHwServerDev().getRedFishUserName();
            this.redFishPwd = AESEncrypt.encrypt((String)device.getHwServerDev().getRedFishPwd());
        } else {
            this.redFishUserName = device.getHwServerDev().getUserName();
            this.redFishPwd = AESEncrypt.encrypt((String)device.getHwServerDev().getUserPwd());
        }
        this.isSupportAccountSeparation = Boolean.toString(device.getHwServerDev().isSupportAccountSeparation());
        this.isPortProxy = device.getHwServerDev().isPortProxy();
        if (this.isPortProxy.booleanValue()) {
            this.proxyIp = device.getHwServerDev().getStartIPAddress();
        }
    }

    public String getProductType() {
        return this.productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getCpldVersion() {
        return this.cpldVersion;
    }

    public void setCpldVersion(String cpldVersion) {
        this.cpldVersion = cpldVersion;
    }

    public String getBiosVersion() {
        return this.biosVersion;
    }

    public void setBiosVersion(String biosVersion) {
        this.biosVersion = biosVersion;
    }

    public String getMasterBMC() {
        return this.masterBMC;
    }

    public void setMasterBMC(String masterBMC) {
        this.masterBMC = masterBMC;
    }

    public String getSlaveBMC() {
        return this.slaveBMC;
    }

    public void setSlaveBMC(String slaveBMC) {
        this.slaveBMC = slaveBMC;
    }

    public String getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(String sshPort) {
        this.sshPort = sshPort;
    }

    public String getSnmpPort() {
        return this.snmpPort;
    }

    public void setSnmpPort(String snmpPort) {
        this.snmpPort = snmpPort;
    }

    public String getIpmiPort() {
        return this.ipmiPort;
    }

    public void setIpmiPort(String ipmiPort) {
        this.ipmiPort = ipmiPort;
    }

    public String getVmmPort() {
        return this.vmmPort;
    }

    public void setVmmPort(String vmmPort) {
        this.vmmPort = vmmPort;
    }

    public String getSnmpV2Community() {
        return this.snmpV2Community;
    }

    public void setSnmpV2Community(String snmpV2Community) {
        this.snmpV2Community = snmpV2Community;
    }

    public String getIbmcUserName() {
        return this.ibmcUserName;
    }

    public void setIbmcUserName(String ibmcUserName) {
        this.ibmcUserName = ibmcUserName;
    }

    public String getPwd() {
        return this.pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public String getIp() {
        return this.ip;
    }

    public String getType() {
        return this.type;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setHttpsPort(String httpsPort) {
        this.httpsPort = httpsPort;
    }

    public String getHttpsPort() {
        return this.httpsPort;
    }

    public String getSnmpPwd() {
        return this.snmpPwd;
    }

    public void setSnmpPwd(String snmpPwd) {
        this.snmpPwd = snmpPwd;
    }

    public String toString() {
        return "IBMCDevice2Json{ip='" + this.ip + '\'' + ", type='" + this.type + '\'' + ", productType='" + this.productType + '\'' + ", serialNumber='" + this.serialNumber + '\'' + ", cpldVersion='" + this.cpldVersion + '\'' + ", biosVersion='" + this.biosVersion + '\'' + ", masterBMC='" + this.masterBMC + '\'' + ", slaveBMC='" + this.slaveBMC + '\'' + ", sshPort='" + this.sshPort + '\'' + ", snmpPort='" + this.snmpPort + '\'' + ", ipmiPort='" + this.ipmiPort + '\'' + ", vmmPort='" + this.vmmPort + '\'' + ", httpsPort='" + this.httpsPort + '\'' + '}';
    }

    public String getOnlySecurityAlgorithms() {
        return this.onlySecurityAlgorithms;
    }

    public void setOnlySecurityAlgorithms(String onlySecurityAlgorithms) {
        this.onlySecurityAlgorithms = onlySecurityAlgorithms;
    }

    public void setSshHostKey(String sshHostKey) {
        this.sshHostKey = sshHostKey;
    }

    public String getSshHostKey() {
        return this.sshHostKey;
    }

    public void setIsVerifySshHostKey(String isVerifySshHostKey) {
        this.isVerifySshHostKey = isVerifySshHostKey;
    }

    public String getIsVerifySshHostKey() {
        return this.isVerifySshHostKey;
    }

    public String getRedFishUserName() {
        return this.redFishUserName;
    }

    public void setRedFishUserName(String redFishUserName) {
        this.redFishUserName = redFishUserName;
    }

    public String getRedFishPwd() {
        return this.redFishPwd;
    }

    public void setRedFishPwd(String redFishPwd) {
        this.redFishPwd = redFishPwd;
    }

    public String getIsSupportAccountSeparation() {
        return this.isSupportAccountSeparation;
    }

    public void setIsSupportAccountSeparation(String isSupportAccountSeparation) {
        this.isSupportAccountSeparation = isSupportAccountSeparation;
    }

    public void setIsPortProxy(Boolean isPortProxy) {
        this.isPortProxy = isPortProxy;
    }

    public Boolean getIsPortProxy() {
        return this.isPortProxy;
    }

    public void setProxyIp(String proxyIp) {
        this.proxyIp = proxyIp;
    }

    public String getProxyIp() {
        return this.proxyIp;
    }
}

