/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.devicecenter.entity.IESDevice;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.connection.ssh.SshKnownHostsManager;

public class IESDevice2Json {
    @JSONField(name="hostName")
    private String hostName;
    @JSONField(name="productName")
    private String productName;
    @JSONField(name="serialNumber")
    private String serialNumber;
    @JSONField(name="ip")
    private String ip;
    @JSONField(name="softwareVersion")
    private String softwareVersion;
    @JSONField(name="username")
    private String username;
    @JSONField(name="password")
    private String password;
    @JSONField(name="rootPassword")
    private String rootPassword;
    @JSONField(name="type")
    private String type = "";
    @JSONField(name="sshPort")
    private String sshPort = "";
    @JSONField(name="snmpPort")
    private String snmpPort = "";
    @JSONField(name="ipmiPort")
    private String ipmiPort = "";
    @JSONField(name="vmmPort")
    private String vmmPort = "";
    @JSONField(name="httpsPort")
    private String httpsPort = "";
    @JSONField(name="onlySecurityAlgorithms")
    private String onlySecurityAlgorithms = "";
    @JSONField(name="sshHostKey")
    private String sshHostKey = "";
    @JSONField(name="isVerifySshHostKey")
    private String isVerifySshHostKey = "";
    @JSONField(name="redfishUserName")
    private String redFishUserName = "";
    @JSONField(name="redfishPwd")
    private String redFishPwd = "";
    @JSONField(name="isSupportAccountSeparation")
    private String isSupportAccountSeparation;

    public IESDevice2Json(IESDevice iesDev) {
        this.initField(iesDev);
    }

    private void initField(IESDevice device) {
        this.hostName = device.getHostName();
        this.productName = device.getProductName();
        this.serialNumber = device.getSnNo();
        this.ip = device.getIp();
        if (!device.isRefreshFlag()) {
            this.softwareVersion = device.getVersion();
        }
        this.username = device.getHwServerDev().getUserName();
        this.password = AESEncrypt.encrypt((String)device.getHwServerDev().getUserPwd());
        this.type = "ies";
        this.sshPort = device.getHwServerDev().getSshPort() + "";
        this.snmpPort = device.getHwServerDev().getSnmpPort() + "";
        this.ipmiPort = device.getHwServerDev().getIpmiPort() + "";
        this.vmmPort = device.getHwServerDev().getVmmPort() + "";
        this.httpsPort = device.getHwServerDev().getRedFishPort();
        this.rootPassword = AESEncrypt.encrypt((String)device.getHwServerDev().getRootPwd());
        this.onlySecurityAlgorithms = Boolean.toString(device.getHwServerDev().isOnlySecurityAlgSupportedFlag());
        if (ApplicationContext.getInstance().isVerifySshHostKey()) {
            this.sshHostKey = AESEncrypt.encrypt((String)SshKnownHostsManager.getHostKeyInfo(device.getIp()));
            this.isVerifySshHostKey = AESEncrypt.encrypt((String)(SshKnownHostsManager.isVerifySshHostKeyInfo(device.getIp()) + ""));
        }
        if (device.getHwServerDev().isSupportAccountSeparation()) {
            this.redFishUserName = device.getHwServerDev().getRedFishUserName();
            this.redFishPwd = AESEncrypt.encrypt((String)device.getHwServerDev().getRedFishPwd());
        } else {
            this.redFishUserName = device.getHwServerDev().getUserName();
            this.redFishPwd = AESEncrypt.encrypt((String)device.getHwServerDev().getUserPwd());
        }
        this.isSupportAccountSeparation = Boolean.toString(device.getHwServerDev().isSupportAccountSeparation());
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(String sshPort) {
        this.sshPort = sshPort;
    }

    public String getSnmpPort() {
        return this.snmpPort;
    }

    public void setSnmpPort(String snmpPort) {
        this.snmpPort = snmpPort;
    }

    public String getIpmiPort() {
        return this.ipmiPort;
    }

    public void setIpmiPort(String ipmiPort) {
        this.ipmiPort = ipmiPort;
    }

    public String getVmmPort() {
        return this.vmmPort;
    }

    public void setVmmPort(String vmmPort) {
        this.vmmPort = vmmPort;
    }

    public String getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(String httpsPort) {
        this.httpsPort = httpsPort;
    }

    public String getRootPassword() {
        return this.rootPassword;
    }

    public void setRootPassword(String rootPassword) {
        this.rootPassword = rootPassword;
    }

    public String toString() {
        return "IESDevice2Json{hostName='" + this.hostName + '\'' + ", productName='" + this.productName + '\'' + ", serialNumber='" + this.serialNumber + '\'' + ", ip='" + this.ip + '\'' + ", softwareVersion='" + this.softwareVersion + '\'' + ", type='" + this.type + '\'' + ", sshPort='" + this.sshPort + '\'' + ", snmpPort='" + this.snmpPort + '\'' + ", ipmiPort='" + this.ipmiPort + '\'' + ", vmmPort='" + this.vmmPort + '\'' + ", httpsPort='" + this.httpsPort + '\'' + '}';
    }

    public String getOnlySecurityAlgorithms() {
        return this.onlySecurityAlgorithms;
    }

    public void setOnlySecurityAlgorithms(String onlySecurityAlgorithms) {
        this.onlySecurityAlgorithms = onlySecurityAlgorithms;
    }

    public void setSshHostKey(String sshHostKey) {
        this.sshHostKey = sshHostKey;
    }

    public String getSshHostKey() {
        return this.sshHostKey;
    }

    public void setIsVerifySshHostKey(String isVerifySshHostKey) {
        this.isVerifySshHostKey = isVerifySshHostKey;
    }

    public String getIsVerifySshHostKey() {
        return this.isVerifySshHostKey;
    }

    public String getRedFishUserName() {
        return this.redFishUserName;
    }

    public void setRedFishUserName(String redFishUserName) {
        this.redFishUserName = redFishUserName;
    }

    public String getRedFishPwd() {
        return this.redFishPwd;
    }

    public void setRedFishPwd(String redFishPwd) {
        this.redFishPwd = redFishPwd;
    }

    public String getIsSupportAccountSeparation() {
        return this.isSupportAccountSeparation;
    }

    public void setIsSupportAccountSeparation(String isSupportAccountSeparation) {
        this.isSupportAccountSeparation = isSupportAccountSeparation;
    }
}

