/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.devicecenter.entity.OsDevice;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.connection.ssh.SshKnownHostsManager;

public class OsDevice2Json {
    @JSONField(name="ip")
    private String ip = "";
    @JSONField(name="type")
    private String type = "";
    @JSONField(name="kernelVersion")
    private String kernelVersion = "";
    @JSONField(name="username")
    private String osDevusername = "";
    @JSONField(name="password")
    private String osPwd = "";
    @JSONField(name="osType")
    private String osType = "";
    @JSONField(name="rootPassword")
    private String osRootPwd = "";
    @JSONField(name="sshPort")
    private String sshPort = "";
    @JSONField(name="onlySecurityAlgorithms")
    private String onlySecurityAlgorithms = "";
    @JSONField(name="sshHostKey")
    private String sshHostKey = "";
    @JSONField(name="isVerifySshHostKey")
    private String isVerifySshHostKey = "";
    @JSONField(name="redfishUserName")
    private String redFishUserName = "";
    @JSONField(name="redfishPwd")
    private String redFishPwd = "";
    @JSONField(name="isSupportAccountSeparation")
    private String isSupportAccountSeparation;

    public OsDevice2Json(OsDevice device) {
        this.initField(device);
    }

    private void initField(OsDevice dev) {
        this.ip = dev.getIp();
        this.type = "os";
        this.kernelVersion = dev.getKernerVersion();
        this.osDevusername = dev.getHwServerDev().getUserName();
        this.osPwd = AESEncrypt.encrypt((String)dev.getHwServerDev().getUserPwd());
        this.osType = dev.getOsType();
        this.osRootPwd = AESEncrypt.encrypt((String)dev.getHwServerDev().getRootPwd());
        this.sshPort = dev.getHwServerDev().getSshPort() + "";
        this.onlySecurityAlgorithms = Boolean.toString(dev.getHwServerDev().isOnlySecurityAlgSupportedFlag());
        if (ApplicationContext.getInstance().isVerifySshHostKey()) {
            this.sshHostKey = AESEncrypt.encrypt((String)SshKnownHostsManager.getHostKeyInfo(dev.getIp()));
            this.isVerifySshHostKey = AESEncrypt.encrypt((String)(SshKnownHostsManager.isVerifySshHostKeyInfo(dev.getIp()) + ""));
        }
        if (dev.getHwServerDev().isSupportAccountSeparation()) {
            this.redFishUserName = dev.getHwServerDev().getRedFishUserName();
            this.redFishPwd = AESEncrypt.encrypt((String)dev.getHwServerDev().getRedFishPwd());
        } else {
            this.redFishUserName = dev.getHwServerDev().getUserName();
            this.redFishPwd = AESEncrypt.encrypt((String)dev.getHwServerDev().getUserPwd());
        }
        this.isSupportAccountSeparation = Boolean.toString(dev.getHwServerDev().isSupportAccountSeparation());
    }

    public String getIp() {
        return this.ip;
    }

    public String getType() {
        return this.type;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getKernelVersion() {
        return this.kernelVersion;
    }

    public void setKernelVersion(String kernelVersion) {
        this.kernelVersion = kernelVersion;
    }

    public String getOsDevusername() {
        return this.osDevusername;
    }

    public void setOsDevusername(String osDevusername) {
        this.osDevusername = osDevusername;
    }

    public String getOsPwd() {
        return this.osPwd;
    }

    public void setOsPwd(String osPwd) {
        this.osPwd = osPwd;
    }

    public String getOsType() {
        return this.osType;
    }

    public void setOsType(String osType) {
        this.osType = osType;
    }

    public String getOsRootPwd() {
        return this.osRootPwd;
    }

    public void setOsRootPwd(String osRootPwd) {
        this.osRootPwd = osRootPwd;
    }

    public String getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(String sshPort) {
        this.sshPort = sshPort;
    }

    public String toString() {
        return "OsDevice2Json{ip='" + this.ip + '\'' + ", type='" + this.type + '\'' + ", kernelVersion='" + this.kernelVersion + '\'' + ", osType='" + this.osType + '\'' + ", sshPort='" + this.sshPort + '\'' + '}';
    }

    public String getOnlySecurityAlgorithms() {
        return this.onlySecurityAlgorithms;
    }

    public void setOnlySecurityAlgorithms(String onlySecurityAlgorithms) {
        this.onlySecurityAlgorithms = onlySecurityAlgorithms;
    }

    public void setSshHostKey(String sshHostKey) {
        this.sshHostKey = sshHostKey;
    }

    public String getSshHostKey() {
        return this.sshHostKey;
    }

    public void setIsVerifySshHostKey(String isVerifySshHostKey) {
        this.isVerifySshHostKey = isVerifySshHostKey;
    }

    public String getIsVerifySshHostKey() {
        return this.isVerifySshHostKey;
    }

    public String getRedFishUserName() {
        return this.redFishUserName;
    }

    public void setRedFishUserName(String redFishUserName) {
        this.redFishUserName = redFishUserName;
    }

    public String getRedFishPwd() {
        return this.redFishPwd;
    }

    public void setRedFishPwd(String redFishPwd) {
        this.redFishPwd = redFishPwd;
    }

    public String getIsSupportAccountSeparation() {
        return this.isSupportAccountSeparation;
    }

    public void setIsSupportAccountSeparation(String isSupportAccountSeparation) {
        this.isSupportAccountSeparation = isSupportAccountSeparation;
    }
}

