/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.listener;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.service.UpdateBtnServiceInterface;
import com.huawei.ism.tool.devicecenter.thread.CheckPortThread;
import com.huawei.ism.tool.devicecenter.ui.SerDeviTitleLabel;
import com.huawei.ism.tool.devicecenter.ui.dialog.BatchPortsCheckDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSelectedDevicesPortListener
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(CheckSelectedDevicesPortListener.class);
    private List<SerDeviTitleLabel> devTables;

    @Override
    public void actionPerformed(ActionEvent e) {
        BatchPortsCheckDialog portsCheckDialog = new BatchPortsCheckDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.import.check.port"));
        List<AbstractDevice> deviceList = this.selectDeviceCheckPorts();
        if (deviceList.isEmpty()) {
            DialogUtils.showInfoDialog((Frame)DeviceCenterContext.getInstance().getParent(), (String)ResourceUtil.getString((String)"smartkit.devicemanager.layout.device.check.port.not.supported"));
        } else {
            AsyncExcutor.submit((Runnable)new CheckPortThread(deviceList, portsCheckDialog));
        }
    }

    private List<AbstractDevice> selectDeviceCheckPorts() {
        Optional<UpdateBtnServiceInterface> curTable = this.devTables.stream().filter(SerDeviTitleLabel::isSelect).findFirst().map(SerDeviTitleLabel::getCurTable);
        if (!curTable.isPresent()) {
            log.error("select device check ports, has no this type.");
            return Collections.emptyList();
        }
        return curTable.get().getCurrentNeedCheckPortDeviceList();
    }

    public CheckSelectedDevicesPortListener(List<SerDeviTitleLabel> devTables) {
        this.devTables = devTables;
    }
}

