/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.listener;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.utils.LogUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;

public class ExcelListener
extends MouseAdapter {
    public static final String TEMPLATE_FILE_NAME_EN = "hwServers_en.xls";
    public static final String TEMPLATE_FILE_NAME_ZH = "hwServers_zh.xls";
    public static final String TEMPLATE_FILE_NAME = "ServerDeviceList_Template.xls";
    public static final String TEMPLATE_FILE_PATH = "/config/devicecenter/";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ExcelListener.class);
    private static final String SAVEPATH_DEFAULT_ID = "Import_saveresult_path";
    private Window parent = null;

    @Override
    public void mouseClicked(MouseEvent e) {
        this.parent = DeviceCenterContext.getInstance().getParent();
        boolean result = this.savaTemplate2Local();
        if (result) {
            DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"devicemanager.layout.device.downloadtemplate.success"));
            LogUtils.addImportLog("devicemanager.server.manager.layout.excel", TEMPLATE_FILE_NAME, true, "");
        } else {
            LogUtils.addImportLog("devicemanager.server.manager.layout.excel", TEMPLATE_FILE_NAME, false, "");
        }
    }

    private boolean savaTemplate2Local() {
        String defaultFileName;
        String suffix;
        String title = ResourceUtil.getString((String)"devicemanager.layout.device.downloadtemplate.path");
        String filePath = ToolFileChooser.getSaveFilePath(title, suffix = "xls", this.parent, defaultFileName = TEMPLATE_FILE_NAME, SAVEPATH_DEFAULT_ID);
        if (null == filePath) {
            return false;
        }
        boolean result = this.writeTemplateFile2Local(filePath);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeTemplateFile2Local(String filePath) {
        block12: {
            boolean bl;
            String templateFileName = "";
            templateFileName = ApplicationContext.getInstance().isEnglishEnv() ? TEMPLATE_FILE_NAME_EN : TEMPLATE_FILE_NAME_ZH;
            InputStream ins = ExcelListener.class.getResourceAsStream(TEMPLATE_FILE_PATH + templateFileName);
            FileOutputStream outs = null;
            try {
                if (null == ins) {
                    DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"devicemanager.templatefile.not.found"));
                    boolean bl2 = false;
                    return bl2;
                }
                if (!FileUtils.isDiskSpaceFull((String)filePath, (InputStream)ins)) {
                    DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"devicemanager.save.error"));
                    boolean bl3 = false;
                    StreamUtils.closeStream(outs, ins);
                    return bl3;
                }
                outs = new FileOutputStream(new File(filePath));
                byte[] b = new byte[1024];
                int size = 0;
                while ((size = ins.read(b, 0, 1024)) != -1) {
                    ((OutputStream)outs).write(b, 0, size);
                }
                bl = true;
                StreamUtils.closeStream(outs, ins);
            }
            catch (RuntimeException e) {
                LOGGER.error("Save template file runtime exception.");
                break block12;
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(ExcelListener.class).error("Save template file error.");
                DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"devicemanager.save.error"));
                break block12;
            }
            finally {
                StreamUtils.closeStream(outs, ins);
            }
            return bl;
        }
        return false;
    }
}

