/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.listener;

import com.huawei.ism.tool.devicecenter.listener.LineLabelStyleListener;
import com.huawei.ism.tool.devicecenter.ui.HmmSwLabel;
import com.huawei.ism.tool.devicecenter.ui.SerDeviTitleLabel;
import com.huawei.ism.tool.devicecenter.ui.SwitchLabelBorder;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HmmAddDialogSwitchListener
extends LineLabelStyleListener {
    private static final Color COLOR_BLUE = new Color(73, 157, 242);
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private List<HmmSwLabel> labelList;
    private String swFlag = "";

    public HmmAddDialogSwitchListener(JPanel cardContent, CardLayout panelLayout, List<HmmSwLabel> labels, String sw) {
        this.cardPanel = cardContent;
        this.cardLayout = panelLayout;
        this.labelList = labels;
        this.swFlag = sw;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        SerDeviTitleLabel clickLabel = (SerDeviTitleLabel)mouseEvent.getSource();
        if (!clickLabel.isEnabled()) {
            return;
        }
        clickLabel.setSelect(true);
        for (HmmSwLabel label : this.labelList) {
            SerDeviTitleLabel serDevTitleLabel = label.getSwLabel();
            if (serDevTitleLabel != clickLabel) {
                serDevTitleLabel.setCursor(new Cursor(0));
                serDevTitleLabel.setBorder(BorderFactory.createEmptyBorder());
                serDevTitleLabel.setSelect(false);
                label.getFlagLine().setVisible(true);
                continue;
            }
            clickLabel.setForeground(COLOR_BLUE);
            clickLabel.setCursor(new Cursor(12));
            label.getFlagLine().setVisible(false);
            clickLabel.setBorder(new SwitchLabelBorder(COLOR_BLUE, 3, true));
            this.cardLayout.show(this.cardPanel, this.swFlag);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        JLabel label = (JLabel)event.getSource();
        label.setForeground(COLOR_BLUE);
        label.setCursor(new Cursor(12));
    }

    @Override
    public void mouseExited(MouseEvent event) {
        SerDeviTitleLabel clickLabel = (SerDeviTitleLabel)event.getSource();
        clickLabel.setForeground(new Color(51, 51, 51));
        for (HmmSwLabel label : this.labelList) {
            SerDeviTitleLabel serLabel = label.getSwLabel();
            if (serLabel.isSelect()) {
                label.getFlagLine().setVisible(false);
                continue;
            }
            label.getFlagLine().setVisible(true);
        }
        if (!clickLabel.isSelect()) {
            clickLabel.setCursor(new Cursor(0));
            clickLabel.setBorder(BorderFactory.createEmptyBorder());
        }
    }
}

