/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.listener;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.thread.ImportThread;
import com.huawei.ism.tool.devicecenter.ui.dialog.BatchImportInfoDialog;
import com.huawei.ism.tool.devicecenter.utils.ImportDeviceInfoUtil;
import com.huawei.ism.tool.devicecenter.utils.LogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Objects;

public class ImportListener
implements ActionListener {
    private List<IImportListener> importListener;

    private void addBatchImportDialog(BatchImportInfoDialog dialog) {
        boolean hasBatchImportDialog = false;
        if (null == this.importListener) {
            return;
        }
        for (IImportListener listener : this.importListener) {
            if (!(listener instanceof BatchImportInfoDialog)) continue;
            hasBatchImportDialog = true;
            break;
        }
        if (hasBatchImportDialog) {
            for (IImportListener listener : this.importListener) {
                if (!(listener instanceof BatchImportInfoDialog)) continue;
                this.importListener.remove(listener);
                break;
            }
            this.importListener.add(dialog);
        } else {
            this.importListener.add(dialog);
        }
        DeviceCenterContext.getInstance().setBatchisCancel(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String title = ResourceUtil.getString((String)"devicecenter.batchimport.btn.batchimport");
        BatchImportInfoDialog importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), title);
        this.addBatchImportDialog(importDialog);
        File importFile = ImportDeviceInfoUtil.chooseFile(title);
        List<AbstractDevice> importDeviceList = ImportDeviceInfoUtil.getImportDeviceList(importFile);
        if (importDeviceList.isEmpty()) {
            String operaObjectName = Objects.nonNull(importFile) ? importFile.getName() : "--";
            LogUtils.addImportLog("operalog.name.importdevice", operaObjectName, false, "");
            return;
        }
        AsyncExcutor.submit((Runnable)new ImportThread(importDeviceList, this.importListener));
    }

    public ImportListener(List<IImportListener> importListener) {
        this.importListener = importListener;
    }
}

