/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.service;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.context.SshForwardContext;
import com.huawei.ism.tool.devicecenter.driver.model.CommonStatus;
import com.huawei.ism.tool.devicecenter.driver.model.DeviceProgress;
import com.huawei.ism.tool.devicecenter.driver.model.DeviceResult;
import com.huawei.ism.tool.devicecenter.driver.model.DriverResult;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.driver.model.TaskType;
import com.huawei.ism.tool.devicecenter.driver.model.TotalDriverResult;
import com.huawei.ism.tool.devicecenter.driver.utils.DeviceAliasMapper;
import com.huawei.ism.tool.devicecenter.driver.utils.DriverContext;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.Account;
import com.huawei.ism.tool.devicecenter.entity.CMCDevice;
import com.huawei.ism.tool.devicecenter.entity.ComputeNodePlate;
import com.huawei.ism.tool.devicecenter.entity.HMMDevice;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.entity.IBMCDevice;
import com.huawei.ism.tool.devicecenter.entity.IESDevice;
import com.huawei.ism.tool.devicecenter.entity.OsDevice;
import com.huawei.ism.tool.devicecenter.entity.ServerComputeNode;
import com.huawei.ism.tool.devicecenter.entity.ServerExchangeModule;
import com.huawei.ism.tool.devicecenter.entity.SwitchDevice;
import com.huawei.ism.tool.devicecenter.entity.TceDevice;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.thread.ImportBySshForwardThread;
import com.huawei.ism.tool.devicecenter.ui.dialog.BatchImportInfoDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.BatchPortsCheckDialog;
import com.huawei.ism.tool.devicecenter.utils.LayUtil;
import com.huawei.ism.tool.devicecenter.utils.LogUtils;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.devicecenter.utils.UiItemCheckServiceEnum;
import com.huawei.ism.tool.devicecenter.worktaker.IDeviceDriverWorktaker;
import com.huawei.ism.tool.devicecenter.worktaker.impl.DeviceDriverWorktakerImpl;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.connection.ssh.SshKnownHostsManager;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceControl {
    private static final Logger log = LoggerFactory.getLogger(DeviceControl.class);
    private static final String NORMAL = "normal";
    private static final String TIME_OUT = "timeout";
    private static final Long FIVE_MIN = 300000L;
    private static final DeviceControl INSTANCE = new DeviceControl();
    private static final String STR_SEPARATE = ":";
    private static final String STR_COMMA_SEPARATE = ".";
    private static final String STR_ZERO = "0";
    private IDeviceDriverWorktaker driverWortaker = null;
    private Map<ITDeviceType, String> deviceStatusMap = new ConcurrentHashMap<ITDeviceType, String>();
    private volatile Date startTime;
    private volatile boolean serverFinish = true;
    private Map<Integer, String> fileMap = new ConcurrentHashMap<Integer, String>();
    private volatile String filePath = "";
    private volatile Integer count = 0;
    private volatile boolean isSupportSshForward = false;

    private DeviceControl() {
        this.driverWortaker = new DeviceDriverWorktakerImpl();
    }

    private IImportListener getBatchDialog(List<IImportListener> list) {
        for (IImportListener dialog : list) {
            if (!(dialog instanceof BatchImportInfoDialog)) continue;
            return dialog;
        }
        log.info("this list has no BatchImportInfoDialog");
        return null;
    }

    public TaskResult importFusionStorageDevice(List<AbstractDevice> abstratDeviceList, List<IImportListener> list) {
        log.info("start import fusionStorage Server device");
        return this.getImportDeviceTaskResult(abstratDeviceList, list);
    }

    public TaskResult importDevices(List<AbstractDevice> abstratDeviceList, List<IImportListener> list) {
        log.info("taskKill process");
        SmartkitUtils.killDriverProcess();
        log.info("start import server device");
        UiItemCheckServiceEnum checkResult = SmartkitUtils.checkUserNameAndPwdByBlackList(abstratDeviceList);
        if (UiItemCheckServiceEnum.FAILED == checkResult && !this.shouldContinueFindDevBasedOnUserChoose(checkResult)) {
            return new TaskResult(TaskResult.Result.FAILED);
        }
        return this.getImportDeviceTaskResult(abstratDeviceList, list);
    }

    public TaskResult checkDevicePorts(List<AbstractDevice> abstratDeviceList, BatchPortsCheckDialog batchPortsCheckDialog) {
        SmartkitUtils.killDriverProcess();
        DeviceCenterContext.getInstance().setBatchisCancel(false);
        if (CollectionUtils.isEmpty(abstratDeviceList)) {
            log.info("import device excel file is null.");
            return new TaskResult(TaskResult.Result.FAILED);
        }
        if (!Objects.nonNull(batchPortsCheckDialog)) {
            log.info("batch port check dialog is null");
            return new TaskResult(TaskResult.Result.FAILED);
        }
        SwingUtilities.invokeLater(new CheckPortsDialogShowThread(batchPortsCheckDialog));
        ArrayList<String> ipList = new ArrayList<String>();
        for (AbstractDevice abDev : abstratDeviceList) {
            HwServerDevice hwDev = (HwServerDevice)abDev;
            if (LayUtil.checkIpV4HasSpecial(hwDev.getStartIPAddress())) {
                DeviceControl.parseHwDevToSingleIps(hwDev, ipList);
                continue;
            }
            DeviceControl.parseHwDevToSingleIpv6Ips(hwDev, ipList);
        }
        batchPortsCheckDialog.startCheckImportDevice(ipList);
        String taskId = this.driverWortaker.loginAndQuery(abstratDeviceList, TaskType.DEV_CHECK);
        this.startTime = new Date();
        this.serverFinish = false;
        AsyncExcutor.submit((Runnable)new RefreshUIThead(batchPortsCheckDialog, this.createDeviceStatus(abstratDeviceList), taskId, abstratDeviceList, ipList));
        while (!this.serverFinish) {
            this.waitForSometime();
        }
        return new TaskResult(TaskResult.Result.SUCCESS);
    }

    private TaskResult getImportDeviceTaskResult(List<AbstractDevice> abstratDeviceList, List<IImportListener> list) {
        String taskID;
        if (null == abstratDeviceList) {
            log.info("import Devices' excelFile is null.");
            return new TaskResult(TaskResult.Result.FAILED);
        }
        IImportListener dialog = this.getBatchDialog(list);
        if (null != dialog) {
            SwingUtilities.invokeLater(new ImportDialogShowThread(dialog));
        } else {
            log.info("batch ImportDialog is null");
        }
        ArrayList<String> ipList = new ArrayList<String>();
        for (AbstractDevice abDev : abstratDeviceList) {
            HwServerDevice hwDev = (HwServerDevice)abDev;
            if (LayUtil.checkIpV4HasSpecial(hwDev.getStartIPAddress())) {
                DeviceControl.parseHwDevToSingleIps(hwDev, ipList);
                continue;
            }
            DeviceControl.parseHwDevToSingleIpv6Ips(hwDev, ipList);
        }
        for (IImportListener listener : list) {
            listener.startCheckImportDevice(ipList);
        }
        if (this.isSupportSshForward) {
            taskID = SshForwardContext.getInstance().generateTaskID();
            CompletableFuture.runAsync(new ImportBySshForwardThread(abstratDeviceList, taskID));
        } else {
            taskID = this.driverWortaker.loginAndQuery(abstratDeviceList, TaskType.DEV_ADD);
        }
        this.startTime = new Date();
        this.waitForSometime();
        this.serverFinish = false;
        AsyncExcutor.submit((Runnable)new RefreshUIThead(list, this.createDeviceStatus(abstratDeviceList), taskID, abstratDeviceList, ipList));
        while (!this.serverFinish) {
            this.waitForSometime();
        }
        return new TaskResult(TaskResult.Result.SUCCESS);
    }

    private boolean shouldContinueFindDevBasedOnUserChoose(UiItemCheckServiceEnum checkResult) {
        DialogUtils.showErrorDialog((Window)DeviceCenterContext.getInstance().getParent(), (String)checkResult.getTip());
        return false;
    }

    private static void parseHwDevToSingleIpv6Ips(HwServerDevice hwServerDev, List<String> ips) {
        String startIp = hwServerDev.getStartIPAddress();
        String endIp = hwServerDev.getEndIPAddress();
        if (startIp.trim().equalsIgnoreCase(endIp.trim())) {
            String commonStr = startIp.substring(0, startIp.lastIndexOf(STR_SEPARATE) + 1);
            String start = startIp.substring(startIp.lastIndexOf(STR_SEPARATE) + 1).toLowerCase(Locale.ENGLISH);
            String ip = commonStr + start;
            ips.add(ip);
        } else {
            try {
                String commonStr = startIp.substring(0, startIp.lastIndexOf(STR_SEPARATE) + 1);
                String start = startIp.substring(startIp.lastIndexOf(STR_SEPARATE) + 1);
                String end = endIp.substring(endIp.lastIndexOf(STR_SEPARATE) + 1);
                if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)start)) {
                    start = STR_ZERO;
                }
                int startInt = Integer.parseInt(start, 16);
                int endInt = Integer.parseInt(end, 16);
                for (int i = startInt; i <= endInt; ++i) {
                    String ip = commonStr + Integer.toHexString(i);
                    ips.add(ip);
                }
            }
            catch (NumberFormatException e) {
                log.error("string parse to integer error");
            }
        }
    }

    private static void parseHwDevToSingleIps(HwServerDevice hwServerDev, List<String> ips) {
        String startIp = hwServerDev.getStartIPAddress();
        String endIp = hwServerDev.getEndIPAddress();
        boolean sameIp = startIp.trim().equalsIgnoreCase(endIp.trim());
        if (sameIp && !hwServerDev.isPortProxy()) {
            ips.add(startIp);
        } else if (sameIp && hwServerDev.isPortProxy()) {
            ips.add(startIp + STR_SEPARATE + hwServerDev.getRedFishPort());
        } else {
            int i;
            String[] startIpArr = startIp.split("\\.");
            String[] endIpArr = endIp.split("\\.");
            if (startIpArr.length != 4 || endIpArr.length != 4) {
                return;
            }
            int start3Ip = Integer.valueOf(startIpArr[2]);
            int start4Ip = Integer.valueOf(startIpArr[3]);
            int end3Ip = Integer.valueOf(endIpArr[2]);
            int end4Ip = Integer.valueOf(endIpArr[3]);
            if (start3Ip == end3Ip) {
                for (int i2 = start4Ip; i2 <= end4Ip; ++i2) {
                    ips.add(DeviceControl.buildIp(startIpArr[0], startIpArr[1], startIpArr[2], String.valueOf(i2)));
                }
                return;
            }
            int ip3Min = start3Ip < end3Ip ? start3Ip : end3Ip;
            for (int i3 = start4Ip; i3 < 256; ++i3) {
                ips.add(DeviceControl.buildIp(startIpArr[0], startIpArr[1], String.valueOf(ip3Min), String.valueOf(i3)));
            }
            int ip3Max = start3Ip > end3Ip ? start3Ip : end3Ip;
            for (i = ip3Min + 1; i < ip3Max; ++i) {
                for (int j = 0; j < 256; ++j) {
                    ips.add(DeviceControl.buildIp(startIpArr[0], startIpArr[1], String.valueOf(i), String.valueOf(j)));
                }
            }
            for (i = 0; i <= end4Ip; ++i) {
                ips.add(DeviceControl.buildIp(startIpArr[0], startIpArr[1], String.valueOf(ip3Max), String.valueOf(i)));
            }
        }
    }

    private static String buildIp(String ... ips) {
        return String.join((CharSequence)STR_COMMA_SEPARATE, ips);
    }

    private boolean checkTimeout(Map<ITDeviceType, KeyValue<Integer, Integer>> deviceTypeMap) {
        for (ITDeviceType idt : deviceTypeMap.keySet()) {
            if (!this.deviceStatusMap.get((Object)idt).equals(TIME_OUT)) continue;
            return true;
        }
        return false;
    }

    private void refreshDeviceStatus(Map<ITDeviceType, DriverResult> rMap, Map<ITDeviceType, KeyValue<Integer, Integer>> deviceTypeMap) {
        for (ITDeviceType item : deviceTypeMap.keySet()) {
            DriverResult result = rMap.get((Object)item);
            if (null == result) {
                this.setStatusByStart(item);
                continue;
            }
            this.refreshDevStatus(rMap, item);
        }
    }

    private void refreshDevStatus(Map<ITDeviceType, DriverResult> resultMap, ITDeviceType idt) {
        Date updateTime = resultMap.get((Object)idt).getUpdateTime();
        if (null == updateTime) {
            this.setStatusByStart(idt);
        } else {
            this.setStatusByNow(resultMap, idt, updateTime);
        }
    }

    private void setStatusByNow(Map<ITDeviceType, DriverResult> result, ITDeviceType id, Date update) {
        Date now = new Date();
        long time = now.getTime() - update.getTime();
        if (time > result.get((Object)id).getOverTime() * 1000L) {
            this.deviceStatusMap.put(id, TIME_OUT);
            if (log.isInfoEnabled()) {
                log.info(id.getName() + " is time out.");
            }
        }
        this.startTime = update;
    }

    private void setStatusByStart(ITDeviceType id) {
        Date now = new Date();
        long time = now.getTime() - this.startTime.getTime();
        if (time > FIVE_MIN) {
            this.deviceStatusMap.put(id, TIME_OUT);
            if (log.isInfoEnabled()) {
                log.info(id.getName() + " is time out.");
            }
        }
    }

    private boolean checkFinish(Map<ITDeviceType, CommonStatus> totalStatusMap, Map<ITDeviceType, KeyValue<Integer, Integer>> deviceTypeMap) {
        for (ITDeviceType idt : deviceTypeMap.keySet()) {
            if (CommonStatus.FINISHED.equals((Object)totalStatusMap.get((Object)idt))) continue;
            return false;
        }
        return true;
    }

    private Map<ITDeviceType, KeyValue<Integer, Integer>> createDeviceStatus(List<AbstractDevice> queryDevList) {
        this.deviceStatusMap.clear();
        HashMap<ITDeviceType, KeyValue<Integer, Integer>> statusMap = new HashMap<ITDeviceType, KeyValue<Integer, Integer>>();
        for (AbstractDevice ad : queryDevList) {
            if (!(ad instanceof HwServerDevice)) continue;
            this.updateDeviceTypeStatus(statusMap, ITDeviceType.SERVER_IBMC);
            this.deviceStatusMap.put(ITDeviceType.SERVER_IBMC, NORMAL);
            this.serverFinish = false;
        }
        return statusMap;
    }

    private void updateDeviceTypeStatus(Map<ITDeviceType, KeyValue<Integer, Integer>> statusMap, ITDeviceType key) {
        KeyValue<Integer, Integer> keyValue = statusMap.get((Object)key);
        if (null == keyValue) {
            KeyValue newValue = new KeyValue((Object)0, (Object)1);
            statusMap.put(key, (KeyValue<Integer, Integer>)newValue);
        } else {
            int value = (Integer)keyValue.getValue();
            keyValue.setValue((Object)(++value));
        }
    }

    private List<AbstractDevice> constructServerDevice(DriverResult driverResult, List<AbstractDevice> abstratDevices) {
        if (null == driverResult) {
            return new ArrayList<AbstractDevice>(0);
        }
        ArrayList<AbstractDevice> serverList = new ArrayList<AbstractDevice>();
        List<DeviceProgress> deviceProgress = driverResult.getDeviceProgressList();
        for (DeviceProgress progress : deviceProgress) {
            if (this.isCMCDevice(progress)) {
                this.constructServerCMCDevice(progress, serverList, abstratDevices);
                continue;
            }
            if (this.isIESDevice(progress)) {
                this.constructServerIESDevice(progress, serverList, abstratDevices);
                continue;
            }
            if (this.isTCEDevice(progress)) {
                ArrayList<AbstractDevice> tempHmmDevices = new ArrayList<AbstractDevice>();
                this.constructE9000Device(progress, tempHmmDevices, abstratDevices);
                serverList.addAll(this.createTceDevice(tempHmmDevices));
                continue;
            }
            if (!progress.getExternalResult().toString().contains("computeNodeList")) {
                this.constructServerCommDevice(progress, serverList, abstratDevices);
                continue;
            }
            this.constructE9000Device(progress, serverList, abstratDevices);
        }
        return serverList;
    }

    private List<AbstractDevice> constructDevice(DriverResult driverResult, Map<String, AbstractDevice> abstractDevices) {
        if (Objects.isNull(driverResult)) {
            return Collections.emptyList();
        }
        ArrayList<AbstractDevice> serverList = new ArrayList<AbstractDevice>();
        List<DeviceProgress> deviceProgress = driverResult.getDeviceProgressList();
        deviceProgress.forEach(progress -> {
            if (DeviceResult.SUCCESS.equals((Object)progress.getResult())) {
                this.addService((DeviceProgress)progress, (List<AbstractDevice>)serverList, abstractDevices);
            } else {
                LogUtils.addImportLog("devicemanager.layout.device.import", progress.getIp(), false, "");
            }
        });
        return serverList;
    }

    private void addService(DeviceProgress devProgress, List<AbstractDevice> servers, Map<String, AbstractDevice> abstractDevices) {
        JSONObject json = devProgress.getExternalResult();
        if (json.getString("deviceType").equalsIgnoreCase("os")) {
            OsDevice osDev = (OsDevice)JSON.parseObject((String)json.toString(), OsDevice.class);
            String osIp = DeviceControl.isExistStaticIp(devProgress) ? devProgress.getStaticIp() : devProgress.getIp();
            AbstractDevice abstractDevice = abstractDevices.get(osIp);
            if (abstractDevice instanceof HwServerDevice) {
                HwServerDevice hwSe = (HwServerDevice)abstractDevice;
                osDev.setUserName(hwSe.getUserName());
                osDev.setIp(osIp);
                osDev.setItDeviceType(ITDeviceType.SERVER_OS);
                osDev.setHwServerDev(hwSe);
                if (!servers.contains(osDev)) {
                    servers.add(osDev);
                }
            }
        }
    }

    private void constructServerIESDevice(DeviceProgress devProgress, List<AbstractDevice> servers, List<AbstractDevice> hwServerXlsDevList) {
        if (DeviceResult.SUCCESS.equals((Object)devProgress.getResult())) {
            JSONObject json = devProgress.getExternalResult();
            IESDevice iesDev = (IESDevice)JSON.parseObject((String)json.toString(), IESDevice.class);
            String ip = DeviceControl.isExistStaticIp(devProgress) ? devProgress.getStaticIp() : devProgress.getIp();
            this.injectPortByIp(ip, hwServerXlsDevList, iesDev);
            iesDev.setIp(ip);
            iesDev.setAccount(new Account(this.getUserNameByHmmIbmcIp(ip, hwServerXlsDevList), ""));
            iesDev.setHwServerDev(this.getHwXlsDevByIp(devProgress.getHttpsPort(), ip, hwServerXlsDevList));
            servers.add(iesDev);
        }
    }

    private void constructServerCMCDevice(DeviceProgress devProgress, List<AbstractDevice> servers, List<AbstractDevice> hwServerXlsDevList) {
        if (DeviceResult.SUCCESS.equals((Object)devProgress.getResult())) {
            JSONObject json = devProgress.getExternalResult();
            CMCDevice cmcDev = (CMCDevice)JSON.parseObject((String)json.toString(), CMCDevice.class);
            String ip = DeviceControl.isExistStaticIp(devProgress) ? devProgress.getStaticIp() : devProgress.getIp();
            this.injectPortByIp(ip, hwServerXlsDevList, cmcDev);
            cmcDev.setIp(ip);
            cmcDev.setAccount(new Account(this.getUserNameByHmmIbmcIp(ip, hwServerXlsDevList), ""));
            cmcDev.setHwServerDev(this.getHwXlsDevByIp(devProgress.getHttpsPort(), ip, hwServerXlsDevList));
            cmcDev.setSerialNumber(this.handleSn(devProgress.getSerialNo()));
            cmcDev.setItDeviceType(ITDeviceType.SERVER_CMC);
            servers.add(cmcDev);
        }
    }

    private boolean isCMCDevice(DeviceProgress pro) {
        JSONObject externalResult = pro.getExternalResult();
        String type = "";
        if (externalResult.has("deviceType")) {
            type = (String)externalResult.get("deviceType");
        }
        return type.equalsIgnoreCase("CMC");
    }

    private boolean isTCEDevice(DeviceProgress devProgress) {
        JSONObject externalResult = devProgress.getExternalResult();
        String type = "";
        if (externalResult.has("deviceType")) {
            type = (String)externalResult.get("deviceType");
        }
        return DeviceAliasMapper.getDeviceIdByAlias("tce").equals(DeviceAliasMapper.getDeviceIdByAlias(type));
    }

    private boolean isIESDevice(DeviceProgress pro) {
        JSONObject externalResult = pro.getExternalResult();
        String type = "";
        if (externalResult.has("deviceType")) {
            type = (String)externalResult.get("deviceType");
        }
        return type.equalsIgnoreCase("ies");
    }

    private String getUserNameByHmmIbmcIp(String ip, List<AbstractDevice> serverList) {
        String userName = "";
        for (AbstractDevice dev : serverList) {
            String end;
            HwServerDevice hwDev = (HwServerDevice)dev;
            String start = hwDev.getStartIPAddress();
            if (this.checkIp(ip, start, end = hwDev.getEndIPAddress())) {
                userName = hwDev.getUserName();
            }
            if (!hwDev.isPortProxy()) continue;
            userName = hwDev.getUserName();
        }
        return userName;
    }

    private HwServerDevice getHwXlsDevByIp(String httpsPort, String ip, List<AbstractDevice> serverList) {
        HwServerDevice hwDevParm = new HwServerDevice();
        for (AbstractDevice dev : serverList) {
            String endIp;
            HwServerDevice hwDev = (HwServerDevice)dev;
            String startIp = hwDev.getStartIPAddress();
            if (startIp.equals(endIp = hwDev.getEndIPAddress()) && hwDev.isPortProxy() && httpsPort != null && httpsPort.equals(hwDev.getRedFishPort())) {
                try {
                    hwDevParm = (HwServerDevice)hwDev.clone();
                }
                catch (CloneNotSupportedException e) {
                    log.error("colne error,");
                }
                return hwDevParm;
            }
            if (!this.checkIp(ip, startIp, endIp)) continue;
            try {
                hwDevParm = (HwServerDevice)hwDev.clone();
            }
            catch (CloneNotSupportedException e) {
                log.error("colne error,");
            }
            return hwDevParm;
        }
        return null;
    }

    private void injectPortByIp(String ip, List<AbstractDevice> hwServerListXls, AbstractDevice device) {
        for (AbstractDevice dev : hwServerListXls) {
            String end;
            HwServerDevice hwSerDev = (HwServerDevice)dev;
            String start = hwSerDev.getStartIPAddress();
            if (!this.checkIp(ip, start, end = hwSerDev.getEndIPAddress())) continue;
            this.injectPort(dev, device);
            break;
        }
    }

    private boolean checkIp(String ip, String start, String end) {
        return ip.contains(STR_SEPARATE) && start.contains(STR_SEPARATE) && LayUtil.isIpv6StartIpLessEnd(start, ip) && LayUtil.isIpv6StartIpLessEnd(ip, end) || ip.contains(STR_COMMA_SEPARATE) && start.contains(STR_COMMA_SEPARATE) && LayUtil.isStartIpLessEnd(start, ip) && LayUtil.isStartIpLessEnd(ip, end);
    }

    private void injectPort(AbstractDevice dev, AbstractDevice device) {
        HwServerDevice xlsDev = (HwServerDevice)dev;
        if (null != xlsDev) {
            if (device instanceof IBMCDevice) {
                ((IBMCDevice)device).setSshPort(String.valueOf(xlsDev.getSshPort()));
                ((IBMCDevice)device).setSnmpPort(String.valueOf(xlsDev.getSnmpPort()));
                ((IBMCDevice)device).setIpmiPort(String.valueOf(xlsDev.getIpmiPort()));
                ((IBMCDevice)device).setVmmPort(String.valueOf(xlsDev.getVmmPort()));
                ((IBMCDevice)device).setManageIP(String.valueOf(xlsDev.getManageIp()));
            } else if (device instanceof HMMDevice) {
                ((HMMDevice)device).setSshPort(String.valueOf(xlsDev.getSshPort()));
                ((HMMDevice)device).setSnmpPort(String.valueOf(xlsDev.getSnmpPort()));
                ((HMMDevice)device).setVmmPort(String.valueOf(xlsDev.getVmmPort()));
            }
        }
    }

    private List<AbstractDevice> createTceDevice(List<AbstractDevice> serverList) {
        ArrayList<AbstractDevice> tceDevices = new ArrayList<AbstractDevice>();
        for (AbstractDevice device : serverList) {
            if (!(device instanceof HMMDevice)) continue;
            TceDevice tceDev = new TceDevice((HMMDevice)device);
            tceDev.setItDeviceType(ITDeviceType.TCE);
            tceDev.setTypeJsonKey(ITDeviceType.TCE.getDeviceTypeJsonKey());
            tceDev.setIp(device.getIp());
            tceDevices.add(tceDev);
        }
        return tceDevices;
    }

    private void constructE9000Device(DeviceProgress deviceProgress, List<AbstractDevice> serverList, List<AbstractDevice> hwServerDevs) {
        String hmmIp = "";
        if (DeviceResult.SUCCESS.equals((Object)deviceProgress.getResult())) {
            JSONObject json = deviceProgress.getExternalResult();
            if (log.isInfoEnabled()) {
                log.info("response json is " + json.toString());
            }
            String mainErrMsg = deviceProgress.getErrMsg();
            HMMDevice hmmDevice = (HMMDevice)JSON.parseObject((String)json.toString(), HMMDevice.class);
            this.constructResultDetail(hmmDevice, deviceProgress);
            hmmIp = DeviceControl.isExistStaticIp(deviceProgress) ? deviceProgress.getStaticIp() : deviceProgress.getIp();
            this.injectPortByIp(hmmIp, hwServerDevs, hmmDevice);
            hmmDevice.setHwServerDev(this.getHwXlsDevByIp(deviceProgress.getHttpsPort(), hmmIp, hwServerDevs));
            hmmDevice.setAccount(new Account(this.getUserNameByHmmIbmcIp(hmmIp, hwServerDevs), ""));
            hmmDevice.setIp(hmmIp);
            hmmDevice.setDeviceSerialNumber(this.handleSn(deviceProgress.getSerialNo()));
            this.constructSwitchPlane(hmmDevice, json, mainErrMsg);
            this.constructComputeNode(hmmDevice, json, mainErrMsg);
            hmmDevice.setItDeviceType(ITDeviceType.SERVER_HMM);
            serverList.add(hmmDevice);
            LogUtils.addImportLog("devicemanager.layout.device.import", deviceProgress.getIp(), true, "");
        } else if (DeviceResult.PART_SUCCESS.equals((Object)deviceProgress.getResult())) {
            JSONObject json = deviceProgress.getExternalResult();
            if (log.isInfoEnabled()) {
                log.info("response json is " + json.toString());
            }
            String mainErrMsg = deviceProgress.getErrMsg();
            HMMDevice hmmPartSucDev = (HMMDevice)JSON.parseObject((String)json.toString(), HMMDevice.class);
            hmmIp = deviceProgress.getIp();
            this.injectPortByIp(hmmIp, hwServerDevs, hmmPartSucDev);
            hmmPartSucDev.setHwServerDev(this.getHwXlsDevByIp(deviceProgress.getHttpsPort(), hmmIp, hwServerDevs));
            hmmPartSucDev.setAccount(new Account(this.getUserNameByHmmIbmcIp(hmmIp, hwServerDevs), ""));
            hmmPartSucDev.setIp(deviceProgress.getIp());
            hmmPartSucDev.setDeviceSerialNumber(this.handleSn(deviceProgress.getSerialNo()));
            this.constructComputeNode(hmmPartSucDev, json, mainErrMsg);
            this.constructSwitchPlane(hmmPartSucDev, json, mainErrMsg);
            hmmPartSucDev.setItDeviceType(ITDeviceType.SERVER_HMM);
            serverList.add(hmmPartSucDev);
            LogUtils.addImportLog("devicemanager.layout.device.import", deviceProgress.getIp(), true, "");
        } else {
            LogUtils.addImportLog("devicemanager.layout.device.import", deviceProgress.getIp(), false, "");
        }
        this.injectDeviceComputeNodePortsByInpute(serverList, hwServerDevs);
    }

    private void injectDeviceComputeNodePortsByInpute(List<AbstractDevice> serverList, List<AbstractDevice> inputInfos) {
        for (AbstractDevice device : serverList) {
            if (!(device instanceof HMMDevice)) continue;
            String ip = device.getIp();
            Optional<AbstractDevice> inputeInfoOptional = this.findInputeInfoDevByIp(inputInfos, ip);
            List<ServerComputeNode> computeNodes = ((HMMDevice)device).getServerComputeNodes();
            for (ServerComputeNode computeNode : computeNodes) {
                String slotId = computeNode.getSlot();
                if (!inputeInfoOptional.isPresent()) continue;
                this.setComputeNodePorts(inputeInfoOptional.get(), computeNode, slotId);
            }
        }
    }

    private void setComputeNodePorts(AbstractDevice inputInfo, ServerComputeNode computeNode, String slotId) {
        Optional<ComputeNodePlate> computeNodeOfUserInput = this.findComputeNodeBySlotId(inputInfo, slotId);
        if (computeNodeOfUserInput.isPresent()) {
            computeNode.setSshPort(computeNodeOfUserInput.get().getSlotSSHPort());
            computeNode.setSnmpPort(computeNodeOfUserInput.get().getSlotSNMPPort());
            computeNode.setIpmiPort(computeNodeOfUserInput.get().getSlotIPMIPort());
        }
    }

    private Optional<ComputeNodePlate> findComputeNodeBySlotId(AbstractDevice inputInfo, String slotId) {
        if (inputInfo instanceof HwServerDevice) {
            HwServerDevice serverDevice = (HwServerDevice)inputInfo;
            if (serverDevice.isApplyToOtherNodes() && serverDevice.isApplyToOtherNodes() && !VerifyUtil.isEmpty(serverDevice.getComputeNodePlateList())) {
                return Optional.of(serverDevice.getComputeNodePlateList().get(0));
            }
            List<ComputeNodePlate> inputComputeNodes = serverDevice.getComputeNodePlateList();
            for (ComputeNodePlate computeNode : inputComputeNodes) {
                if (!computeNode.getSlotId().equals(slotId)) continue;
                return Optional.of(computeNode);
            }
        }
        return Optional.empty();
    }

    private Optional<AbstractDevice> findInputeInfoDevByIp(List<AbstractDevice> inputInfos, String ip) {
        return inputInfos.stream().filter(dev -> this.isDevIpWithinStartAndEndIpOfInput((AbstractDevice)dev, ip)).findAny();
    }

    private boolean isDevIpWithinStartAndEndIpOfInput(AbstractDevice input, String ip) {
        if (!(input instanceof HwServerDevice)) {
            return false;
        }
        HwServerDevice inputInfo = (HwServerDevice)input;
        String start = inputInfo.getStartIPAddress();
        String end = inputInfo.getEndIPAddress();
        return ip.contains(STR_SEPARATE) && start.contains(STR_SEPARATE) ? LayUtil.isIpv6StartIpLessEnd(start, ip) && LayUtil.isIpv6StartIpLessEnd(ip, end) : ip.contains(STR_COMMA_SEPARATE) && start.contains(STR_COMMA_SEPARATE) && LayUtil.isStartIpLessEnd(start, ip) && LayUtil.isStartIpLessEnd(ip, end);
    }

    private void constructResultDetail(HMMDevice hmmDev, DeviceProgress deviceProgress) {
        if (deviceProgress.getExternalResult().has("resultDetail")) {
            JSONObject resultDetail = (JSONObject)deviceProgress.getExternalResult().get("resultDetail");
            hmmDev.setResultDetail(resultDetail);
        }
    }

    private void constructSwitchPlane(HMMDevice hmmDevice, JSONObject json, String mainErrMsg) {
        try {
            JSONArray switchPlaneJsonArr = json.getJSONArray("switchPlaneList");
            for (int index = 0; index < switchPlaneJsonArr.length(); ++index) {
                this.constructSwitchPlane2(hmmDevice, switchPlaneJsonArr, index);
            }
        }
        catch (JSONException e) {
            log.error("construct switch Plane failed.");
        }
    }

    private void constructSwitchPlane2(HMMDevice hmmDevice, JSONArray switchPlaneJsonArr, int index) {
        try {
            ArrayList<ServerExchangeModule> switchPlaneList = new ArrayList<ServerExchangeModule>();
            for (int i = 0; i < switchPlaneJsonArr.length(); ++i) {
                JSONObject switchPlaneJson = switchPlaneJsonArr.getJSONObject(i);
                ServerExchangeModule tmpPlane = (ServerExchangeModule)JSON.parseObject((String)switchPlaneJson.toString(), ServerExchangeModule.class);
                switchPlaneList.add(tmpPlane);
            }
            hmmDevice.setServerExchangeModules(switchPlaneList);
        }
        catch (JSONException e) {
            log.error("construct switch Plane failed.");
        }
    }

    private void constructComputeNode(HMMDevice e9000device, JSONObject json, String mainErrMsg) {
        try {
            JSONArray computeNodeJsonArr = json.getJSONArray("computeNodeList");
            this.constuctComputeNode2(e9000device, computeNodeJsonArr);
        }
        catch (JSONException e) {
            log.error("construct compute node failed.");
        }
    }

    private void constuctComputeNode2(HMMDevice hmmDevice, JSONArray computeNodeJsonArr) {
        try {
            ArrayList<ServerComputeNode> computeNodeList = new ArrayList<ServerComputeNode>();
            for (int i = 0; i < computeNodeJsonArr.length(); ++i) {
                JSONObject computeJson = computeNodeJsonArr.getJSONObject(i);
                if (!"success".equals((String)computeJson.get("result"))) continue;
                ServerComputeNode computeNode = (ServerComputeNode)JSON.parseObject((String)computeJson.toString(), ServerComputeNode.class);
                computeNodeList.add(computeNode);
            }
            hmmDevice.setServerComputeNodes(computeNodeList);
        }
        catch (JSONException e) {
            log.error("get compute result failed.", (Throwable)e);
        }
    }

    private void constructServerCommDevice(DeviceProgress deviceProgress, List<AbstractDevice> serverList, List<AbstractDevice> hwServerXlsDevs) {
        if (DeviceResult.SUCCESS.equals((Object)deviceProgress.getResult())) {
            this.constructServerCommDeviceService(deviceProgress, serverList, hwServerXlsDevs);
        } else {
            LogUtils.addImportLog("devicemanager.layout.device.import", deviceProgress.getIp(), false, "");
        }
    }

    private void constructServerCommDeviceService(DeviceProgress devProgress, List<AbstractDevice> servers, List<AbstractDevice> hwServerXlsDevList) {
        JSONObject json = devProgress.getExternalResult();
        if (json.getString("deviceType").equalsIgnoreCase("switch")) {
            SwitchDevice switchDev = (SwitchDevice)JSON.parseObject((String)json.toString(), SwitchDevice.class);
            String switchIp = DeviceControl.isExistStaticIp(devProgress) ? devProgress.getStaticIp() : devProgress.getIp();
            switchDev.setIp(switchIp);
            switchDev.setUserName(this.getUserNameByHmmIbmcIp(switchIp, hwServerXlsDevList));
            switchDev.setItDeviceType(ITDeviceType.SWITCH);
            switchDev.setHwServerDev(this.getHwXlsDevByIp(devProgress.getHttpsPort(), switchIp, hwServerXlsDevList));
            servers.add(switchDev);
            return;
        }
        if (json.getString("deviceType").equalsIgnoreCase("os")) {
            OsDevice osDev = (OsDevice)JSON.parseObject((String)json.toString(), OsDevice.class);
            String osIp = DeviceControl.isExistStaticIp(devProgress) ? devProgress.getStaticIp() : devProgress.getIp();
            osDev.setUserName(this.getUserNameByHmmIbmcIp(osIp, hwServerXlsDevList));
            osDev.setIp(osIp);
            osDev.setItDeviceType(ITDeviceType.SERVER_OS);
            osDev.setHwServerDev(this.getHwXlsDevByIp(devProgress.getHttpsPort(), osIp, hwServerXlsDevList));
            osDev.setSn(this.handleSn(devProgress.getSerialNo()));
            servers.add(osDev);
        } else {
            IBMCDevice ibmcDevice = (IBMCDevice)JSON.parseObject((String)json.toString(), IBMCDevice.class);
            String ibmcIp = DeviceControl.isExistStaticIp(devProgress) ? devProgress.getStaticIp() : devProgress.getIp();
            this.injectPortByIp(ibmcIp, hwServerXlsDevList, ibmcDevice);
            ibmcDevice.setIp(ibmcIp);
            ibmcDevice.setAccount(new Account(this.getUserNameByHmmIbmcIp(ibmcIp, hwServerXlsDevList), ""));
            ibmcDevice.setHwServerDev(this.getHwXlsDevByIp(devProgress.getHttpsPort(), ibmcIp, hwServerXlsDevList));
            ibmcDevice.setDeviceSerialNumber(this.handleSn(devProgress.getSerialNo()));
            ibmcDevice.setItDeviceType(ITDeviceType.SERVER_IBMC);
            servers.add(ibmcDevice);
            LogUtils.addImportLog("devicemanager.layout.device.import", devProgress.getIp(), true, "");
        }
    }

    private static boolean isExistStaticIp(DeviceProgress progress) {
        return progress.getStaticIp() != null && !"".equals(progress.getStaticIp());
    }

    private String handleSn(String snParam) {
        if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)snParam)) {
            return "";
        }
        return snParam;
    }

    public static DeviceControl getInstance() {
        return INSTANCE;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    private void waitForSometime() {
        try {
            TimeUnit.MILLISECONDS.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.error("sleep failed");
        }
    }

    public void refreshFile() {
        if (this.fileMap.size() == 5) {
            int i;
            this.deletefile(this.fileMap.get(1));
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            for (i = 1; i < 5; ++i) {
                map.put(i, this.fileMap.get(i + 1));
            }
            this.fileMap.clear();
            for (i = 1; i < 5; ++i) {
                this.fileMap.put(i, (String)map.get(i));
            }
            this.fileMap.put(5, this.filePath);
        } else {
            this.fileMap.put(this.fileMap.size() + 1, this.filePath);
        }
        this.filePath = "";
    }

    public void initDriverFile() {
        if (this.count > 0) {
            return;
        }
        Integer n = this.count;
        Integer n2 = this.count = Integer.valueOf(this.count + 1);
        String driverPath = DriverContext.WORK_ROOTPATH;
        File driverFile = new File(driverPath);
        if (!driverFile.exists()) {
            return;
        }
        File[] fileList = driverFile.listFiles();
        ArrayList<File> fileArr = new ArrayList<File>();
        if (fileList == null) {
            return;
        }
        Collections.addAll(fileArr, fileList);
        DeviceControl deviceControl = DeviceControl.getInstance();
        deviceControl.getClass();
        fileArr.sort(deviceControl.new CompareByDate());
        for (File file : fileArr) {
            String path = driverPath + File.separator + file.getName();
            this.addFile(path);
        }
    }

    private void addFile(String pathStr) {
        if (this.fileMap.size() == 5) {
            int i;
            this.deletefile(this.fileMap.get(1));
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            for (i = 1; i < 5; ++i) {
                map.put(i, this.fileMap.get(i + 1));
            }
            this.fileMap.clear();
            for (i = 1; i < 5; ++i) {
                this.fileMap.put(i, (String)map.get(i));
            }
            this.fileMap.put(5, pathStr);
        } else {
            this.fileMap.put(this.fileMap.size() + 1, pathStr);
        }
    }

    private boolean deletefile(String delpath) {
        boolean deletionResult = true;
        try {
            File file = new File(delpath);
            if (!file.isDirectory()) {
                deletionResult = file.delete();
            } else if (file.isDirectory()) {
                deletionResult = this.deleteInnerDirectory(delpath, file);
            }
        }
        catch (Exception e) {
            log.error("delete file failed " + delpath);
            return false;
        }
        return deletionResult;
    }

    private boolean deleteInnerDirectory(String delpath, File file) {
        Object[] filelist = file.list();
        if (VerifyUtil.isEmpty((Object[])filelist)) {
            return true;
        }
        for (Object listedFileName : filelist) {
            File delfile = new File(delpath + File.separator + (String)listedFileName);
            if (!delfile.isDirectory()) {
                delfile.delete();
                continue;
            }
            if (!delfile.isDirectory()) continue;
            this.deletefile(delpath + File.separator + (String)listedFileName);
        }
        boolean deletionResult = file.delete();
        return deletionResult;
    }

    public void setSupportSshForward(boolean isSupportSshForward) {
        this.isSupportSshForward = isSupportSshForward;
    }

    private final class CompareByDate
    implements Comparator<File> {
        private CompareByDate() {
        }

        @Override
        public int compare(File o1, File o2) {
            if (o1.lastModified() > o2.lastModified()) {
                return 1;
            }
            if (o1.lastModified() == o2.lastModified()) {
                return 0;
            }
            return -1;
        }
    }

    private class RefreshUIThead
    implements Runnable {
        private Map<ITDeviceType, KeyValue<Integer, Integer>> devTypeMap;
        private String threadId;
        private List<AbstractDevice> abstratDevices;
        private List<String> initIpList = new ArrayList<String>(16);
        private List<IImportListener> tableImportListeners = new ArrayList<IImportListener>();
        private List<IImportListener> batchImportListeners = new ArrayList<IImportListener>();
        private BatchPortsCheckDialog batchPortsCheckDialog;

        RefreshUIThead(BatchPortsCheckDialog batchPortsCheckDialog, Map<ITDeviceType, KeyValue<Integer, Integer>> deviceTypeMap, String taskID, List<AbstractDevice> devices, List<String> initIpList) {
            this.batchPortsCheckDialog = batchPortsCheckDialog;
            this.devTypeMap = deviceTypeMap;
            this.threadId = taskID;
            this.abstratDevices = devices;
            this.initIpList = initIpList;
        }

        RefreshUIThead(List<IImportListener> list, Map<ITDeviceType, KeyValue<Integer, Integer>> deviceTypeMap, String taskID, List<AbstractDevice> devices, List<String> initIpList) {
            this.setAllTableImportListener(list);
            this.devTypeMap = deviceTypeMap;
            this.threadId = taskID;
            this.abstratDevices = devices;
            this.initIpList = initIpList;
        }

        @Override
        public void run() {
            log.info("UI device info refreshing thread started, taskID={}.", (Object)this.threadId);
            try {
                this.refreshCMDDriverUI(this.devTypeMap, this.threadId);
            }
            catch (Exception e) {
                log.error("Error on progress refershing.", (Throwable)e);
            }
        }

        private void refreshCMDDriverUI(Map<ITDeviceType, KeyValue<Integer, Integer>> devTypeMaps, String id) {
            boolean isComplete;
            while (!(isComplete = this.refresh(this.threadId, this.devTypeMap))) {
            }
        }

        private BatchImportInfoDialog getBatchDialog(List<IImportListener> dialogs) {
            for (IImportListener listener : dialogs) {
                if (!(listener instanceof BatchImportInfoDialog)) continue;
                return (BatchImportInfoDialog)listener;
            }
            return null;
        }

        private boolean refresh(String taskID, Map<ITDeviceType, KeyValue<Integer, Integer>> deviceTypeMap) {
            BatchPortsCheckDialog dialog;
            if (DeviceCenterContext.getInstance().isBatchisCancel()) {
                log.info("the batchImport task is canceled,stop refresh Process.");
                DeviceControl.this.serverFinish = true;
                this.refreshTables(taskID);
                return true;
            }
            TotalDriverResult result = DeviceControl.this.isSupportSshForward ? SshForwardContext.getInstance().getTotalDriverResult(taskID) : DeviceControl.this.driverWortaker.getDriverResult(taskID);
            JDialog jDialog = dialog = Objects.nonNull(this.batchPortsCheckDialog) ? this.batchPortsCheckDialog : this.getBatchDialog(this.batchImportListeners);
            if (Objects.nonNull(dialog)) {
                dialog.refreshProcess(result);
            }
            DeviceControl.this.refreshDeviceStatus(result.getTotalDriverResultMap(), deviceTypeMap);
            if (DeviceControl.this.checkFinish(result.getTotalStatusMap(), deviceTypeMap)) {
                log.info("server is Finish import.");
                DeviceControl.this.serverFinish = true;
                this.refreshTables(taskID);
                return true;
            }
            if (DeviceControl.this.checkTimeout(deviceTypeMap)) {
                this.buildTimeoutStatus(dialog, result);
                return true;
            }
            DeviceControl.this.waitForSometime();
            return false;
        }

        private void buildTimeoutStatus(IImportListener bDialog, TotalDriverResult result) {
            log.info("devices is timeout.");
            DriverResult driverResultByDeviceType = result.getDriverResultByDeviceType(ITDeviceType.SERVER_IBMC);
            List<DeviceProgress> deviceProgressList = driverResultByDeviceType.getDeviceProgressList();
            boolean abnormalResult = deviceProgressList.isEmpty();
            if (abnormalResult) {
                this.generateStatusForAbnormalResults(driverResultByDeviceType, deviceProgressList);
                if (null != bDialog) {
                    bDialog.refreshProcess(result);
                }
                DeviceControl.this.driverWortaker.backupProgressFile(this.threadId);
            }
            DeviceControl.this.serverFinish = true;
            this.refreshTables(result);
        }

        private void generateStatusForAbnormalResults(DriverResult driverResultByDeviceType, List<DeviceProgress> deviceProgressList) {
            driverResultByDeviceType.setProgress(100);
            for (String initIp : this.initIpList) {
                boolean hasResult = false;
                for (DeviceProgress deviceProgress : deviceProgressList) {
                    if (!deviceProgress.getIp().equals(initIp)) continue;
                    hasResult = true;
                }
                if (hasResult) continue;
                DeviceProgress noResponseDeviceProgress = new DeviceProgress(initIp);
                noResponseDeviceProgress.setErrMsg(ResourceUtil.getString((String)"devicecenter.device.add.driver.no.response"));
                noResponseDeviceProgress.setStatus(CommonStatus.FINISHED);
                noResponseDeviceProgress.setResult(DeviceResult.FAILED);
                noResponseDeviceProgress.setPassRate(100);
                deviceProgressList.add(noResponseDeviceProgress);
            }
        }

        private void refreshSceneAddDialog(List<AbstractDevice> serverDeviceLists) {
            List<IImportListener> sceneTables = DeviceCenterContext.getInstance().getSceneDeviceTables().get("sceneTables");
            if (null != sceneTables) {
                for (IImportListener listener : sceneTables) {
                    if (log.isInfoEnabled()) {
                        log.info("scene addDialog tables refresh name = " + listener.getName());
                    }
                    listener.refreshTable(serverDeviceLists);
                }
            }
        }

        private void refreshTables(String taskId) {
            TotalDriverResult result = DeviceControl.this.isSupportSshForward ? SshForwardContext.getInstance().getTotalDriverResult(taskId) : DeviceControl.this.driverWortaker.getDriverResult(this.threadId);
            this.refreshTables(result);
        }

        private void refreshTables(TotalDriverResult result) {
            if (Objects.nonNull(this.batchPortsCheckDialog)) {
                this.batchPortsCheckDialog.refreshTable(null);
                return;
            }
            log.info("begin create ibmc hmm or os Devices by umate progress xml.");
            DriverResult umateDriResult = result.getDriverResultByDeviceType(ITDeviceType.SERVER_IBMC);
            this.checkFingerPrint(umateDriResult);
            List serverDeviceList = null;
            if (LogUtils.isComputeUpgradeScene()) {
                Map<String, AbstractDevice> abstractDeviceMap = this.abstratDevices.stream().collect(Collectors.toMap(AbstractDevice::getIp, device -> device));
                serverDeviceList = DeviceControl.this.constructDevice(umateDriResult, abstractDeviceMap);
            } else {
                serverDeviceList = this.distinctDeviceList(DeviceControl.this.constructServerDevice(umateDriResult, this.abstratDevices));
                log.info("successs! create ibmc hmm or os Devices by umate progress xml.");
            }
            log.info("refresh ibmc hmm os device data to table.");
            for (IImportListener listener : this.tableImportListeners) {
                if (log.isInfoEnabled()) {
                    log.info("main tables refresh name = " + listener.getName());
                }
                listener.refreshTable(serverDeviceList);
            }
            this.refreshBatchImportDialog(this.batchImportListeners, serverDeviceList);
            this.refreshSceneAddDialog(serverDeviceList);
            DeviceCenterContext.getInstance().setIbmcHmmOsDevs(serverDeviceList);
            DeviceCenterContext.getInstance().notifyDeviceObserver();
        }

        private void checkFingerPrint(DriverResult umateDriResult) {
            if (null == umateDriResult) {
                return;
            }
            if (!ApplicationContext.getInstance().isVerifySshHostKey()) {
                return;
            }
            List<DeviceProgress> deviceProgressList = umateDriResult.getDeviceProgressList();
            List<DeviceProgress> deviceWithUnrecordedFingerPrint = Collections.synchronizedList(new ArrayList());
            deviceProgressList.forEach(deviceProgress -> this.buildUnrecordedFingerPrintList(deviceWithUnrecordedFingerPrint, (DeviceProgress)deviceProgress));
            boolean acceptFingerPrint = this.hadAcceptedNewFingerPrint(deviceWithUnrecordedFingerPrint);
            if (!acceptFingerPrint) {
                deviceProgressList.removeIf(deviceProgress -> deviceWithUnrecordedFingerPrint.stream().anyMatch(unrecordedDevice -> unrecordedDevice.equals(deviceProgress)));
            }
        }

        private void buildUnrecordedFingerPrintList(List<DeviceProgress> deviceWithUnrecordedFingerPrint, DeviceProgress devProgress) {
            if (null != devProgress && !StringUtils.isNULLStr(devProgress.getSshHostKey()) && !SshKnownHostsManager.isHostAdded(devProgress.getIp())) {
                deviceWithUnrecordedFingerPrint.add(devProgress);
            }
        }

        private boolean hadAcceptedNewFingerPrint(List<DeviceProgress> deviceWithUnrecordedFingerPrint) {
            if (!deviceWithUnrecordedFingerPrint.isEmpty()) {
                ArrayList<ArrayList<Object>> fingerPrintTableRows = this.buildUnrecordedFingerPrintList(deviceWithUnrecordedFingerPrint);
                BatchImportInfoDialog parent = this.getImportDialogAsParent();
                String userAlertinfo = ResourceUtil.getString((String)"ssh.adddevice.batch.alert");
                String[] headers = new String[]{ResourceUtil.getString((String)"fingerprint.header.id"), ResourceUtil.getString((String)"fingerprint.header.fp")};
                boolean isOKSelected = SubDialogUtils.showMultiInfoDialog((Window)parent, fingerPrintTableRows, (boolean)true, (String)userAlertinfo, (String[])headers);
                if (isOKSelected) {
                    for (DeviceProgress deviceProgress : deviceWithUnrecordedFingerPrint) {
                        SshKnownHostsManager.cacheHostKey(deviceProgress.getIp(), AESEncrypt.decrypt((String)deviceProgress.getSshHostKey()));
                        SshKnownHostsManager.cacheHostKeyInfoVerifyFlag(deviceProgress.getIp(), true);
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        private ArrayList<ArrayList<Object>> buildUnrecordedFingerPrintList(List<DeviceProgress> deviceWithUnrecordedFingerPrint) {
            ArrayList<ArrayList<Object>> fingerPrintTableRows = new ArrayList<ArrayList<Object>>();
            deviceWithUnrecordedFingerPrint.forEach(deviceProgress -> {
                ArrayList<String> tableRow = new ArrayList<String>();
                String ip = deviceProgress.getIp();
                String fingerPrint = deviceProgress.getFingerPrint();
                tableRow.add(ip);
                tableRow.add(ResourceUtil.getStringWithParams((String)"ssh.adddevice.simply.alert", (Object[])new Object[]{fingerPrint}));
                fingerPrintTableRows.add(tableRow);
            });
            return fingerPrintTableRows;
        }

        private BatchImportInfoDialog getImportDialogAsParent() {
            Optional<IImportListener> possibleBatchListener = this.batchImportListeners.stream().filter(listener -> listener instanceof BatchImportInfoDialog).findAny();
            BatchImportInfoDialog parent = null;
            if (possibleBatchListener.isPresent()) {
                parent = (BatchImportInfoDialog)possibleBatchListener.get();
            }
            return parent;
        }

        private List<AbstractDevice> distinctDeviceList(List<AbstractDevice> serverDeviceList) {
            ArrayList<AbstractDevice> devices = new ArrayList<AbstractDevice>();
            for (AbstractDevice dev : serverDeviceList) {
                if (devices.contains(dev)) continue;
                devices.add(dev);
            }
            return devices;
        }

        private void refreshBatchImportDialog(List<IImportListener> batchImportListeners, List<AbstractDevice> serverDeviceList) {
            batchImportListeners.stream().forEach(batch -> batch.refreshTable(serverDeviceList));
        }

        private void setAllTableImportListener(List<IImportListener> lists) {
            for (IImportListener list : lists) {
                if (list instanceof BatchImportInfoDialog) {
                    this.batchImportListeners.add(list);
                    continue;
                }
                this.tableImportListeners.add(list);
            }
        }
    }

    private class CheckPortsDialogShowThread
    implements Runnable {
        private BatchPortsCheckDialog dialog;

        @Override
        public void run() {
            SwingUtil.putParentCenter((Window)this.dialog, (Window)DeviceCenterContext.getInstance().getParent());
            this.dialog.setVisible(true);
        }

        public CheckPortsDialogShowThread(BatchPortsCheckDialog dialog) {
            this.dialog = dialog;
        }
    }

    private class ImportDialogShowThread
    implements Runnable {
        IImportListener dialog;

        @Override
        public void run() {
            SwingUtil.putParentCenter((Window)((BatchImportInfoDialog)this.dialog), (Window)DeviceCenterContext.getInstance().getParent());
            ((BatchImportInfoDialog)this.dialog).setVisible(true);
        }

        public ImportDialogShowThread(IImportListener dialog) {
            this.dialog = dialog;
        }
    }
}

