/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.CommonStatus;
import com.huawei.ism.tool.devicecenter.driver.model.DeviceProgress;
import com.huawei.ism.tool.devicecenter.driver.model.DriverResult;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.driver.model.PortCheckStatus;
import com.huawei.ism.tool.devicecenter.driver.model.PortsCheckResult;
import com.huawei.ism.tool.devicecenter.driver.model.TotalDriverResult;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.listener.ExportListener;
import com.huawei.ism.tool.devicecenter.service.BatchPortsCheckService;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.BatchPortsCheckLayout;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.GifAssistant;

public class BatchPortsCheckDialog
extends JDialog
implements IImportListener,
GifAssistant.IGifUiObserver {
    private static final Logger log = LoggerFactory.getLogger(BatchPortsCheckDialog.class);
    private static final int CHECK_TABLE_IP_INDEX = 0;
    private static final int CHECK_TABLE_NET_INDEX = 1;
    private static final int CHECK_TABLE_SSH_INDEX = 2;
    private static final int CHECK_TABLE_REDFISH_INDEX = 3;
    private static final int CHECK_TABLE_IPMI_INDEX = 4;
    private static final int CHECK_TABLE_SNMP_INDEX = 5;
    private static final String CHECK_PORT_PASS = "pass";
    private static final String CHECK_PORT_FAILED = "failed";
    private static final String BATCH_PORTS_CHECK_DIALOG = "batchPortsCheckDialog";
    private static final int LARGER_NETWORK_LATENCY_BY_MILLISECOND = 100;
    private static final int SMALLER_NETWORK_LATENCY_BY_MILLISECOND = 70;
    private static final Dimension CH_SIZE = new Dimension(600, 380);
    private static final Dimension EN_SIZE = new Dimension(700, 400);
    private final BatchPortsCheckService batchPortsCheckService = new BatchPortsCheckService();
    private Map<String, PortsCheckResult> rowCheckResultMap = new HashMap<String, PortsCheckResult>();
    private BatchPortsCheckLayout layout;
    private GifAssistant gifAssistant = GifAssistant.getInstance();
    private int progress = 0;
    private List<DeviceProgress> deviceProgressList;

    public BatchPortsCheckDialog(Window parent, String title) {
        super(parent);
        this.setTitle(title);
        this.layout = new BatchPortsCheckLayout();
        this.add(this.layout);
        this.setModal(true);
        this.setResizable(false);
        if (ApplicationContext.getInstance().isEnglishEnv()) {
            this.setSize(EN_SIZE);
        } else {
            this.setSize(CH_SIZE);
        }
        SwingUtil.putScreenCenter((Window)this);
        this.initListener();
        this.gifAssistant.setObserver(this);
    }

    private void initListener() {
        this.layout.getCancelBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchPortsCheckDialog.this.closeAction();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BatchPortsCheckDialog.this.closeAction();
            }
        });
        this.layout.getDeviceTable().addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                BatchPortsCheckDialog.this.showNetworkTipsByMouseMoved(e);
            }
        });
    }

    private void showNetworkTipsByMouseMoved(MouseEvent e) {
        Object ipObject;
        IsmTable tableModel = this.layout.getDeviceTable();
        int row = tableModel.rowAtPoint(e.getPoint());
        int col = tableModel.columnAtPoint(e.getPoint());
        tableModel.setToolTipText(null);
        if (col == 1 && (ipObject = tableModel.getValueAt(row, 0)) != null && this.rowCheckResultMap.containsKey(String.valueOf(ipObject))) {
            PortsCheckResult portsCheckResult = this.rowCheckResultMap.get(String.valueOf(ipObject));
            String networkTips = portsCheckResult.getNetworkTips();
            tableModel.setToolTipText(networkTips);
        }
    }

    private void closeAction() {
        if (this.progress < 100) {
            DeviceCenterContext.getInstance().setBatchisCancel(true);
        }
        if (!Objects.isNull(this.gifAssistant) && this.gifAssistant.isStart()) {
            this.gifAssistant.stopGifLoading();
        }
        SmartkitUtils.killDriverProcess();
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void finishedImport(TotalDriverResult totalDriverResult) {
    }

    @Override
    public void startCheckImportDevice(List<String> serverIpList) {
        serverIpList.stream().map(ip -> new DefaultTableRow(6, (Object)new DriverResult(), ip)).forEach(row -> {
            row.setValueAt(0, row.getIdentifier());
            this.rowSetCheckCellValue((TableRow<DriverResult, String>)row, (IsmTableCell)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"wait.png"), CommonStatus.WAITING_CHECK.getTitle()));
            this.getTableModel().addRow(new TableRow[]{row});
        });
    }

    @Override
    public void refreshProcess(TotalDriverResult totalDriverResult) {
        if (Objects.isNull(totalDriverResult) || Objects.isNull(totalDriverResult.getDriverResultByDeviceType(ITDeviceType.SERVER_IBMC))) {
            log.warn("Result is null, skip refreshing cycle once.");
            return;
        }
        DriverResult result = totalDriverResult.getDriverResultByDeviceType(ITDeviceType.SERVER_IBMC);
        this.deviceProgressList = result.getDeviceProgressList();
        this.progress = result.getProgress();
        if (this.progress == 100) {
            this.layout.getCancelBtn().setText(ResourceUtil.getString((String)"device.import.impaddexp.install"));
            this.layout.getExportBtn().addActionListener(new ExportListener(this.rowCheckResultMap, this));
            this.layout.getExportBtn().setEnabled(true);
            this.gifAssistant.stopGifLoading();
        }
        this.layout.getProgressBar().setValue(this.progress);
        if (this.isAllFinish() && !this.deviceProgressList.isEmpty() && this.progress != 100) {
            this.layout.getCancelBtn().setText(ResourceUtil.getString((String)"device.import.impaddexp.install"));
            this.layout.getExportBtn().addActionListener(new ExportListener(this.rowCheckResultMap, this));
            this.layout.getExportBtn().setEnabled(true);
            this.gifAssistant.stopGifLoading();
            this.layout.getProgressBar().setValue(100);
        }
        this.repaint();
    }

    private boolean isAllFinish() {
        boolean allFinishedFlag = true;
        block6: for (DeviceProgress deviceProgress : this.deviceProgressList) {
            int currentRowIndex = this.getTableModel().getRowIndex((Object)deviceProgress.getIp());
            if (currentRowIndex == -1) continue;
            TableRow row = this.getTableModel().getRow(currentRowIndex);
            if (deviceProgress.getPassRate() == 100 && deviceProgress.getStatus() != CommonStatus.FINISHED) {
                deviceProgress.setStatus(CommonStatus.FINISHED);
            }
            switch (deviceProgress.getStatus()) {
                case RUNNING: {
                    this.startGifSwitch();
                    IsmTableCell.IconCell cellForCheck = new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"loading1.png"), CommonStatus.CHECKING.getTitle());
                    this.rowSetCheckCellValue((TableRow<DriverResult, String>)row, (IsmTableCell)cellForCheck);
                    allFinishedFlag = false;
                    continue block6;
                }
                case WAITING: {
                    IsmTableCell.IconCell cellForWait = new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"wait.png"), CommonStatus.WAITING.getTitle());
                    this.rowSetCheckCellValue((TableRow<DriverResult, String>)row, (IsmTableCell)cellForWait);
                    allFinishedFlag = false;
                    continue block6;
                }
                case FINISHED: {
                    this.refreshFinishedState(deviceProgress, (TableRow<DriverResult, String>)row);
                    continue block6;
                }
                case ERROR: {
                    IsmTableCell.IconCell cellForError = new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"dev_failed.png"), CommonStatus.ERROR.getTitle());
                    this.rowSetCheckCellValue((TableRow<DriverResult, String>)row, (IsmTableCell)cellForError);
                    allFinishedFlag = false;
                    continue block6;
                }
            }
            allFinishedFlag = false;
        }
        return allFinishedFlag;
    }

    private void rowSetCheckCellValue(TableRow<DriverResult, String> row, IsmTableCell cell) {
        row.setValueAt(1, (Object)cell);
        row.setValueAt(2, (Object)cell);
        row.setValueAt(3, (Object)cell);
        row.setValueAt(4, (Object)cell);
        row.setValueAt(5, (Object)cell);
    }

    private void refreshFinishedState(DeviceProgress deviceProgress, TableRow<DriverResult, String> row) {
        IsmTableCell.IconCell cellForSuccess = new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"success.png"), CHECK_PORT_PASS.toUpperCase(Locale.ENGLISH));
        IsmTableCell.IconCell cellForFailed = new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"dev_failed.png"), CHECK_PORT_FAILED.toUpperCase(Locale.ENGLISH));
        PortsCheckResult devPortsCheckResult = deviceProgress.getDevPortsCheckResult();
        int maxNetworkLatency = devPortsCheckResult.getNet();
        String networkQuality = this.getNetworkQuality(maxNetworkLatency);
        row.setValueAt(1, (Object)networkQuality);
        this.setPortsCheckResult2Row(row, 2, devPortsCheckResult.getSsh(), cellForSuccess, cellForFailed);
        this.setPortsCheckResult2Row(row, 3, devPortsCheckResult.getRedfish(), cellForSuccess, cellForFailed);
        this.setPortsCheckResult2Row(row, 4, devPortsCheckResult.getIpmi(), cellForSuccess, cellForFailed);
        this.setPortsCheckResult2Row(row, 5, devPortsCheckResult.getSnmp(), cellForSuccess, cellForFailed);
        String tipText = maxNetworkLatency < 0 ? ResourceUtil.getString((String)"devicecenter.ismtable.body.network.disconnected") : ResourceUtil.getStringWithParams((String)"devicecenter.ismtable.body.network.quality.tips", (Object[])new Object[]{networkQuality, maxNetworkLatency});
        devPortsCheckResult.setNetworkTips(tipText);
        this.rowCheckResultMap.put((String)row.getIdentifier(), devPortsCheckResult);
    }

    private void setPortsCheckResult2Row(TableRow<DriverResult, String> row, int colIndex, PortCheckStatus portCheckStatus, IsmTableCell.IconCell cellForSuccess, IsmTableCell.IconCell cellForFailed) {
        IsmTableCell.IconCell ipmiCheckResultCell = portCheckStatus == PortCheckStatus.PASS ? cellForSuccess : cellForFailed;
        row.setValueAt(colIndex, (Object)ipmiCheckResultCell);
    }

    private String getNetworkQuality(int maxNetworkLatency) {
        if (maxNetworkLatency >= 0 && maxNetworkLatency < 70) {
            return ResourceUtil.getString((String)"devicecenter.ismtable.body.network.quality.good");
        }
        if (maxNetworkLatency >= 70 && maxNetworkLatency < 100) {
            return ResourceUtil.getString((String)"devicecenter.ismtable.body.network.quality.general");
        }
        if (maxNetworkLatency >= 100) {
            return ResourceUtil.getString((String)"devicecenter.ismtable.body.network.quality.poor");
        }
        return ResourceUtil.getString((String)"devicecenter.ismtable.body.network.disconnected");
    }

    @Override
    public void dealWithException(String mesage) {
    }

    @Override
    public void refreshTable(List<AbstractDevice> progressList) {
        int failedNum = this.batchPortsCheckService.getNumberOfCheckFailed(this.rowCheckResultMap);
        this.checkPortsStatusLabel(this.rowCheckResultMap.size() - failedNum, failedNum);
    }

    private void checkPortsStatusLabel(int successNum, int failedNum) {
        this.layout.getImportStatusLabel().setText(ResourceUtil.getStringWithParams((String)"devicecenter.ismtable.header.batchcheck.status.count", (Object[])new Object[]{successNum, failedNum}));
    }

    @Override
    public void refreshLoadingPic() {
        for (DeviceProgress deviceProgress : this.deviceProgressList) {
            int currentRowIndex = this.getTableModel().getRowIndex((Object)deviceProgress.getIp());
            if (currentRowIndex == -1) continue;
            TableRow row = this.getTableModel().getRow(currentRowIndex);
            if (deviceProgress.getStatus() != CommonStatus.RUNNING) continue;
            IsmTableCell.IconCell cell = new IsmTableCell.IconCell((Icon)this.gifAssistant.getProcessingImage(), CommonStatus.CHECKING.getTitle());
            this.rowSetCheckCellValue((TableRow<DriverResult, String>)row, (IsmTableCell)cell);
            this.repaint();
        }
    }

    private void startGifSwitch() {
        if (this.gifAssistant.isStart()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("Batch Check Ports Dialog this hashCode = " + this.hashCode());
        }
        this.gifAssistant.start();
    }

    @Override
    public String getName() {
        return BATCH_PORTS_CHECK_DIALOG;
    }

    @Override
    public DefaultTableModel getTableModel() {
        return this.layout.getTableModel();
    }
}

