/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.exception.ExcelParseException;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.DevWhiteListLayout;
import com.huawei.ism.tool.devicecenter.utils.ExcelUtils;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.json.JSONUtils;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevWhiteListDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(DevWhiteListDialog.class);
    private static final String SEVER_MAIN_PATH = Paths.get(ApplicationContext.getInstance().getRuntimePath(), "drivers", "server", "config", "snWhiteList").toString();
    private static final int COL_NUM_SN = 0;
    private static final Dimension CH_SIZE = new Dimension(600, 380);
    private static final int SN_COLUM = 0;
    private static final String SN_LIST_KEY = "snList";
    private static final String ENABLE_WHITE_LIST_KEY = "enableWhiteList";
    private static final String EXPORT_FILE_NAME = "snWhiteList.xls";
    private static final long serialVersionUID = 1172582904682515560L;
    private static final String SN_REGEX = "^[a-zA-Z0-9]{1,50}$";
    private static final int EXCEL_MAX_LINE = Integer.parseInt(com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getAppConfig("app.devicecenter.excel.max.num").trim());
    private static List<String> snList;
    private boolean needSave = false;
    private DevWhiteListLayout layout;
    private ActionListener saveCallBack;

    public DevWhiteListDialog(Window parent, String title) {
        super(parent);
        this.setTitle(title);
        this.setModal(true);
        this.setResizable(false);
        this.setSize(CH_SIZE);
        SwingUtil.putScreenCenter((Window)this);
        this.layout = new DevWhiteListLayout();
        this.add(this.layout);
        this.initListener();
        DevWhiteListDialog.loadSnList();
        this.refreshSnTable();
    }

    private void initListener() {
        this.layout.getImportBtn().addActionListener(env -> this.importSnWhiteList());
        this.layout.getSaveBtn().addActionListener(env -> this.saveSnWithDialog());
        this.layout.getRemoveBtn().addActionListener(env -> this.removeSelectedRow());
        this.layout.getExportBtn().addActionListener(env -> this.exportWhiteList());
    }

    public static synchronized void loadSnList() {
        try {
            String content = new String(FileUtils.readFileToByteArray((File)new File(SEVER_MAIN_PATH)));
            Map snWhiteConfig = JSONUtils.jsonToMaps((String)content);
            snList = snWhiteConfig.getOrDefault(SN_LIST_KEY, new ArrayList());
            DeviceCenterContext.setEnableWhiteList(snWhiteConfig.getOrDefault(ENABLE_WHITE_LIST_KEY, false));
        }
        catch (IOException e) {
            log.warn("sn config not exist");
            snList = new ArrayList<String>();
            DeviceCenterContext.setEnableWhiteList(false);
        }
    }

    private void refreshSnTable() {
        this.layout.getTableModel().removeAll();
        snList.forEach(sn -> {
            DefaultTableRow row = new DefaultTableRow(2, sn);
            row.setValueAt(0, sn);
            this.layout.getTableModel().addRow(new TableRow[]{row});
        });
    }

    public boolean saveSn() {
        HashMap<String, Object> snWhiteConfig = new HashMap<String, Object>();
        snWhiteConfig.put(SN_LIST_KEY, snList);
        snWhiteConfig.put(ENABLE_WHITE_LIST_KEY, DeviceCenterContext.isEnableWhiteList());
        try {
            FileUtils.write((File)new File(SEVER_MAIN_PATH), (CharSequence)JSONUtils.toJson(snWhiteConfig), (boolean)false);
            this.needSave = false;
            return true;
        }
        catch (IOException e) {
            log.warn("save sn config failed", (Throwable)e);
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicecenter.ismtable.header.white.btn.save.failed"));
            return false;
        }
    }

    private void saveSnWithDialog() {
        if (this.saveSn()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicecenter.ismtable.header.white.sn.save.success"));
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() != 201) {
            return;
        }
        if (this.needSave) {
            WarningDialog wd = DialogUtils.showYesNoDialogOnTop((String)ResourceUtil.getString((String)"devicecenter.ismtable.header.white.btn.save.tip"));
            if (wd.getValue() == 0 && !this.saveSn()) {
                return;
            }
            DevWhiteListDialog.loadSnList();
            this.refreshSnTable();
            this.needSave = false;
        }
        if (this.saveCallBack != null) {
            this.saveCallBack.actionPerformed(null);
        }
        this.setVisible(false);
    }

    private void addSn(Sheet sheet) {
        boolean existInvalidSn = false;
        for (int rowIndex = 1; rowIndex < sheet.getPhysicalNumberOfRows(); ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            if (row == null) continue;
            try {
                String sn = ExcelUtils.getCellStrVal(row, 0);
                if (StringUtils.isEmpty((CharSequence)sn)) continue;
                Pattern pattern = Pattern.compile(SN_REGEX);
                Matcher matcher = pattern.matcher(sn);
                if (!matcher.matches()) {
                    existInvalidSn = true;
                    continue;
                }
                if (snList.contains(sn)) continue;
                snList.add(sn);
                continue;
            }
            catch (ExcelParseException e) {
                log.error("get row {} value error", (Object)rowIndex);
            }
        }
        if (existInvalidSn) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicecenter.ismtable.header.white.btn.import.invalid"));
        }
    }

    private void importSnWhiteList() {
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put("title", ResourceUtil.getString((String)"devicecenter.ismtable.header.white.import.select.file"));
        extParams.put("PathId", "select_white_dev");
        extParams.put("description", "*.xls;*.xlsx");
        File selectFile = ToolFileChooser.selectFile((Window)this, new String[]{"xls", "xlsx"}, 0, true, extParams);
        if (selectFile == null || !selectFile.exists() || ExcelUtils.getWorkBook(selectFile) == null) {
            return;
        }
        Sheet sheet = ExcelUtils.getWorkBook(selectFile).getSheetAt(0);
        int rowNum = sheet.getPhysicalNumberOfRows();
        if (rowNum <= 1) {
            return;
        }
        if (rowNum > EXCEL_MAX_LINE) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getStringWithParams((String)"devicecenter.device.import.excel.max.num.tips", (Object[])new Object[]{String.valueOf(EXCEL_MAX_LINE)}));
            log.error("the number of imported template {} records exceeds the upper limit.", (Object)selectFile.getName());
            return;
        }
        this.addSn(sheet);
        this.needSave = true;
        this.refreshSnTable();
        DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicecenter.ismtable.header.white.sn.import.success"));
    }

    private void removeSelectedRow() {
        int[] rows = this.layout.getSnTable().getSelectedRows();
        if (rows.length == 0) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicecenter.ismtable.header.white.sn.remove.empty"));
            return;
        }
        Arrays.stream(rows).forEach(index -> snList.set(index, ""));
        snList = snList.stream().filter(sn -> !StringUtils.isEmpty((CharSequence)sn)).collect(Collectors.toList());
        this.needSave = true;
        this.refreshSnTable();
        DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicecenter.ismtable.header.white.sn.remove.success"));
    }

    private void exportWhiteList() {
        String title = ResourceUtil.getString((String)"devicecenter.ismtable.header.white.export.select");
        String saveFilePath = ToolFileChooser.getSaveFilePath(title, "", this, EXPORT_FILE_NAME, EXPORT_FILE_NAME);
        if (StringUtils.isEmpty((CharSequence)saveFilePath)) {
            log.error("No files selected.");
            return;
        }
        try (HSSFWorkbook workBook = new HSSFWorkbook();
             OutputStream out = Files.newOutputStream(Paths.get(saveFilePath, new String[0]), new OpenOption[0]);){
            HSSFCellStyle cellStyle = POIUtils.createTitleStyle(workBook);
            HSSFCellStyle unlockCellStyle = POIUtils.createContentStyle(workBook);
            unlockCellStyle.setLocked(false);
            cellStyle.setDataFormat(workBook.createDataFormat().getFormat("@"));
            workBook.createSheet(SN_LIST_KEY);
            HSSFSheet sheet = workBook.getSheetAt(0);
            sheet.setColumnWidth(0, 12800);
            sheet.protectSheet("");
            Row header = sheet.createRow(0);
            Cell cell = header.createCell(0);
            cell.setCellValue(ResourceUtil.getString((String)"devicecenter.ismtable.header.white.export.title"));
            cellStyle.setLocked(true);
            cell.setCellStyle((CellStyle)cellStyle);
            snList.forEach(arg_0 -> DevWhiteListDialog.lambda$exportWhiteList$7((Sheet)sheet, (CellStyle)unlockCellStyle, arg_0));
            int i = snList.size() + 1;
            while (i + snList.size() < EXCEL_MAX_LINE) {
                Row row = sheet.createRow(sheet.getLastRowNum() + 1);
                Cell emptyCell = row.createCell(0);
                emptyCell.setCellStyle((CellStyle)unlockCellStyle);
                ++i;
            }
            workBook.write(out);
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicecenter.ismtable.header.white.export.success"));
        }
        catch (IOException e) {
            log.error("save sn Excel Error", (Throwable)e);
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicecenter.ismtable.header.white.export.failed"));
        }
    }

    public DevWhiteListDialog(boolean needSave, DevWhiteListLayout layout, ActionListener saveCallBack) {
        this.needSave = needSave;
        this.layout = layout;
        this.saveCallBack = saveCallBack;
    }

    public static List<String> getSnList() {
        return snList;
    }

    public void setSaveCallBack(ActionListener saveCallBack) {
        this.saveCallBack = saveCallBack;
    }

    private static /* synthetic */ void lambda$exportWhiteList$7(Sheet sheet, CellStyle unlockCellStyle, String sn) {
        Row row = sheet.createRow(sheet.getLastRowNum() + 1);
        Cell snCell = row.createCell(0);
        snCell.setCellValue(sn);
        snCell.setCellStyle(unlockCellStyle);
    }
}

