/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.ComputeNodePlate;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.entity.SwitchPlate;
import com.huawei.ism.tool.devicecenter.service.DeviceControl;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.service.SingleDeviceAddInterface;
import com.huawei.ism.tool.devicecenter.thread.CheckPortThread;
import com.huawei.ism.tool.devicecenter.ui.dialog.BatchImportInfoDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.BatchPortsCheckDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.ComputeNodeEntity;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.HmmDeviceAddLayout;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.HmmSwitchChoosePanel;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.SwitchChooseContentLayout;
import com.huawei.ism.tool.devicecenter.utils.LayUtil;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.ui.swing.text.IsmTextField;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPasswordField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmmDeviceAddDialog
extends JDialog
implements SingleDeviceAddInterface {
    private static final Logger log = LoggerFactory.getLogger(HmmDeviceAddDialog.class);
    private static final Color GRAY_COLOR = new Color(0x999999);
    private static final Color DEFAULT_TEXT_COLOR = new Color(51, 51, 51);
    private static List<String> swModuleKeys = new ArrayList<String>();
    private HmmDeviceAddLayout layout;
    private Dimension size = new Dimension(900, 890);
    private int dialogHigh = (int)this.size.getHeight();
    private List<IImportListener> listenerTables = DeviceCenterContext.getInstance().getDeviceTables().get("deviceTables");
    private List<AbstractDevice> hwServerDevs = new ArrayList<AbstractDevice>();
    private TaskResult exportResult = null;
    private HwServerDevice devInitHwServer;
    private String startIpTips = ResourceUtil.getString((String)"devicecenter.device.add.start.ip.tip", (Locale)Locale.CHINESE);
    private List<ComputeNodeEntity> nodeList = new ArrayList<ComputeNodeEntity>();
    private boolean isUseNodePlate = false;
    private boolean isApplyToOtherNode = false;

    public HmmDeviceAddDialog(HmmDeviceAddLayout lay) {
        this.layout = lay;
        this.setTitle(ResourceUtil.getString((String)"smartkit.devicemanager.layout.modifyDev.title"));
        this.initDialog();
        this.initSwModuleKeys();
    }

    public HmmDeviceAddDialog() {
        this.layout = new HmmDeviceAddLayout(true);
        this.setTitle(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.title"));
        this.initDialog();
        this.layout.getSnmpPortField().setText("161");
        this.layout.getIpmiPortField().setText("623");
        this.layout.getSshSfipPortField().setText("22");
        this.layout.getVMPortField().setText("8208");
        this.layout.getRedfishPortPortField().setText("443");
        this.layout.getStartIpAddress().setText(this.startIpTips);
        this.layout.getStartIpAddress().setForeground(GRAY_COLOR);
        this.initSwModuleKeys();
    }

    private void initSwModuleKeys() {
        swModuleKeys.clear();
        swModuleKeys.add(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.hmm.switchOne"));
        swModuleKeys.add(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.hmm.switchTwo"));
        swModuleKeys.add(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.hmm.switchThree"));
        swModuleKeys.add(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.hmm.switchFour"));
    }

    private void initDialog() {
        this.add(this.layout);
        this.setSize(this.size);
        this.setModal(true);
        this.setResizable(false);
        this.initListener();
        this.hideSwPanel();
        this.hideComputeNodePanel();
    }

    private void hideSwPanel() {
        this.layout.getSwPanel().setVisible(false);
        this.layout.getSwCheckLink().setIcon(ResourceUtil.getImage((String)"icon-arrow-lg-down.png"));
        this.layout.setShowSwitchPanelFlag(true);
        this.dialogHigh -= 200;
        this.setSize(new Dimension((int)this.size.getWidth(), this.dialogHigh));
    }

    private void hideComputeNodePanel() {
        this.layout.getComputeNodePanel().setVisible(false);
        this.layout.getComputeNodeLink().setIcon(ResourceUtil.getImage((String)"icon-arrow-lg-down.png"));
        this.layout.setShowComputeNodeFlag(true);
        this.dialogHigh -= 200;
        this.setSize(new Dimension((int)this.size.getWidth(), this.dialogHigh));
    }

    private void initIpAboutListener() {
        this.startIpAddressMouseListener();
        this.startIpAddressFocusListener();
        this.startIpAddressKeyListener();
        this.endIpFieldFocusListener();
    }

    private void endIpFieldFocusListener() {
        this.layout.getEndIpField().addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                String startIp = HmmDeviceAddDialog.this.layout.getStartIpAddress().getText();
                String endIp = HmmDeviceAddDialog.this.layout.getEndIpField().getText();
                if (!StringUtils.isNULLStr((String)startIp) && StringUtils.isNULLStr((String)endIp)) {
                    HmmDeviceAddDialog.this.layout.getEndIpField().setText(startIp);
                }
            }
        });
    }

    private void startIpAddressKeyListener() {
        this.layout.getStartIpAddress().addKeyListener(new KeyListener(){

            private void upadateTextFont() {
                String ipText = HmmDeviceAddDialog.this.layout.getStartIpAddress().getText();
                if (StringUtils.isNULLStr((String)ipText)) {
                    return;
                }
                if (ipText.contains(HmmDeviceAddDialog.this.startIpTips)) {
                    ipText = ipText.replace(HmmDeviceAddDialog.this.startIpTips, "");
                    HmmDeviceAddDialog.this.layout.getStartIpAddress().setText(ipText);
                    HmmDeviceAddDialog.this.layout.getStartIpAddress().setForeground(DEFAULT_TEXT_COLOR);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                this.upadateTextFont();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.upadateTextFont();
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
                this.upadateTextFont();
            }
        });
    }

    private void startIpAddressFocusListener() {
        this.layout.getStartIpAddress().addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String ipText = HmmDeviceAddDialog.this.layout.getStartIpAddress().getText();
                if (StringUtils.isNULLStr((String)ipText)) {
                    HmmDeviceAddDialog.this.layout.getStartIpAddress().setText(HmmDeviceAddDialog.this.startIpTips);
                    HmmDeviceAddDialog.this.layout.getStartIpAddress().setForeground(GRAY_COLOR);
                }
            }
        });
    }

    private void startIpAddressMouseListener() {
        this.layout.getStartIpAddress().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                HmmDeviceAddDialog.this.layout.getStartIpAddress().setEnabled(true);
                if (HmmDeviceAddDialog.this.startIpTips.equals(HmmDeviceAddDialog.this.layout.getStartIpAddress().getText())) {
                    HmmDeviceAddDialog.this.layout.getStartIpAddress().setText("");
                    HmmDeviceAddDialog.this.layout.getStartIpAddress().setForeground(DEFAULT_TEXT_COLOR);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                String ipText = HmmDeviceAddDialog.this.layout.getStartIpAddress().getText();
                if (StringUtils.isNULLStr((String)ipText)) {
                    HmmDeviceAddDialog.this.layout.getStartIpAddress().setText(HmmDeviceAddDialog.this.startIpTips);
                    HmmDeviceAddDialog.this.layout.getStartIpAddress().setForeground(GRAY_COLOR);
                }
            }
        });
    }

    private void initAccountDecoupListener() {
        this.layout.getDecouplingSelectRadioBtn().addActionListener(e -> {
            if (this.layout.getDecouplingSelectRadioBtn().isSelected()) {
                this.layout.getRedFishContent().setVisible(true);
            } else {
                this.layout.getRedFishContent().setVisible(false);
            }
        });
    }

    private void initCheckAboutListener() {
        this.highCheckLinkClickListener();
        this.osCheckLinkClickListener();
        this.swCheckLinkClickListener();
        this.computeNodeLinkClickListener();
        this.cancelBtnActionListener();
        this.confirmBtnActionListener();
        this.checkPortBtnActionListener();
        this.applyManageInfo2SwPanelCheckBoxListener();
        this.applyManageInfo2ComputePanelCheckBoxListener();
        this.applyManageInfo2SwComputeCompListener();
    }

    private void applyManageInfo2SwComputeCompListener() {
        this.addListenerToComp((JComponent)this.layout.getUserNameField());
        this.addListenerToComp(this.layout.getKeypwdField());
        this.addListenerToComp(this.layout.getSnmpv3PwdField());
        this.addListenerToComp((JComponent)this.layout.getSnmpPortField());
        this.addListenerToComp((JComponent)this.layout.getIpmiPortField());
        this.addListenerToComp((JComponent)this.layout.getSshSfipPortField());
        this.addListenerToComp((JComponent)this.layout.getVMPortField());
        this.addListenerToComp((JComponent)this.layout.getRedfishPortPortField());
    }

    private void addListenerToComp(JComponent comp) {
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                HmmDeviceAddDialog.this.fillingSwitchPanelPdInfo();
                HmmDeviceAddDialog.this.fillingComputePanelInfo();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                HmmDeviceAddDialog.this.fillingSwitchPanelPdInfo();
                HmmDeviceAddDialog.this.fillingComputePanelInfo();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                HmmDeviceAddDialog.this.fillingSwitchPanelPdInfo();
                HmmDeviceAddDialog.this.fillingComputePanelInfo();
            }
        });
    }

    private void fillingSwitchPanelPdInfo() {
        if (this.layout.getSwPanel().getApplyManageInfo2SwPanelCheckBox().isSelected()) {
            this.layout.getSwPanel().refreshSwitchPanelPdInfo(String.valueOf(this.layout.getKeypwdField().getPassword()));
        }
    }

    private void fillingComputePanelInfo() {
        if (this.layout.getComputeNodePanel().getApplyManageInfo2ComputePanelCheckBox().isSelected()) {
            this.layout.getComputeNodePanel().refreshComputeNodeInfo(this.buildComputeNodePortInfo(), this.layout.getUserNameField().getText(), String.valueOf(this.layout.getKeypwdField().getPassword()), String.valueOf(this.layout.getSnmpv3PwdField().getPassword()));
        }
    }

    public void refreshCheckBoxNotSelected() {
        this.layout.getSwPanel().getApplyManageInfo2SwPanelCheckBox().setSelected(false);
        this.layout.getSwPanel().getSwContent1().getUseSameAllSwCbx().setEnabled(true);
        this.layout.getSwPanel().refreshPdFieldEnableStatus(true);
        this.layout.getSwPanel().setSwitchLabelEnabled(false);
    }

    public void refreshCheckBoxNotSelectedForBatch() {
        this.layout.getSwPanel().getApplyManageInfo2SwPanelCheckBox().setSelected(false);
        this.layout.getSwPanel().getSwContent1().getUseSameAllSwCbx().setEnabled(true);
        this.layout.getSwPanel().getSwContent1().getUseSameAllSwCbx().setSelected(false);
        this.layout.getSwPanel().refreshPdFieldEnableStatus(true);
        this.layout.getSwPanel().setSwitchLabelEnabled(true);
    }

    public void refreshComputeNodeFieldEnable() {
        this.layout.getComputeNodePanel().getApplyManageInfo2ComputePanelCheckBox().setSelected(false);
        this.layout.getComputeNodePanel().getHmmComputeNodePanel().refreshUseSameAllNodeCheckBoxEnabledStatus(true);
        this.layout.getComputeNodePanel().refreshComputeNodeEnableStatus(true);
    }

    private void applyManageInfo2SwPanelCheckBoxListener() {
        this.layout.getSwPanel().getApplyManageInfo2SwPanelCheckBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HmmDeviceAddDialog.this.layout.getSwPanel().getApplyManageInfo2SwPanelCheckBox().isSelected()) {
                    HmmDeviceAddDialog.this.layout.getSwPanel().getSwContent1().getUseSameAllSwCbx().setEnabled(false);
                    HmmDeviceAddDialog.this.layout.getSwPanel().getSwContent1().getUseSameAllSwCbx().setSelected(true);
                    HmmDeviceAddDialog.this.layout.getSwPanel().refreshSwitchPanelPdInfo(String.valueOf(HmmDeviceAddDialog.this.layout.getKeypwdField().getPassword()));
                    HmmDeviceAddDialog.this.layout.getSwPanel().refreshPdFieldEnableStatus(false);
                    HmmDeviceAddDialog.this.layout.getSwPanel().setSwitchLabelEnabled(false);
                } else {
                    HmmDeviceAddDialog.this.layout.getSwPanel().getSwContent1().getUseSameAllSwCbx().setEnabled(true);
                    HmmDeviceAddDialog.this.layout.getSwPanel().getSwContent1().getUseSameAllSwCbx().setSelected(true);
                    HmmDeviceAddDialog.this.layout.getSwPanel().refreshSwitchPanelPdInfo("");
                    HmmDeviceAddDialog.this.layout.getSwPanel().refreshPdFieldEnableStatus(true);
                    HmmDeviceAddDialog.this.layout.getSwPanel().setSwitchLabelEnabled(false);
                }
            }
        });
    }

    private void applyManageInfo2ComputePanelCheckBoxListener() {
        this.layout.getComputeNodePanel().getApplyManageInfo2ComputePanelCheckBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HmmDeviceAddDialog.this.fillingComputePanelInfo();
                if (HmmDeviceAddDialog.this.layout.getComputeNodePanel().getApplyManageInfo2ComputePanelCheckBox().isSelected()) {
                    HmmDeviceAddDialog.this.layout.getComputeNodePanel().getHmmComputeNodePanel().refreshUseSameAllNodeCheckBoxSelectedStatus(true);
                    HmmDeviceAddDialog.this.layout.getComputeNodePanel().getHmmComputeNodePanel().refreshUseSameAllNodeCheckBoxEnabledStatus(false);
                    HmmDeviceAddDialog.this.layout.getComputeNodePanel().refreshComputeNodeEnableStatus(false);
                } else {
                    HmmDeviceAddDialog.this.layout.getComputeNodePanel().getHmmComputeNodePanel().refreshUseSameAllNodeCheckBoxEnabledStatus(true);
                    HmmDeviceAddDialog.this.layout.getComputeNodePanel().refreshComputeNodeInfo("22/161/443/623", "", "", "");
                    HmmDeviceAddDialog.this.layout.getComputeNodePanel().refreshComputeNodeEnableStatus(true);
                }
            }
        });
    }

    private String buildComputeNodePortInfo() {
        StringBuilder portValues = new StringBuilder(this.layout.getSshSfipPortField().getText());
        portValues.append("/");
        portValues.append(this.layout.getSnmpPortField().getText());
        portValues.append("/");
        portValues.append(this.layout.getRedfishPortPortField().getText());
        portValues.append("/");
        portValues.append(this.layout.getIpmiPortField().getText());
        return portValues.toString();
    }

    private void confirmBtnActionListener() {
        this.layout.getConfirmBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!HmmDeviceAddDialog.this.isPassDeviceInfoCheck()) {
                    return;
                }
                HmmDeviceAddDialog.this.findDevice();
            }
        });
    }

    private void checkPortBtnActionListener() {
        this.layout.getCheckPortBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!HmmDeviceAddDialog.this.isPassDeviceInfoCheck()) {
                    return;
                }
                HmmDeviceAddDialog.this.checkPort();
            }
        });
    }

    private boolean isPassDeviceInfoCheck() {
        String checkFieldValueResult = this.checkFieldValue();
        if (!StringUtils.isNULLStr((String)checkFieldValueResult)) {
            this.layout.getTipLabel().setText(checkFieldValueResult);
            this.layout.getTipLabel().setForeground(Color.RED);
            this.layout.repaint();
            log.error("device info check not passed: {}", (Object)checkFieldValueResult);
            return false;
        }
        String checkComputeFieldValueResult = this.checkComputeFieldValue();
        if (!StringUtils.isNULLStr((String)checkComputeFieldValueResult)) {
            this.layout.getTipLabel().setText(checkComputeFieldValueResult);
            this.layout.getTipLabel().setForeground(Color.RED);
            this.layout.repaint();
            log.error("device info check not passed: {}", (Object)checkComputeFieldValueResult);
            return false;
        }
        return true;
    }

    private void checkPort() {
        this.setVisible(false);
        this.dispose();
        HwServerDevice serverDev = this.getHwServerDevice();
        this.addComputeNodeToDevice(serverDev);
        serverDev.setItDeviceType(ITDeviceType.SERVER_HMM);
        this.hwServerDevs.add(serverDev);
        BatchPortsCheckDialog batchPortsCheckDialog = new BatchPortsCheckDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.check.port.title"));
        AsyncExcutor.submit((Runnable)new CheckPortThread(this.hwServerDevs, batchPortsCheckDialog));
    }

    private void cancelBtnActionListener() {
        this.layout.getCancelBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HmmDeviceAddDialog.this.cancelAction();
            }
        });
    }

    private void computeNodeLinkClickListener() {
        this.layout.getComputeNodeLink().addClickListener(new ToolHyperLinkLabel.ClickListener(){

            @Override
            public void clickLink(MouseEvent me) {
                if (HmmDeviceAddDialog.this.layout.isShowComputeNodeFlag()) {
                    HmmDeviceAddDialog.this.layout.getComputeNodePanel().setVisible(true);
                    HmmDeviceAddDialog.this.layout.getComputeNodeLink().setIcon(ResourceUtil.getImage((String)"icon-arrow-lg-top.png"));
                    HmmDeviceAddDialog.this.layout.setShowComputeNodeFlag(false);
                    HmmDeviceAddDialog.this.dialogHigh = HmmDeviceAddDialog.this.dialogHigh + 200;
                    HmmDeviceAddDialog.this.setSize(new Dimension((int)HmmDeviceAddDialog.this.size.getWidth(), HmmDeviceAddDialog.this.dialogHigh));
                    if (!HmmDeviceAddDialog.this.layout.isShowSwitchPanelFlag()) {
                        HmmDeviceAddDialog.this.layout.setShowSwitchPanelFlag(false);
                        HmmDeviceAddDialog.this.hideSwPanel();
                    }
                } else {
                    HmmDeviceAddDialog.this.hideComputeNodePanel();
                }
            }
        });
    }

    private void swCheckLinkClickListener() {
        this.layout.getSwCheckLink().addClickListener(new ToolHyperLinkLabel.ClickListener(){
            private static final long serialVersionUID = -5870151946136294514L;

            @Override
            public void clickLink(MouseEvent me) {
                if (HmmDeviceAddDialog.this.layout.isShowSwitchPanelFlag()) {
                    HmmDeviceAddDialog.this.layout.getSwPanel().setVisible(true);
                    HmmDeviceAddDialog.this.layout.getSwCheckLink().setIcon(ResourceUtil.getImage((String)"icon-arrow-lg-top.png"));
                    HmmDeviceAddDialog.this.layout.setShowSwitchPanelFlag(false);
                    HmmDeviceAddDialog.this.dialogHigh = HmmDeviceAddDialog.this.dialogHigh + 200;
                    HmmDeviceAddDialog.this.setSize(new Dimension((int)HmmDeviceAddDialog.this.size.getWidth(), HmmDeviceAddDialog.this.dialogHigh));
                    if (!HmmDeviceAddDialog.this.layout.isShowComputeNodeFlag()) {
                        HmmDeviceAddDialog.this.layout.setShowComputeNodeFlag(false);
                        HmmDeviceAddDialog.this.hideComputeNodePanel();
                    }
                } else {
                    HmmDeviceAddDialog.this.hideSwPanel();
                }
            }
        });
    }

    private void osCheckLinkClickListener() {
        this.layout.getOsCheckLink().addClickListener(new ToolHyperLinkLabel.ClickListener(){
            private static final long serialVersionUID = 9056520409012561148L;

            @Override
            public void clickLink(MouseEvent me) {
                if (HmmDeviceAddDialog.this.layout.isShowOsPanelFlag()) {
                    HmmDeviceAddDialog.this.layout.getOsInfoPanel().setVisible(true);
                    HmmDeviceAddDialog.this.layout.getOsCheckLink().setIcon(ResourceUtil.getImage((String)"icon-arrow-lg-top.png"));
                    HmmDeviceAddDialog.this.layout.setShowOsPanelFlag(false);
                    HmmDeviceAddDialog.this.dialogHigh = (int)((double)HmmDeviceAddDialog.this.dialogHigh + HmmDeviceAddDialog.this.layout.getOsContentSize().getHeight());
                    HmmDeviceAddDialog.this.setSize(new Dimension((int)HmmDeviceAddDialog.this.size.getWidth(), HmmDeviceAddDialog.this.dialogHigh));
                } else {
                    HmmDeviceAddDialog.this.layout.getOsInfoPanel().setVisible(false);
                    HmmDeviceAddDialog.this.layout.getOsCheckLink().setIcon(ResourceUtil.getImage((String)"icon-arrow-lg-down.png"));
                    HmmDeviceAddDialog.this.layout.setShowOsPanelFlag(true);
                    HmmDeviceAddDialog.this.dialogHigh = (int)((double)HmmDeviceAddDialog.this.dialogHigh - HmmDeviceAddDialog.this.layout.getOsContentSize().getHeight());
                    HmmDeviceAddDialog.this.setSize(new Dimension((int)HmmDeviceAddDialog.this.size.getWidth(), HmmDeviceAddDialog.this.dialogHigh));
                }
            }
        });
    }

    private void highCheckLinkClickListener() {
        this.layout.getHighCheckLink().addClickListener(new ToolHyperLinkLabel.ClickListener(){
            private static final long serialVersionUID = -5870151946136294514L;

            @Override
            public void clickLink(MouseEvent me) {
                if (HmmDeviceAddDialog.this.layout.isShowHighPanelFlag()) {
                    HmmDeviceAddDialog.this.layout.getHighInfoPanel().setVisible(true);
                    HmmDeviceAddDialog.this.layout.getHighCheckLink().setIcon(ResourceUtil.getImage((String)"icon-arrow-lg-top.png"));
                    HmmDeviceAddDialog.this.layout.setShowHighPanelFlag(false);
                    HmmDeviceAddDialog.this.dialogHigh = (int)((double)HmmDeviceAddDialog.this.dialogHigh + HmmDeviceAddDialog.this.layout.getHighContentSize().getHeight());
                    HmmDeviceAddDialog.this.setSize(new Dimension((int)HmmDeviceAddDialog.this.size.getWidth(), HmmDeviceAddDialog.this.dialogHigh));
                } else {
                    HmmDeviceAddDialog.this.layout.getHighCheckLink().setIcon(ResourceUtil.getImage((String)"icon-arrow-lg-down.png"));
                    HmmDeviceAddDialog.this.layout.setShowHighPanelFlag(true);
                    HmmDeviceAddDialog.this.layout.getHighInfoPanel().setVisible(false);
                    HmmDeviceAddDialog.this.dialogHigh = (int)((double)HmmDeviceAddDialog.this.dialogHigh - HmmDeviceAddDialog.this.layout.getHighContentSize().getHeight());
                    HmmDeviceAddDialog.this.setSize(new Dimension((int)HmmDeviceAddDialog.this.size.getWidth(), HmmDeviceAddDialog.this.dialogHigh));
                }
            }
        });
    }

    private String checkPort(String port, int slotId) {
        String[] portArr = port.split("/");
        if (portArr.length != 4) {
            return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.hmm.nodeport.formaterror", (Object[])new Object[]{slotId});
        }
        for (int i = 0; i < 4; ++i) {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)portArr[i].trim())) {
                return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.hmm.nodeport.notnull", (Object[])new Object[]{slotId});
            }
            if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)portArr[i])) {
                return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.hmm.nodeport.notnum", (Object[])new Object[]{slotId});
            }
            try {
                int portNum = Integer.valueOf(portArr[i]);
                if (SmartkitUtils.isPortLegal(portNum)) continue;
                return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.hmm.nodeport.beyond", (Object[])new Object[]{slotId});
            }
            catch (NumberFormatException e) {
                return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.hmm.nodeport.beyond", (Object[])new Object[]{slotId});
            }
        }
        return "";
    }

    private String checkComputeFieldValue() {
        String message = "";
        if (this.layout.getComputeNodePanel().getHmmComputeNodePanel().getUseSameAllNodeCbx().isSelected()) {
            String port = this.layout.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeApplyToOtherPanel().getPort().getText();
            String nodeUserName = this.layout.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeApplyToOtherPanel().getUserName().getText();
            String nodePW = String.valueOf(this.layout.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeApplyToOtherPanel().getPassword().getPassword());
            if (StringUtils.isNULLStr((String)nodeUserName) && StringUtils.isNULLStr((String)nodePW)) {
                return "";
            }
            if (StringUtils.isNULLStr((String)nodeUserName) || StringUtils.isNULLStr((String)nodePW)) {
                return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.hmm.nodeslot.error", (Object[])new Object[]{1});
            }
            if (StringUtils.isNULLStr((String)port)) {
                return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.hmm.nodeport.notnull", (Object[])new Object[]{1});
            }
            message = this.checkPort(port, 1);
            if (!StringUtils.isNULLStr((String)message)) {
                return message;
            }
            this.isUseNodePlate = true;
            this.isApplyToOtherNode = true;
            return message;
        }
        message = this.checkMultipleNodeValue();
        if (StringUtils.isNULLStr((String)message)) {
            this.isUseNodePlate = true;
            this.isApplyToOtherNode = false;
        }
        return message;
    }

    private String checkMultipleNodeValue() {
        String mes = "";
        Map<Integer, ComputeNodeEntity> nodeEntityMap = this.layout.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeLayout().getComputeNodeContentLayout().getNodeEntityMap();
        for (int i = 1; i < 33; ++i) {
            ComputeNodeEntity nodeEntity = nodeEntityMap.get(i);
            String port = nodeEntity.getPort().getText();
            String userName = nodeEntity.getUserName().getText();
            String passWord = String.valueOf(nodeEntity.getPassword().getPassword());
            if (StringUtils.isNULLStr((String)userName) && StringUtils.isNULLStr((String)passWord)) continue;
            if (StringUtils.isNULLStr((String)userName) || StringUtils.isNULLStr((String)passWord)) {
                return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.hmm.nodeslot.error", (Object[])new Object[]{i});
            }
            if (StringUtils.isNULLStr((String)port)) {
                return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.hmm.nodeport.notnull", (Object[])new Object[]{i});
            }
            mes = this.checkPort(port, i);
            if (!StringUtils.isNULLStr((String)mes)) {
                return mes;
            }
            this.nodeList.add(nodeEntity);
        }
        return mes;
    }

    private void initListener() {
        this.setSize(new Dimension((int)this.size.getWidth(), this.dialogHigh));
        this.initIpAboutListener();
        this.initCheckAboutListener();
        this.initAccountDecoupListener();
    }

    private void cancelAction() {
        this.setVisible(false);
        this.dispose();
    }

    private String checkFieldValue() {
        String mustMessage = this.checkNullField();
        if (!StringUtils.isNULLStr((String)mustMessage)) {
            return mustMessage;
        }
        String userNameCheckMsg = this.checkUserNameOfSwPanel();
        if (!StringUtils.isNULLStr((String)userNameCheckMsg)) {
            return userNameCheckMsg;
        }
        String pwdLenCheckMessge = this.checkPwdValueLen();
        if (!StringUtils.isNULLStr((String)pwdLenCheckMessge)) {
            return pwdLenCheckMessge;
        }
        String ipMessage = LayUtil.checkIpAddress(this.layout);
        if (!StringUtils.isNULLStr((String)ipMessage)) {
            return ipMessage;
        }
        String portMessage = LayUtil.checkPort(this.layout);
        if (!StringUtils.isNULLStr((String)portMessage)) {
            return portMessage;
        }
        return "";
    }

    private String checkUserNameOfSwPanel() {
        String checkMsg = "";
        List<SwPanelUserNameCheckInfo> swPanelUserNameCheckInfoList = this.getSwPanelUserNameCheckInfos();
        for (SwPanelUserNameCheckInfo swPanelModule1EUserNameCheckInfo : swPanelUserNameCheckInfoList) {
            if (this.isUserNameOfSwPanelCheckFailed(swPanelModule1EUserNameCheckInfo.getFabricSolPwd().getPassword(), swPanelModule1EUserNameCheckInfo.getFabricSolName().getText())) {
                checkMsg = this.buildUserNameCheckTip(swPanelModule1EUserNameCheckInfo.getSwModuleName(), "smartkit.devicemanager.layout.addDev.hmm.fabricPlane", "smartkit.devicemanager.layout.addDev.hmm.solUserName");
                return checkMsg;
            }
            if (this.isUserNameOfSwPanelCheckFailed(swPanelModule1EUserNameCheckInfo.getBaseSolPwd().getPassword(), swPanelModule1EUserNameCheckInfo.getBaseSolName().getText())) {
                checkMsg = this.buildUserNameCheckTip(swPanelModule1EUserNameCheckInfo.getSwModuleName(), "smartkit.devicemanager.layout.addDev.hmm.basePlane", "smartkit.devicemanager.layout.addDev.hmm.solUserName");
                return checkMsg;
            }
            if (this.isUserNameOfSwPanelCheckFailed(swPanelModule1EUserNameCheckInfo.getFcSolPwd().getPassword(), swPanelModule1EUserNameCheckInfo.getFcSolName().getText())) {
                checkMsg = this.buildUserNameCheckTip(swPanelModule1EUserNameCheckInfo.getSwModuleName(), "smartkit.devicemanager.layout.addDev.hmm.fcPlane", "smartkit.devicemanager.layout.addDev.hmm.solUserName");
                return checkMsg;
            }
            if (!this.isUserNameOfSwPanelCheckFailed(swPanelModule1EUserNameCheckInfo.getBmcSolPwd().getPassword(), swPanelModule1EUserNameCheckInfo.getBmcSolName().getText())) continue;
            checkMsg = this.buildUserNameCheckTip(swPanelModule1EUserNameCheckInfo.getSwModuleName(), "smartkit.devicemanager.layout.addDev.hmm.bmcPlane", "smartkit.devicemanager.layout.addDev.userName");
            return checkMsg;
        }
        return "";
    }

    private boolean isUserNameOfSwPanelCheckFailed(char[] pwds, String userName) {
        return pwds.length > 0 && VerifyUtil.isEmpty((String)userName);
    }

    private String buildUserNameCheckTip(String moduleName, String planeName, String fieldName) {
        return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.swPanel.pwd.check.info", (Object[])new Object[]{moduleName, ResourceUtil.getString((String)planeName), ResourceUtil.getString((String)fieldName)});
    }

    private List<SwPanelUserNameCheckInfo> getSwPanelUserNameCheckInfos() {
        ArrayList<SwPanelUserNameCheckInfo> list = new ArrayList<SwPanelUserNameCheckInfo>();
        Map<String, SwitchChooseContentLayout> swModulecontents = this.layout.getSwPanel().getSwContents();
        for (String swModuleKey : swModuleKeys) {
            SwPanelUserNameCheckInfo swPanelModule1EUserNameCheckInfo = new SwPanelUserNameCheckInfo();
            swPanelModule1EUserNameCheckInfo.setSwModuleName(swModuleKey);
            swPanelModule1EUserNameCheckInfo.setFabricSolName(swModulecontents.get(swModuleKey).getFbsqlUserNameField());
            swPanelModule1EUserNameCheckInfo.setFabricSolPwd(swModulecontents.get(swModuleKey).getFbsqlPwdField());
            swPanelModule1EUserNameCheckInfo.setBaseSolName(swModulecontents.get(swModuleKey).getBaseSolUserNameField());
            swPanelModule1EUserNameCheckInfo.setBaseSolPwd(swModulecontents.get(swModuleKey).getBaseSqlPwdField());
            swPanelModule1EUserNameCheckInfo.setFcSolName(swModulecontents.get(swModuleKey).getFcSolUserNameField());
            swPanelModule1EUserNameCheckInfo.setFcSolPwd(swModulecontents.get(swModuleKey).getFcSqlPwdField());
            swPanelModule1EUserNameCheckInfo.setBmcSolName(swModulecontents.get(swModuleKey).getBmcUserNameField());
            swPanelModule1EUserNameCheckInfo.setBmcSolPwd(swModulecontents.get(swModuleKey).getBmcPwdField());
            list.add(swPanelModule1EUserNameCheckInfo);
        }
        return list;
    }

    private String checkPwdValueLen() {
        LinkedList<char[]> pwdsWaitChecks = new LinkedList<char[]>();
        pwdsWaitChecks.add(this.layout.getKeypwdField().getPassword());
        pwdsWaitChecks.add(this.layout.getSnmpv3PwdField().getPassword());
        pwdsWaitChecks.add(this.layout.getRootPwdField().getPassword());
        Map<String, SwitchChooseContentLayout> swModulecontents = this.layout.getSwPanel().getSwContents();
        for (String swModuleKey : swModuleKeys) {
            pwdsWaitChecks.add(swModulecontents.get(swModuleKey).getFbsqlPwdField().getPassword());
            pwdsWaitChecks.add(swModulecontents.get(swModuleKey).getBaseSqlPwdField().getPassword());
            pwdsWaitChecks.add(swModulecontents.get(swModuleKey).getFcSqlPwdField().getPassword());
            pwdsWaitChecks.add(swModulecontents.get(swModuleKey).getBmcPwdField().getPassword());
        }
        Map<Integer, ComputeNodeEntity> nodeEntityMap = this.layout.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeLayout().getComputeNodeContentLayout().getNodeEntityMap();
        for (ComputeNodeEntity nodeEntity : nodeEntityMap.values()) {
            pwdsWaitChecks.add(nodeEntity.getPassword().getPassword());
            pwdsWaitChecks.add(nodeEntity.getSnmpPassword().getPassword());
        }
        pwdsWaitChecks.add(this.layout.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeApplyToOtherPanel().getPassword().getPassword());
        pwdsWaitChecks.add(this.layout.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeApplyToOtherPanel().getSnmpPassword().getPassword());
        for (char[] pds : pwdsWaitChecks) {
            if (0 >= pds.length || pds.length >= DeviceCenterContext.getServerPwdMinLen()) continue;
            return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.pwd.max.len.tip", (Object[])new Object[]{DeviceCenterContext.getServerPwdMinLen()});
        }
        return "";
    }

    private String checkNullField() {
        LinkedHashMap<Object, String> mandatoryCompMap = new LinkedHashMap<Object, String>();
        mandatoryCompMap.put(this.layout.getStartIpAddress(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.startIp"));
        mandatoryCompMap.put(this.layout.getEndIpField(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.endIp"));
        mandatoryCompMap.put(this.layout.getUserNameField(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.userName"));
        mandatoryCompMap.put(this.layout.getKeypwdField(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.pwd"));
        mandatoryCompMap.put(this.layout.getSnmpPortField(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.snmpPort"));
        mandatoryCompMap.put(this.layout.getIpmiPortField(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.ipmiPort"));
        mandatoryCompMap.put(this.layout.getSshSfipPortField(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.sshSfipPort"));
        mandatoryCompMap.put(this.layout.getVMPortField(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.vmPort"));
        mandatoryCompMap.put(this.layout.getRedfishPortPortField(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.redfishPort"));
        if (this.layout.getDecouplingSelectRadioBtn().isSelected()) {
            mandatoryCompMap.put(this.layout.getRedFishUserNameTextField(), ResourceUtil.getString((String)"device.add.ui.is.support.account.decoupling.redfish.username"));
            mandatoryCompMap.put(this.layout.getRedFishPwdField(), ResourceUtil.getString((String)"device.add.ui.is.support.account.decoupling.redfish.pwd"));
        }
        for (JComponent key : mandatoryCompMap.keySet()) {
            JPasswordField pwdField;
            IsmTextField textField;
            if (key instanceof IsmTextField && StringUtils.isNULLStr((String)(textField = (IsmTextField)key).getText())) {
                return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{mandatoryCompMap.get(key)});
            }
            if (!(key instanceof JPasswordField) || !StringUtils.isNULLStr((String)String.valueOf((pwdField = (JPasswordField)key).getPassword()))) continue;
            return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{mandatoryCompMap.get(key)});
        }
        return "";
    }

    @Override
    public void findDevice() {
        this.setVisible(false);
        this.dispose();
        HwServerDevice serverDev = this.getHwServerDevice();
        try {
            int i = 1;
            while (i <= 4) {
                i = this.getSomeParam(serverDev, i);
            }
        }
        catch (Exception e) {
            log.error("reflect error", (Object)e.getMessage());
        }
        this.addComputeNodeToDevice(serverDev);
        if (null != this.getDevInitHwServer() && serverDev.equals(this.getDevInitHwServer())) {
            return;
        }
        serverDev.setItDeviceType(ITDeviceType.SERVER_HMM);
        this.hwServerDevs.add(serverDev);
        BatchImportInfoDialog importDialog = null;
        if (this.getTitle().equalsIgnoreCase(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.title"))) {
            importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.title"));
        } else if (this.getTitle().equalsIgnoreCase(ResourceUtil.getString((String)"smartkit.devicemanager.layout.modifyDev.title"))) {
            importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.modifyDev.title"));
        }
        if (null != importDialog) {
            SmartkitUtils.addBatchImportDialog(importDialog, this.listenerTables);
        }
        Future<?> future = this.getFindDeviceThreadFuture();
        log.info("the result of the task is: {}", (Object)future.isDone());
    }

    public void hideSwComputePanel() {
        this.layout.getSwPanel().setVisible(false);
        this.layout.getSwCheckLink().setVisible(false);
        this.layout.getComputeNodePanel().setVisible(false);
        this.layout.getComputeNodeLink().setVisible(false);
        this.layout.getSwChooseTip().setVisible(false);
        this.layout.getComputeNodeTip().setVisible(false);
        this.setSize(new Dimension((int)this.size.getWidth(), this.dialogHigh));
    }

    private int getSomeParam(HwServerDevice serverDev, int i) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        SwitchPlate swPlate = new SwitchPlate();
        HmmSwitchChoosePanel swContent = this.layout.getSwPanel();
        Class<?> swContentClazz = swContent.getClass();
        String getSwContentMethodName = "getSwContent" + i;
        Method getSwContentMethod = swContentClazz.getMethod(getSwContentMethodName, new Class[0]);
        SwitchChooseContentLayout swChooseLay = (SwitchChooseContentLayout)getSwContentMethod.invoke((Object)swContent, new Object[0]);
        String swFbSolUserName = swChooseLay.getFbsolUserNameField().getText();
        String sw2FbSolPwd = String.valueOf(swChooseLay.getFbsolPwdField().getPassword());
        swPlate.setFabricUserName(swFbSolUserName);
        swPlate.setFabricPwd(sw2FbSolPwd);
        String sw2BaseUserName = swChooseLay.getBaseSolUserNameField().getText();
        String sw2BasePwd = String.valueOf(swChooseLay.getBaseSolPwdField().getPassword());
        swPlate.setBaseUserName(sw2BaseUserName);
        swPlate.setBasePwd(sw2BasePwd);
        String sw2FcUserName = swChooseLay.getFcSolUserNameField().getText();
        String sw2FcPwd = String.valueOf(swChooseLay.getFcSqlPwdField().getPassword());
        swPlate.setFcUserName(sw2FcUserName);
        swPlate.setFcPwd(sw2FcPwd);
        String sw2BmcUserName = swChooseLay.getBmcUserNameField().getText();
        String sw2BmcPwd = String.valueOf(swChooseLay.getBmcPwdField().getPassword());
        swPlate.setBmcUserName(sw2BmcUserName);
        swPlate.setBmcPwd(sw2BmcPwd);
        return this.getServerDevPanelValue(serverDev, i, swPlate);
    }

    private Future<?> getFindDeviceThreadFuture() {
        Runnable findDeviceThread = new Runnable(){

            @Override
            public void run() {
                DeviceControl.getInstance().initDriverFile();
                HmmDeviceAddDialog.this.exportResult = DeviceControl.getInstance().importDevices(HmmDeviceAddDialog.this.hwServerDevs, HmmDeviceAddDialog.this.listenerTables);
                DeviceControl.getInstance().refreshFile();
                if (TaskResult.Result.SUCCESS.equals((Object)HmmDeviceAddDialog.this.exportResult.getResult())) {
                    log.info("find the device success.");
                } else {
                    log.info("find the device failed.");
                }
            }
        };
        return Executors.newSingleThreadExecutor().submit(findDeviceThread);
    }

    private HwServerDevice getHwServerDevice() {
        HwServerDevice serverDev = new HwServerDevice();
        serverDev.setStartIPAddress(this.layout.getStartIpAddress().getText());
        serverDev.setEndIPAddress(this.layout.getEndIpField().getText());
        serverDev.setUserName(this.layout.getUserNameField().getText());
        String userPwd = String.valueOf(this.layout.getKeypwdField().getPassword());
        serverDev.setUserPwd(userPwd);
        serverDev.setSnmpPrivPwd(String.valueOf(this.layout.getSnmpv3PwdField().getPassword()));
        serverDev.setSnmpPort(Integer.valueOf(this.layout.getSnmpPortField().getText()));
        serverDev.setSshPort(Integer.valueOf(this.layout.getSshSfipPortField().getText()));
        serverDev.setIpmiPort(Integer.valueOf(this.layout.getIpmiPortField().getText()));
        serverDev.setVmmPort(Integer.valueOf(this.layout.getVMPortField().getText()));
        serverDev.setRedFishPort(this.layout.getRedfishPortPortField().getText());
        serverDev.setCommunity(this.layout.getWriteCommunityPortField().getText());
        serverDev.setOnlySecurityAlgSupportedFlag(!this.layout.getEncryptionCheck().isSelected());
        serverDev.setRootPwd(String.valueOf(this.layout.getRootPwdField().getPassword()));
        serverDev.setRedFishUserName(this.layout.getRedFishUserNameTextField().getText());
        serverDev.setRedFishPwd(String.valueOf(this.layout.getRedFishPwdField().getPassword()));
        serverDev.setSupportAccountSeparation(this.layout.getDecouplingSelectRadioBtn().isSelected());
        if (this.layout.getPortproxyRadio().getModel().isSelected()) {
            serverDev.setPortProxy(true);
        }
        return serverDev;
    }

    private void addComputeNodeToDevice(HwServerDevice serverDev) {
        if (this.isUseNodePlate) {
            if (this.isApplyToOtherNode) {
                serverDev.setApplyToOtherNodes(true);
                this.setComputeNodeApplyToOther(serverDev);
            } else {
                serverDev.setApplyToOtherNodes(false);
                for (ComputeNodeEntity entity : this.nodeList) {
                    ComputeNodePlate computeNodePlate = new ComputeNodePlate();
                    computeNodePlate.setSlotId(entity.getSlot().getText());
                    String[] nodePort = entity.getPort().getText().split("/");
                    computeNodePlate.setSlotSSHPort(nodePort[0]);
                    computeNodePlate.setSlotSNMPPort(nodePort[1]);
                    computeNodePlate.setSlotHttpsPort(nodePort[2]);
                    computeNodePlate.setSlotIPMIPort(nodePort[3]);
                    computeNodePlate.setSlotUser(entity.getUserName().getText());
                    computeNodePlate.setSlotPasswd(String.valueOf(entity.getPassword().getPassword()));
                    computeNodePlate.setSlotSnmpPrivPwd(String.valueOf(entity.getSnmpPassword().getPassword()));
                    serverDev.getComputeNodePlateList().add(computeNodePlate);
                }
            }
        }
    }

    private void setComputeNodeApplyToOther(HwServerDevice serverDev) {
        String port = this.layout.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeApplyToOtherPanel().getPort().getText();
        String nodeUserName = this.layout.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeApplyToOtherPanel().getUserName().getText();
        String nodePW = String.valueOf(this.layout.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeApplyToOtherPanel().getPassword().getPassword());
        String nodeSnmpPrivPw = String.valueOf(this.layout.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeApplyToOtherPanel().getSnmpPassword().getPassword());
        String[] nodePort = port.split("/");
        ComputeNodePlate computeNodePlate = new ComputeNodePlate();
        computeNodePlate.setSlotId("1");
        computeNodePlate.setSlotSSHPort(nodePort[0]);
        computeNodePlate.setSlotSNMPPort(nodePort[1]);
        computeNodePlate.setSlotHttpsPort(nodePort[2]);
        computeNodePlate.setSlotIPMIPort(nodePort[3]);
        computeNodePlate.setSlotUser(nodeUserName);
        computeNodePlate.setSlotPasswd(nodePW);
        computeNodePlate.setSlotSnmpPrivPwd(nodeSnmpPrivPw);
        serverDev.getComputeNodePlateList().add(computeNodePlate);
    }

    private int getServerDevPanelValue(HwServerDevice serverDev, int i, SwitchPlate swPlate) {
        int result;
        if (this.layout.getSwPanel().getSwContent1().getUseSameAllSwCbx().isSelected()) {
            for (result = i; result <= 4; ++result) {
                if (swPlate.isSwitchPlateEmpty()) continue;
                serverDev.getSwitchPlateMap().put("switch_plate" + result, swPlate);
            }
        } else {
            if (!swPlate.isSwitchPlateEmpty()) {
                serverDev.getSwitchPlateMap().put("switch_plate" + result, swPlate);
            }
            ++result;
        }
        return result;
    }

    public void setDevInitHwServer(HwServerDevice devInitHwServer) {
        this.devInitHwServer = devInitHwServer;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public HwServerDevice getDevInitHwServer() {
        return this.devInitHwServer;
    }

    private class SwPanelUserNameCheckInfo {
        private String swModuleName;
        private IsmTextField fabricSolName;
        private JPasswordField fabricSolPwd;
        private IsmTextField baseSolName;
        private JPasswordField baseSolPwd;
        private IsmTextField fcSolName;
        private JPasswordField fcSolPwd;
        private IsmTextField bmcSolName;
        private JPasswordField bmcSolPwd;

        private SwPanelUserNameCheckInfo() {
        }

        public String getSwModuleName() {
            return this.swModuleName;
        }

        public void setSwModuleName(String swModuleName) {
            this.swModuleName = swModuleName;
        }

        public IsmTextField getFabricSolName() {
            return this.fabricSolName;
        }

        public void setFabricSolName(IsmTextField fabricSolName) {
            this.fabricSolName = fabricSolName;
        }

        public JPasswordField getFabricSolPwd() {
            return this.fabricSolPwd;
        }

        public void setFabricSolPwd(JPasswordField fabricSolPwd) {
            this.fabricSolPwd = fabricSolPwd;
        }

        public IsmTextField getBaseSolName() {
            return this.baseSolName;
        }

        public void setBaseSolName(IsmTextField baseSolName) {
            this.baseSolName = baseSolName;
        }

        public JPasswordField getBaseSolPwd() {
            return this.baseSolPwd;
        }

        public void setBaseSolPwd(JPasswordField baseSolPwd) {
            this.baseSolPwd = baseSolPwd;
        }

        public IsmTextField getFcSolName() {
            return this.fcSolName;
        }

        public void setFcSolName(IsmTextField fcSolName) {
            this.fcSolName = fcSolName;
        }

        public JPasswordField getFcSolPwd() {
            return this.fcSolPwd;
        }

        public void setFcSolPwd(JPasswordField fcSolPwd) {
            this.fcSolPwd = fcSolPwd;
        }

        public IsmTextField getBmcSolName() {
            return this.bmcSolName;
        }

        public void setBmcSolName(IsmTextField bmcSolName) {
            this.bmcSolName = bmcSolName;
        }

        public JPasswordField getBmcSolPwd() {
            return this.bmcSolPwd;
        }

        public void setBmcSolPwd(JPasswordField bmcSolPwd) {
            this.bmcSolPwd = bmcSolPwd;
        }
    }
}

