/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.service.DeviceControl;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.service.SingleDeviceAddInterface;
import com.huawei.ism.tool.devicecenter.ui.dialog.BatchImportInfoDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.SshForwardDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.OsDeviceAddLayout;
import com.huawei.ism.tool.devicecenter.utils.LayUtil;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.devicemanager.service.SettingService;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class OsDeviceAddDialog
extends JDialog
implements SingleDeviceAddInterface {
    private static final long serialVersionUID = 1980940408395271375L;
    private static final String TIPS = "The first two IP network segments of the start IP address are different fr...";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(OsDeviceAddDialog.class);
    private Dimension size = new Dimension(420, 270);
    private Dimension sizeModify = new Dimension(420, 250);
    private OsDeviceAddLayout layout;
    private List<IImportListener> listenerTables = DeviceCenterContext.getInstance().getDeviceTables().get("deviceTables");
    private List<AbstractDevice> hwServerDevs = new ArrayList<AbstractDevice>();
    private TaskResult exportResult = null;
    private HwServerDevice devInitHwServer;
    private boolean isIesModifyFlag = false;
    private Map<String, String> fsIpMap = new HashMap<String, String>();
    private boolean isFusionStorage = false;
    private boolean isExcelImport = false;
    private boolean isSupportSshForward = false;

    public OsDeviceAddDialog(OsDeviceAddLayout lay) {
        this.layout = lay;
        this.setTitle(ResourceUtil.getString((String)"smartkit.devicemanager.layout.modifyDev.title"));
        this.setSize(this.sizeModify);
        this.initDialog();
    }

    public OsDeviceAddDialog() {
        this.layout = new OsDeviceAddLayout(true);
        this.setTitle(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.title"));
        this.setSize(this.size);
        this.initDialog();
    }

    public OsDeviceAddDialog(OsDeviceAddLayout lay, Map<String, String> fsIpMap, boolean isSupportSshForward) {
        this.fsIpMap = fsIpMap;
        this.isFusionStorage = true;
        this.layout = lay;
        this.isSupportSshForward = isSupportSshForward;
        this.layout.initSshRouteList();
        this.setTitle(ResourceUtil.getString((String)"smartkit.devicemanager.layout.modifyDev.title"));
        this.setSize(this.sizeModify);
        this.initDialog();
    }

    private void initDialog() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.layout, "Center");
        this.setModal(true);
        this.setResizable(false);
        this.initListener();
    }

    private void initListener() {
        this.cancelBtnActionListener();
        this.confirmBtnActionListener();
        this.startIpAddressMouseListener();
        this.endIpFieldMouseListener();
        this.userNameFieldMouseListener();
        this.layout.getPwdField().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                OsDeviceAddDialog.this.showNotRootTipJudge();
            }
        });
        this.layout.getRootPwdField().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                OsDeviceAddDialog.this.showNotRootTipJudge();
            }
        });
        this.initUserNameFieldKeyListener();
        this.initSshForwardListener();
    }

    private void initSshForwardListener() {
        this.layout.getSshCfgLink().addClickListener(event -> this.openSshForwardDialog());
    }

    private void openSshForwardDialog() {
        SshForwardDialog sshForwardDialog = new SshForwardDialog(this);
        SwingUtil.putParentCenter((Window)sshForwardDialog, (Window)this);
        sshForwardDialog.setVisible(true);
    }

    public void initSshForward() {
        this.layout.initSshRouteList();
        this.layout.setDefaultSshForward();
    }

    private void initUserNameFieldKeyListener() {
        this.layout.getUserNameField().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                OsDeviceAddDialog.this.showNotRootTipJudge();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                OsDeviceAddDialog.this.showNotRootTipJudge();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                OsDeviceAddDialog.this.showNotRootTipJudge();
            }
        });
    }

    private void userNameFieldMouseListener() {
        this.layout.getUserNameField().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                OsDeviceAddDialog.this.showNotRootTipJudge();
            }
        });
    }

    private void endIpFieldMouseListener() {
        this.layout.getEndIpField().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (StringUtils.isNULLStr((String)LayUtil.checkIpAddress(OsDeviceAddDialog.this.layout)) && !OsDeviceAddDialog.this.shouldShowNotRootTip()) {
                    OsDeviceAddDialog.this.setErrorTipLabelFalse();
                }
            }
        });
    }

    private void startIpAddressMouseListener() {
        this.layout.getStartIpAddress().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                String startIp = OsDeviceAddDialog.this.layout.getStartIpAddress().getText();
                if (LayUtil.checkIpForServer(startIp) && !OsDeviceAddDialog.this.shouldShowNotRootTip() && OsDeviceAddDialog.this.layout.getErrorTipLabel().getText().equals(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.startIp.invalid"))) {
                    OsDeviceAddDialog.this.setErrorTipLabelFalse();
                }
            }
        });
    }

    private void confirmBtnActionListener() {
        this.layout.getConfirmBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!StringUtils.isNULLStr((String)OsDeviceAddDialog.this.checkFieldValue())) {
                    OsDeviceAddDialog.this.layout.getErrorTipLabel().setText(OsDeviceAddDialog.this.checkFieldValue());
                    if (OsDeviceAddDialog.this.layout.getErrorTipLabel().getText().length() > 103) {
                        OsDeviceAddDialog.this.layout.getErrorTipLabel().setText(OsDeviceAddDialog.TIPS);
                        OsDeviceAddDialog.this.layout.getErrorTipLabel().setToolTipText(OsDeviceAddDialog.this.checkFieldValue());
                    }
                    OsDeviceAddDialog.this.layout.getErrorTipLabel().setForeground(Color.RED);
                    OsDeviceAddDialog.this.layout.repaint();
                    return;
                }
                OsDeviceAddDialog.this.findDevice();
            }
        });
    }

    private void cancelBtnActionListener() {
        this.layout.getCancelBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OsDeviceAddDialog.this.cancelAction();
            }
        });
    }

    private void showNotRootTipJudge() {
        if (this.isIesModifyFlag) {
            return;
        }
        if (this.shouldShowNotRootTip()) {
            this.showNotRootTip(true);
        } else {
            this.showNotRootTip(false);
        }
        this.shouldShowRootPwdComp();
    }

    private void shouldShowRootPwdComp() {
        boolean isRootName = this.isFusionStorage ? "root".equals(this.layout.getUserNameField().getText()) : "root".equalsIgnoreCase(this.layout.getUserNameField().getText().toLowerCase(Locale.ENGLISH));
        this.layout.getRootPwdComp().setVisible(!isRootName);
    }

    private void showNotRootTip(boolean isShow) {
        this.layout.getErrorTipLabel().setForeground(Color.RED);
        this.layout.getRootSymbolLabel().setForeground(new Color(16729404));
        String errTip = this.layout.getErrorTipLabel().getText();
        if (isShow) {
            this.layout.getErrorTipLabel().setText(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.layout.os.notroot.tip"));
            this.layout.getRootSymbolLabel().setText("*");
        } else if (errTip.equals(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.layout.os.notroot.tip"))) {
            this.setErrorTipLabelFalse();
        }
    }

    private void setErrorTipLabelFalse() {
        this.layout.getErrorTipLabel().setText("");
        this.layout.getRootSymbolLabel().setText("");
    }

    private boolean shouldShowNotRootTip() {
        String userName = this.layout.getUserNameField().getText();
        String rootPwd = String.valueOf(this.layout.getRootPwdField().getPassword());
        if (StringUtils.isNULLStr((String)userName)) {
            return false;
        }
        if (this.isFusionStorage) {
            return this.isRootUserFusionStorage(userName, rootPwd);
        }
        return this.isRootUserServer(userName, rootPwd);
    }

    private boolean isRootUserFusionStorage(String userName, String rootPwd) {
        if (!"root".equals(userName)) {
            return "".equals(rootPwd);
        }
        return false;
    }

    private boolean isRootUserServer(String userName, String rootPwd) {
        if (!"root".equalsIgnoreCase(userName.toLowerCase(Locale.ENGLISH))) {
            return "".equals(rootPwd);
        }
        return false;
    }

    private String checkFieldValue() {
        String ipMessage;
        String mustMessage = this.checkNullField();
        if (!StringUtils.isNULLStr((String)mustMessage)) {
            return mustMessage;
        }
        if (!this.isFusionStorage && !StringUtils.isNULLStr((String)(ipMessage = LayUtil.checkIpAddress(this.layout)))) {
            return ipMessage;
        }
        return "";
    }

    private String checkNullField() {
        String nullCheckMessage = "";
        if (!this.isFusionStorage && StringUtils.isNULLStr((String)this.layout.getStartIpAddress().getText())) {
            nullCheckMessage = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.startIp")});
            return nullCheckMessage;
        }
        if (!this.isFusionStorage && StringUtils.isNULLStr((String)this.layout.getEndIpField().getText())) {
            nullCheckMessage = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.endIp")});
            return nullCheckMessage;
        }
        if (StringUtils.isNULLStr((String)this.layout.getUserNameField().getText())) {
            nullCheckMessage = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.userName")});
            return nullCheckMessage;
        }
        String pwd = String.valueOf(String.valueOf(this.layout.getPwdField().getPassword()));
        if (null == pwd || "".equals(pwd)) {
            nullCheckMessage = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.pwd")});
            return nullCheckMessage;
        }
        String userName = this.layout.getUserNameField().getText();
        String rootPwd = String.valueOf(this.layout.getRootPwdField().getPassword());
        if (!"root".equalsIgnoreCase(userName.trim()) && "".equals(rootPwd) && !this.isIesModifyFlag) {
            nullCheckMessage = ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.layout.os.notroot.tip");
            return nullCheckMessage;
        }
        return nullCheckMessage;
    }

    private void cancelAction() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void findDevice() {
        this.setVisible(false);
        this.dispose();
        if (this.isFusionStorage) {
            this.setServersFromFsIpMap();
        } else if (!this.setServersFromLayout()) {
            return;
        }
        BatchImportInfoDialog importDialog = null;
        if (this.getTitle().equalsIgnoreCase(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.title"))) {
            importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.title"));
        } else if (this.getTitle().equalsIgnoreCase(ResourceUtil.getString((String)"smartkit.devicemanager.layout.modifyDev.title"))) {
            importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.modifyDev.title"));
        } else if (this.getTitle().equalsIgnoreCase(ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.authenticate.os"))) {
            importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.authenticate.os"));
        }
        if (null != importDialog) {
            importDialog.setFsStorage(this.isFusionStorage);
            SmartkitUtils.addBatchImportDialog(importDialog, this.listenerTables);
        }
        Runnable findDevThread = new Runnable(){

            @Override
            public void run() {
                DeviceControl.getInstance().setSupportSshForward(OsDeviceAddDialog.this.isSupportSshForward);
                DeviceControl.getInstance().initDriverFile();
                OsDeviceAddDialog.this.exportResult = OsDeviceAddDialog.this.isFusionStorage || OsDeviceAddDialog.this.layout.isFusionStorage() ? DeviceControl.getInstance().importFusionStorageDevice(OsDeviceAddDialog.this.hwServerDevs, OsDeviceAddDialog.this.listenerTables) : DeviceControl.getInstance().importDevices(OsDeviceAddDialog.this.hwServerDevs, OsDeviceAddDialog.this.listenerTables);
                DeviceControl.getInstance().refreshFile();
                if (TaskResult.Result.SUCCESS.equals((Object)OsDeviceAddDialog.this.exportResult.getResult())) {
                    LOGGER.info("find the device success.");
                } else {
                    LOGGER.info("find the device failed.");
                }
            }
        };
        Future<?> future = Executors.newSingleThreadExecutor().submit(findDevThread);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("the result of the task is: " + future.isDone());
        }
    }

    private void setServersFromFsIpMap() {
        if (this.isExcelImport) {
            return;
        }
        String routeName = this.layout.getSshRouteList().getSelectedItem().toString();
        for (String managementIp : this.fsIpMap.keySet()) {
            HwServerDevice serverDev = new HwServerDevice();
            serverDev.setStartIPAddress(managementIp);
            serverDev.setEndIPAddress(managementIp);
            serverDev.setUserName(this.layout.getUserNameField().getText());
            String userPwd = String.valueOf(this.layout.getPwdField().getPassword());
            serverDev.setUserPwd(userPwd);
            String rootPwd = String.valueOf(this.layout.getRootPwdField().getPassword());
            serverDev.setRootPwd(rootPwd);
            serverDev.setItDeviceType(ITDeviceType.SERVER_OS);
            serverDev.setIp(managementIp);
            serverDev.setSshForwardList(SettingService.getSshForwards().getOrDefault(routeName, new ArrayList()));
            this.hwServerDevs.add(serverDev);
        }
    }

    private boolean setServersFromLayout() {
        HwServerDevice serverDev = new HwServerDevice();
        serverDev.setStartIPAddress(this.layout.getStartIpAddress().getText());
        serverDev.setEndIPAddress(this.layout.getEndIpField().getText());
        serverDev.setUserName(this.layout.getUserNameField().getText());
        String userPwd = String.valueOf(this.layout.getPwdField().getPassword());
        serverDev.setUserPwd(userPwd);
        String rootPwd = String.valueOf(this.layout.getRootPwdField().getPassword());
        serverDev.setRootPwd(rootPwd);
        serverDev.setItDeviceType(ITDeviceType.SERVER_OS);
        if (null != this.getDevInitHwServer() && serverDev.equals(this.getDevInitHwServer())) {
            return false;
        }
        this.hwServerDevs.add(serverDev);
        return true;
    }

    public HwServerDevice getDevInitHwServer() {
        return this.devInitHwServer;
    }

    public void setExcelImport(boolean isExcelImport) {
        this.isExcelImport = isExcelImport;
    }

    public void setHwServerDevs(List<AbstractDevice> hwServerDevs) {
        this.hwServerDevs = hwServerDevs;
    }

    public void setDevInitHwServer(HwServerDevice devInitHwServer) {
        this.devInitHwServer = devInitHwServer;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void setIesModifyFlag(boolean iesModifyFlag) {
        this.isIesModifyFlag = iesModifyFlag;
    }
}

