/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.utils.DeviceAliasMapper;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.CMCDevice;
import com.huawei.ism.tool.devicecenter.entity.HMMDevice;
import com.huawei.ism.tool.devicecenter.entity.IBMCDevice;
import com.huawei.ism.tool.devicecenter.entity.IESDevice;
import com.huawei.ism.tool.devicecenter.entity.OsDevice;
import com.huawei.ism.tool.devicecenter.entity.SceneDevAddParam;
import com.huawei.ism.tool.devicecenter.entity.SwitchDevice;
import com.huawei.ism.tool.devicecenter.entity.TceDevice;
import com.huawei.ism.tool.devicecenter.ui.dialog.ServerManagerPanel;
import com.huawei.ism.tool.devicecenter.utils.DeviceNetCareUtil;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.devicemanager.ui.listener.DirSetupButtonListener;
import com.huawei.ism.tool.devicemanager.utils.UIUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolSceneException;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.ISceneService;
import com.huawei.ism.tool.obase.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardTitlePane;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileSystemView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerManagerDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(ServerManagerDialog.class);
    private static final long serialVersionUID = -5495100841131623433L;
    private ServerManagerPanel lay = null;
    private JButton confirmBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"device.import.impaddexp.install"), (char)'L');
    private JButton cancelBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"device.import.impaddexp.cancel"), (char)'C');
    private static final String BULK_OPERATION_CMD = "MassDevicesOperation";
    private static final int BULK_OPERATION_CHECK_THRESHOLD = 50;
    private static final int BLADE_SERVER_BULK_THRESHOLD = 1;
    public final WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();
    private int confirmGap = 460;
    private IsmTextField savePathText = null;
    private JComponent savePathLabel = null;
    private JButton setPathButton = null;
    private boolean clickCancelFlag = false;
    private String helpDoc = "";
    private String settingDir = "";
    private String tableCanEdit = "";
    private boolean onlyOneCanFlag = false;

    public ServerManagerDialog(Window parent, SceneDevAddParam param) {
        super(parent);
        this.helpDoc = param.getHelpDocId();
        this.settingDir = param.getSettingDir();
        this.tableCanEdit = param.getTableEditAvailable();
        this.onlyOneCanFlag = "single".equalsIgnoreCase(param.getSelectMode());
        this.lay = new ServerManagerPanel(true, this.createSupportType(param.getDevTypes()), this.onlyOneCanFlag);
        this.setTitle(ResourceUtil.getString((String)"smartkit.devicemanager.layout.scene.device.select"));
        this.initUI();
        this.initLayout();
        this.initListener();
        this.initDatas();
        this.setModal(true);
        this.setResizable(false);
    }

    public void initHelpMark() {
        if (StringUtils.isNULLStr(this.helpDoc)) {
            ((WizardTitlePane)this.rootPaneUI.getTitleComponent()).getHelpButton().setVisible(false);
        }
    }

    private Map<String, Boolean> createSupportType(String types) {
        HashMap<String, Boolean> stringBooleanMap = new HashMap<String, Boolean>();
        if (StringUtils.isNULLStr(types)) {
            stringBooleanMap.put("hmm", true);
            stringBooleanMap.put("ibmc", true);
            stringBooleanMap.put("os", true);
            stringBooleanMap.put("cmc", true);
            stringBooleanMap.put("ies", true);
            stringBooleanMap.put("tce", true);
            stringBooleanMap.put("switch", true);
        } else {
            ImmutableSet keys = ImmutableSet.of((Object)"hmm", (Object)"ibmc", (Object)"os", (Object)"cmc", (Object)"switch", (Object)"ies", (Object[])new String[0]);
            String lowerCaseTypes = types.toLowerCase(Locale.ENGLISH);
            for (String key : keys) {
                if (!lowerCaseTypes.contains(key)) continue;
                stringBooleanMap.put(key, true);
            }
            if (DeviceAliasMapper.TCE.hasMatchedAlias(types.toLowerCase(Locale.ENGLISH))) {
                stringBooleanMap.put("tce", true);
            }
        }
        return stringBooleanMap;
    }

    private void initUI() {
        this.getRootPane().setUI(this.rootPaneUI);
        this.savePathLabel = UIUtils.createRequiredLabel((String)ResourceUtil.getString((String)"scene.collectpath"), (boolean)true);
        String userPath = ApplicationContext.getInstance().getFilePath();
        if (StringUtils.isNULLStr(userPath)) {
            userPath = FilePathUtils.getCanonicalPath((File)FileSystemView.getFileSystemView().getDefaultDirectory());
        }
        this.savePathText = IsmTextField.getNameTextField((String)".*", (String)userPath, (int)90, (int)25, (boolean)true);
        this.savePathText.setToolTipText(userPath);
        this.savePathText.setEditable(false);
        this.setPathButton = UiMethod.createButton((String)ResourceUtil.getString((String)"smartkit.devicemanager.layout.scene.device.setup"), (char)'A');
        this.setPathDirLabelVisible();
    }

    private void setPathDirLabelVisible() {
        if (StringUtils.isNULLStr(this.settingDir)) {
            return;
        }
        if ("true".equalsIgnoreCase(this.settingDir)) {
            this.savePathLabel.setVisible(true);
            this.savePathText.setVisible(true);
            this.setPathButton.setVisible(true);
        } else {
            this.confirmGap = 940;
            this.savePathLabel.setVisible(false);
            this.savePathText.setVisible(false);
            this.setPathButton.setVisible(false);
        }
    }

    public void refreshDevTableCanEdit(boolean flag) {
        if ("true".equalsIgnoreCase(this.tableCanEdit)) {
            if (flag) {
                this.setPathButton.setEnabled(true);
                this.lay.getServerManagerLayout().getAddLabel().setVisible(true);
                this.lay.getServerManagerLayout().getAddLabel().setEnabled(true);
            } else {
                this.lay.getServerManagerLayout().getIbmcScrollPane().disableTableExceptColumns(new int[]{1});
                this.lay.getServerManagerLayout().getHmmScrollPane().disableTableExceptColumns(new int[]{1});
                this.lay.getServerManagerLayout().getOsScrollPane().disableTableExceptColumns(new int[0]);
                this.lay.getServerManagerLayout().getCmcScrollPane().disableTableExceptColumns(new int[0]);
                this.lay.getServerManagerLayout().getIesScrollPane().disableTableExceptColumns(new int[0]);
                this.lay.getServerManagerLayout().getTceScrollPanel().disableTableExceptColumns(new int[0]);
                this.lay.getServerManagerLayout().getSwitchScrollPanel().disableTableExceptColumns(new int[0]);
                this.setPathButton.setEnabled(false);
                this.lay.getServerManagerLayout().getAddLabel().setVisible(false);
                this.lay.getServerManagerLayout().getAddLabel().setEnabled(false);
            }
        }
    }

    private void initLayout() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        JPanel hBoxLay = new JPanel();
        hBoxLay.setLayout(new BoxLayout(hBoxLay, 0));
        hBoxLay.setBackground(Color.WHITE);
        JLabel label1 = new JLabel(" ");
        JLabel label2 = new JLabel(" ");
        UiMethod.setComponentSize((Dimension)new Dimension(15, 200), (Component[])new Component[]{label1});
        UiMethod.setComponentSize((Dimension)new Dimension(15, 200), (Component[])new Component[]{label2});
        hBoxLay.add(label1);
        hBoxLay.add(this.lay);
        hBoxLay.add(label2);
        contentPanel.add(hBoxLay);
        JPanel gap = new JPanel();
        gap.setBackground(Color.WHITE);
        UiMethod.setComponentSize((Dimension)new Dimension(1200, 20), (Component[])new Component[]{gap});
        JComponent bottomBox = UCD.buildVerticalBox(null, (Component[])new Component[]{gap, Box.createVerticalStrut(5), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(3), this.savePathLabel, this.savePathText, this.setPathButton, Box.createHorizontalStrut(this.confirmGap), this.confirmBtn, this.cancelBtn}), Box.createVerticalStrut(15)});
        this.setLayout(new BorderLayout());
        contentPanel.setBackground(Color.WHITE);
        this.add((Component)contentPanel, "Center");
        this.add((Component)bottomBox, "South");
    }

    public ServerManagerPanel getLay() {
        return this.lay;
    }

    public void setLay(ServerManagerPanel lay) {
        this.lay = lay;
    }

    public boolean isClickCancelFlag() {
        return this.clickCancelFlag;
    }

    public void setClickCancelFlag(boolean clickCancelFlag) {
        this.clickCancelFlag = clickCancelFlag;
    }

    private void initListener() {
        this.confirmBtn.addActionListener(new SaveDevice2JsonListener());
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerManagerDialog.this.closeAction();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ServerManagerDialog.this.closeAction();
            }
        });
        this.setPathButton.addActionListener((ActionListener)new DirSetupButtonListener(this, this.savePathText.getText()){

            public void callback(String path) {
                ISceneService getSceneContextService = (ISceneService)PublicServiceManage.getInstance().getService(ISceneService.class);
                getSceneContextService.setReportPath(path);
                ApplicationContext.getInstance().setFilePath(path);
                ServerManagerDialog.this.savePathText.setText(path);
                ServerManagerDialog.this.savePathText.setToolTipText(path);
            }
        });
        this.rootPaneUI.setHelpActionCallBack(new OpenHelpCallBack(this, this.helpDoc));
    }

    private boolean batchOperationCheck(int deviceNum) {
        int bladeServersNum = this.lay.getServerManagerLayout().getHmmTable().getSelectHmmDevs().size() + this.lay.getServerManagerLayout().getTceTable().getTceDevice().size();
        if (deviceNum <= 50 && bladeServersNum <= 1) {
            return true;
        }
        try {
            if (DeviceNetCareUtil.checkNetCareCode(BULK_OPERATION_CMD, this)) {
                return true;
            }
        }
        catch (ToolSceneException exception) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"scene.netcare.default.exception.code"));
            log.error("netCare request failed:{}", (Object)exception.getMessage());
        }
        return false;
    }

    private void closeAction() {
        this.setVisible(false);
        this.dispose();
        this.clickCancelFlag = true;
        DeviceCenterContext.getInstance().getServerManagePanel().refreshDatas();
    }

    public void refresh() {
        this.initDatas();
    }

    private void initDatas() {
        List<AbstractDevice> serverDevices = DeviceCenterContext.getInstance().getIbmcHmmOsDevs();
        ArrayList<AbstractDevice> ibmcDevices = new ArrayList<AbstractDevice>();
        ArrayList<AbstractDevice> hmmDevices = new ArrayList<AbstractDevice>();
        ArrayList<AbstractDevice> osDevices = new ArrayList<AbstractDevice>();
        ArrayList<AbstractDevice> cmcDevces = new ArrayList<AbstractDevice>();
        ArrayList<AbstractDevice> iesDevces = new ArrayList<AbstractDevice>();
        ArrayList<AbstractDevice> tceDevices = new ArrayList<AbstractDevice>();
        ArrayList<AbstractDevice> switchDevices = new ArrayList<AbstractDevice>();
        for (AbstractDevice dev : serverDevices) {
            if (dev instanceof IBMCDevice) {
                ibmcDevices.add(dev);
                continue;
            }
            if (dev instanceof SwitchDevice) {
                switchDevices.add(dev);
                continue;
            }
            if (dev instanceof HMMDevice) {
                hmmDevices.add(dev);
                continue;
            }
            if (dev instanceof OsDevice) {
                osDevices.add(dev);
                continue;
            }
            if (dev instanceof CMCDevice) {
                cmcDevces.add(dev);
                continue;
            }
            if (dev instanceof IESDevice) {
                iesDevces.add(dev);
                continue;
            }
            if (!(dev instanceof TceDevice)) continue;
            tceDevices.add(dev);
        }
        this.lay.getServerManagerLayout().getIbmcTable().refreshTable(ibmcDevices);
        this.lay.getServerManagerLayout().getHmmTable().refreshTable(hmmDevices);
        this.lay.getServerManagerLayout().getOsTable().refreshTable(osDevices);
        this.lay.getServerManagerLayout().getCmcTable().refreshTable(cmcDevces);
        this.lay.getServerManagerLayout().getAtlasTable().refreshTable(iesDevces);
        this.lay.getServerManagerLayout().getTceTable().refreshTable(tceDevices);
        this.lay.getServerManagerLayout().getSwitchTable().refreshTable(switchDevices);
    }

    private static class OpenHelpCallBack
    implements IHelpActionCallBack {
        private JDialog parentDlg = null;
        private String helpName = "";

        public OpenHelpCallBack(JDialog dlg, String name) {
            this.parentDlg = dlg;
            this.helpName = name;
        }

        @Override
        public void doHelpActionWork() {
            FileUtils.openHelpFile("ScenePrepareServer\\" + this.helpName, this.parentDlg, ".chm");
        }

        public String getListenerName() {
            return "Open SencePrepare help file";
        }
    }

    private class SaveDevice2JsonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<AbstractDevice> devices = new ArrayList<AbstractDevice>();
            devices.addAll(ServerManagerDialog.this.lay.getServerManagerLayout().getIbmcTable().getSelectIbmcDevs());
            devices.addAll(ServerManagerDialog.this.lay.getServerManagerLayout().getHmmTable().getSelectHmmDevs());
            devices.addAll(ServerManagerDialog.this.lay.getServerManagerLayout().getOsTable().getSelectOsDevs());
            devices.addAll(ServerManagerDialog.this.lay.getServerManagerLayout().getCmcTable().getSelectCmcDevs());
            devices.addAll(ServerManagerDialog.this.lay.getServerManagerLayout().getAtlasTable().getSelectIesDevices());
            devices.addAll(ServerManagerDialog.this.lay.getServerManagerLayout().getTceTable().getTceDevice());
            devices.addAll(ServerManagerDialog.this.lay.getServerManagerLayout().getSwitchTable().getSelectSwitchDevs());
            if (devices.isEmpty()) {
                DialogUtils.showInfoDialog((JDialog)ServerManagerDialog.this, (String)ResourceUtil.getString((String)"scene.select.atleastone"));
                return;
            }
            int maxSelectDevNum = Integer.parseInt(ResourceUtil.getString((String)"device.scene.select.device.max.num", (Locale)Locale.CHINESE));
            if (devices.size() > maxSelectDevNum) {
                DialogUtils.showInfoDialog((JDialog)ServerManagerDialog.this, (String)ResourceUtil.getStringWithParams((String)"scene.select.device.count.beyond", (Object[])new Object[]{maxSelectDevNum}));
                return;
            }
            if (ServerManagerDialog.this.onlyOneCanFlag && devices.size() > 1) {
                DialogUtils.showInfoDialog((JDialog)ServerManagerDialog.this, (String)ResourceUtil.getString((String)"scene.canonly.selectone.tips"));
                return;
            }
            if (!ServerManagerDialog.this.batchOperationCheck(devices.size())) {
                log.warn("netCare check not pass");
                return;
            }
            this.saveDeviceData2Json(devices);
            ISceneService getSceneContextService = (ISceneService)PublicServiceManage.getInstance().getService(ISceneService.class);
            getSceneContextService.setSuccessDevCount(devices.size());
            ServerManagerDialog.this.closeAction();
            ServerManagerDialog.this.setClickCancelFlag(false);
        }

        private void saveDeviceData2Json(List<AbstractDevice> devs) {
            SmartkitUtils.transDevice2Json(devs);
        }
    }
}

