/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog;

import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.CMCDevice;
import com.huawei.ism.tool.devicecenter.entity.HMMDevice;
import com.huawei.ism.tool.devicecenter.entity.IBMCDevice;
import com.huawei.ism.tool.devicecenter.entity.IESDevice;
import com.huawei.ism.tool.devicecenter.entity.OsDevice;
import com.huawei.ism.tool.devicecenter.entity.SwitchDevice;
import com.huawei.ism.tool.devicecenter.listener.AddListener;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.ServerManagerLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class ServerManagerPanel
extends JPanel {
    private static final long serialVersionUID = 4894382874205261086L;
    private ServerManagerLayout serverManagerLayout = null;

    public ServerManagerPanel(boolean isScene, Map<String, Boolean> labelMap, boolean flag) {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.serverManagerLayout = new ServerManagerLayout(isScene, labelMap, flag);
        this.serverManagerLayout.refreshSceneAddDevice();
        panel.add((Component)this.serverManagerLayout, "Center");
        this.add((Component)panel, "Center");
        this.initListener();
    }

    public ServerManagerPanel(boolean isScene) {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.serverManagerLayout = new ServerManagerLayout(isScene);
        panel.add((Component)this.serverManagerLayout, "Center");
        this.add((Component)panel, "Center");
        this.initListener();
    }

    private void initListener() {
        this.serverManagerLayout.getAddLabel().addActionListener(new AddListener());
    }

    public ServerManagerLayout getServerManagerLayout() {
        return this.serverManagerLayout;
    }

    public void setServerManagerLayout(ServerManagerLayout serverManagerLayout) {
        this.serverManagerLayout = serverManagerLayout;
    }

    public void refreshDatas() {
        List<AbstractDevice> serverDevices = DeviceCenterContext.getInstance().getIbmcHmmOsDevs();
        ArrayList<AbstractDevice> ibmcDevices = new ArrayList<AbstractDevice>();
        ArrayList<AbstractDevice> hmmDevices = new ArrayList<AbstractDevice>();
        ArrayList<AbstractDevice> osDevices = new ArrayList<AbstractDevice>();
        ArrayList<AbstractDevice> cmcDevices = new ArrayList<AbstractDevice>();
        ArrayList<AbstractDevice> iesDevices = new ArrayList<AbstractDevice>();
        ArrayList<AbstractDevice> swiDevices = new ArrayList<AbstractDevice>();
        for (AbstractDevice dev : serverDevices) {
            if (dev instanceof IBMCDevice) {
                ibmcDevices.add(dev);
                continue;
            }
            if (dev instanceof SwitchDevice) {
                swiDevices.add(dev);
                continue;
            }
            if (dev instanceof HMMDevice) {
                hmmDevices.add(dev);
                continue;
            }
            if (dev instanceof OsDevice) {
                osDevices.add(dev);
                continue;
            }
            if (dev instanceof CMCDevice) {
                cmcDevices.add(dev);
                continue;
            }
            if (!(dev instanceof IESDevice)) continue;
            iesDevices.add(dev);
        }
        this.refreshIbmcHmmOsTable(ibmcDevices, osDevices);
        this.refreshCmcIesTable(cmcDevices, iesDevices);
        this.refreshSwitchTable(swiDevices);
        this.repaint();
    }

    private void refreshSwitchTable(List<AbstractDevice> swiDevices) {
        DeviceCenterContext.getInstance().getServerManagePanel().getServerManagerLayout().getSwitchTable().refreshTable(swiDevices);
    }

    private void refreshIbmcHmmOsTable(List<AbstractDevice> ibmcDevices, List<AbstractDevice> osDevices) {
        DeviceCenterContext.getInstance().getServerManagePanel().getServerManagerLayout().getIbmcTable().refreshTable(ibmcDevices);
        DeviceCenterContext.getInstance().getServerManagePanel().getServerManagerLayout().getHmmTable().refreshTable(ibmcDevices);
        DeviceCenterContext.getInstance().getServerManagePanel().getServerManagerLayout().getOsTable().refreshTable(osDevices);
    }

    private void refreshCmcIesTable(List<AbstractDevice> cmcDevices, List<AbstractDevice> iesDevices) {
        DeviceCenterContext.getInstance().getServerManagePanel().getServerManagerLayout().getCmcTable().refreshTable(cmcDevices);
        DeviceCenterContext.getInstance().getServerManagePanel().getServerManagerLayout().getAtlasTable().refreshTable(iesDevices);
    }
}

