/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog.detail.layout;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.IBMCDevice;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class IbmcDetailInfoLayout
extends JPanel {
    private static final long serialVersionUID = -5819403453052628601L;
    private static final Dimension LABEL_DIM_ZH = new Dimension(80, 16);
    private static final Dimension LABEL_DIM_EN = new Dimension(95, 16);
    private static final int BMC_ROW = 5;
    private static final int BMC_COL = 3;
    private static final int OS_ROW = 3;
    private static final int OS_COL = 2;
    private static final int MARGIN = 24;
    private transient IBMCDevice device;
    private JLabel devIbmcIpLabel;
    private JLabel devSerialNumberLabel;
    private JLabel devProductNameLabel;
    private JLabel devCPLDLabel;
    private JLabel devBIOSLabel;
    private JLabel devSNMPPortLabel;
    private JLabel devSSHPortLabel;
    private JLabel devIPMIPortLabel;
    private JLabel devVMMPortLabel;
    private JLabel devMasterBMCLabel;
    private JLabel devSlaveBMCLabel;
    private JLabel devUserLabel;
    private JLabel devOsTypeLabel;
    private JLabel devOsIpLabel;
    private JLabel devOsPortLabel;
    private JLabel devOsUserLabel;

    public IbmcDetailInfoLayout(AbstractDevice device) {
        if (device instanceof IBMCDevice) {
            this.device = (IBMCDevice)device;
        }
        this.initUI();
        this.initLayout();
        this.initData();
    }

    private void initUI() {
        this.devIbmcIpLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.bmcip"));
        this.devSerialNumberLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.sn"));
        this.devProductNameLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.productname"));
        this.devCPLDLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.cpld"));
        this.devBIOSLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.bios"));
        this.devUserLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.user"));
        this.devSNMPPortLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.snmp"));
        this.devSSHPortLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.ssh"));
        this.devIPMIPortLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.impi"));
        this.devVMMPortLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.vmm"));
        this.devMasterBMCLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.masterbmc"));
        this.devSlaveBMCLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.slavebmc"));
        this.devOsTypeLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.os.type"));
        this.devOsIpLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.os.ip"));
        this.devOsUserLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.os.user"));
        this.devOsPortLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.os.port"));
    }

    private void initData() {
        JPanel bmcInfoPane = new JPanel();
        bmcInfoPane.setLayout(new GridLayout(5, 3, 0, 2));
        bmcInfoPane.add(this.createItemPane(this.devIbmcIpLabel, this.device.getIp()));
        bmcInfoPane.add(this.createItemPane(this.devSerialNumberLabel, this.device.getDeviceSerialNumber()));
        bmcInfoPane.add(this.createItemPane(this.devProductNameLabel, this.device.getProductName()));
        bmcInfoPane.add(this.createItemPane(this.devCPLDLabel, this.device.getCpld()));
        bmcInfoPane.add(this.createItemPane(this.devBIOSLabel, this.device.getBios()));
        bmcInfoPane.add(this.createItemPane(this.devUserLabel, this.device.getAccount().getUserName()));
        bmcInfoPane.add(this.createItemPane(this.devSNMPPortLabel, String.valueOf(this.device.getSnmpPort())));
        bmcInfoPane.add(this.createItemPane(this.devSSHPortLabel, String.valueOf(this.device.getSshPort())));
        bmcInfoPane.add(this.createItemPane(this.devIPMIPortLabel, String.valueOf(this.device.getIpmiPort())));
        bmcInfoPane.add(this.createItemPane(this.devVMMPortLabel, String.valueOf(this.device.getVmmPort())));
        bmcInfoPane.add(this.createItemPane(this.devMasterBMCLabel, String.valueOf(this.device.getMasterBMC())));
        bmcInfoPane.add(this.createItemPane(this.devSlaveBMCLabel, String.valueOf(this.device.getSlaveBMC())));
        bmcInfoPane.add(Box.createVerticalGlue());
        Border bmcBorder = UCD.createTitledBorder((String)ResourceUtil.getString((String)"devicemanager.dc.layout.detail.server.title.bmcinfo"));
        bmcInfoPane.setBorder(bmcBorder);
        this.add(bmcInfoPane);
        this.add(Box.createHorizontalStrut(24));
        this.addAlternativeOsInfo();
        this.add(Box.createHorizontalGlue());
    }

    private void addAlternativeOsInfo() {
        if (!this.device.getOsInfo().isAllBasicInfoEmpty()) {
            JPanel osInfoPane = new JPanel();
            osInfoPane.setLayout(new GridLayout(3, 2, 0, 2));
            osInfoPane.add(this.createItemPane(this.devOsTypeLabel, this.device.getOsInfo().getType()));
            osInfoPane.add(this.createItemPane(this.devOsIpLabel, this.device.getOsInfo().getIp()));
            osInfoPane.add(this.createItemPane(this.devOsUserLabel, this.device.getOsInfo().getAccount().getUserName()));
            osInfoPane.add(this.createItemPane(this.devOsPortLabel, this.device.getOsInfo().getPort()));
            osInfoPane.add(Box.createVerticalGlue());
            Border osInfoBorder = UCD.createTitledBorder((String)ResourceUtil.getString((String)"devicemanager.dc.layout.detail.server.title.osinfo"));
            osInfoPane.setBorder(osInfoBorder);
            this.add(osInfoPane);
        }
    }

    private JPanel createItemPane(JLabel label, String value) {
        JPanel itemPane = new JPanel();
        itemPane.setLayout(new BoxLayout(itemPane, 0));
        if (Locale.ENGLISH.equals(LanguageManager.getInstance().getCurrentLanguage())) {
            UiMethod.setComponentSize(LABEL_DIM_EN, label);
        } else {
            UiMethod.setComponentSize(LABEL_DIM_ZH, label);
        }
        itemPane.add(label);
        itemPane.add(new JLabel(value));
        return itemPane;
    }

    private void initLayout() {
        this.setLayout(new BoxLayout(this, 1));
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
    }

    public JLabel getDevIbmcIpLabel() {
        return this.devIbmcIpLabel;
    }

    public void setDevIbmcIpLabel(JLabel devIbmcIpLabel) {
        this.devIbmcIpLabel = devIbmcIpLabel;
    }

    public JLabel getDevSerialNumberLabel() {
        return this.devSerialNumberLabel;
    }

    public void setDevSerialNumberLabel(JLabel devSerialNumberLabel) {
        this.devSerialNumberLabel = devSerialNumberLabel;
    }

    public JLabel getDevProductNameLabel() {
        return this.devProductNameLabel;
    }

    public void setDevProductNameLabel(JLabel devProductNameLabel) {
        this.devProductNameLabel = devProductNameLabel;
    }

    public JLabel getDevCPLDLabel() {
        return this.devCPLDLabel;
    }

    public void setDevCPLDLabel(JLabel devCPLDLabel) {
        this.devCPLDLabel = devCPLDLabel;
    }

    public JLabel getDevBIOSLabel() {
        return this.devBIOSLabel;
    }

    public void setDevBIOSLabel(JLabel devBIOSLabel) {
        this.devBIOSLabel = devBIOSLabel;
    }

    public JLabel getDevSNMPPortLabel() {
        return this.devSNMPPortLabel;
    }

    public void setDevSNMPPortLabel(JLabel devSNMPPortLabel) {
        this.devSNMPPortLabel = devSNMPPortLabel;
    }

    public JLabel getDevSSHPortLabel() {
        return this.devSSHPortLabel;
    }

    public void setDevSSHPortLabel(JLabel devSSHPortLabel) {
        this.devSSHPortLabel = devSSHPortLabel;
    }

    public JLabel getDevIPMIPortLabel() {
        return this.devIPMIPortLabel;
    }

    public void setDevIPMIPortLabel(JLabel devIPMIPortLabel) {
        this.devIPMIPortLabel = devIPMIPortLabel;
    }

    public JLabel getDevVMMPortLabel() {
        return this.devVMMPortLabel;
    }

    public void setDevVMMPortLabel(JLabel devVMMPortLabel) {
        this.devVMMPortLabel = devVMMPortLabel;
    }

    public JLabel getDevMasterBMCLabel() {
        return this.devMasterBMCLabel;
    }

    public void setDevMasterBMCLabel(JLabel devMasterBMCLabel) {
        this.devMasterBMCLabel = devMasterBMCLabel;
    }

    public JLabel getDevSlaveBMCLabel() {
        return this.devSlaveBMCLabel;
    }

    public void setDevSlaveBMCLabel(JLabel devSlaveBMCLabel) {
        this.devSlaveBMCLabel = devSlaveBMCLabel;
    }

    public JLabel getDevUserLabel() {
        return this.devUserLabel;
    }

    public void setDevUserLabel(JLabel devUserLabel) {
        this.devUserLabel = devUserLabel;
    }

    public JLabel getDevOsTypeLabel() {
        return this.devOsTypeLabel;
    }

    public void setDevOsTypeLabel(JLabel devOsTypeLabel) {
        this.devOsTypeLabel = devOsTypeLabel;
    }

    public JLabel getDevOsIpLabel() {
        return this.devOsIpLabel;
    }

    public void setDevOsIpLabel(JLabel devOsIpLabel) {
        this.devOsIpLabel = devOsIpLabel;
    }

    public JLabel getDevOsPortLabel() {
        return this.devOsPortLabel;
    }

    public void setDevOsPortLabel(JLabel devOsPortLabel) {
        this.devOsPortLabel = devOsPortLabel;
    }

    public JLabel getDevOsUserLabel() {
        return this.devOsUserLabel;
    }

    public void setDevOsUserLabel(JLabel devOsUserLabel) {
        this.devOsUserLabel = devOsUserLabel;
    }
}

