/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog.layout;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.driver.model.TotalDriverResult;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.entity.IBMCDevice;
import com.huawei.ism.tool.devicecenter.service.DeviceControl;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.service.UpdateBtnServiceInterface;
import com.huawei.ism.tool.devicecenter.ui.SerDeviTitleLabel;
import com.huawei.ism.tool.devicecenter.ui.dialog.BatchImportInfoDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.IbmcDeviceAddDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.action.OpreationAction;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.IbmcDeviceAddLayout;
import com.huawei.ism.tool.devicecenter.utils.LayUtil;
import com.huawei.ism.tool.devicecenter.utils.LogUtils;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IBMCTablePanel
extends JPanel
implements IImportListener,
UpdateBtnServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(IBMCTablePanel.class);
    private static final String IBMC_DIALOG = "ibmcDialog";
    private IsmTable deviceTable;
    private DefaultTableModel tableModel;
    private TaskResult result;
    private List<IImportListener> ibmcListenerTables = null;
    private List<AbstractDevice> hwXlsDevs = null;
    private SerDeviTitleLabel titleLabel = null;
    private String[] ibmcTableHeader = new String[]{ResourceUtil.getString((String)"devicecenter.ismtable.header.ibmc.serialnum"), ResourceUtil.getString((String)"devicecenter.ismtable.header.ibmc.ip"), ResourceUtil.getString((String)"devicecenter.ismtable.header.ibmc.productname"), ResourceUtil.getString((String)"devicecenter.ismtable.header.ibmc.ibmc"), ResourceUtil.getString((String)"devicecenter.ismtable.header.ibmc.cpld"), ResourceUtil.getString((String)"devicecenter.ismtable.header.ibmc.bios"), ResourceUtil.getString((String)"devicecenter.ismtable.header.ibmc.username")};

    public IBMCTablePanel() {
        this.tableModel = new DefaultTableModel(this.ibmcTableHeader, new int[0]);
        this.deviceTable = new IsmTable((TableModel)this.tableModel);
        TableColumn firstColumn = this.deviceTable.getColumnModel().getColumn(0);
        firstColumn.setPreferredWidth(200);
        firstColumn.setMaxWidth(280);
        firstColumn.setMinWidth(200);
        TableScrollPane scrollPanel = new TableScrollPane(this.deviceTable, false, false, true);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPanel, "Center");
        this.setBackground(Color.WHITE);
    }

    @Override
    public void finishedImport(TotalDriverResult totalDriverResult) {
    }

    @Override
    public void refreshProcess(TotalDriverResult totalDriverResult) {
    }

    @Override
    public void dealWithException(String mesage) {
    }

    @Override
    public void refreshTable(List<AbstractDevice> abstractDevices) {
        List<AbstractDevice> tableShouldRefreshDevices = LayUtil.getTableShouldRefreshDevices(this.tableModel, abstractDevices);
        DeviceCenterContext.getInstance().setIbmcHmmOsDevs(tableShouldRefreshDevices);
        LayUtil.getTableExistedDevices(this.tableModel);
        LayUtil.clearTable(this.tableModel);
        for (AbstractDevice device : tableShouldRefreshDevices) {
            if (!device.getItDeviceType().equals((Object)ITDeviceType.SERVER_IBMC)) continue;
            this.tableModel.addRow(new TableRow[]{this.createIBMCRow((IBMCDevice)device)});
        }
        if (this.titleLabel != null) {
            this.titleLabel.setDevNum(this.getDeviceTable().getAllRows().size());
        }
    }

    private TableRow<IBMCDevice, String> createIBMCRow(IBMCDevice ibmcDevice) {
        DefaultTableRow currentRow = new DefaultTableRow(this.ibmcTableHeader.length, (Object)ibmcDevice, (Object)(ibmcDevice.getHwServerDev().isPortProxy() ? ibmcDevice.getDeviceSn() : ibmcDevice.getIp()));
        int colNum = 0;
        OpreationAction opAction = new OpreationAction(ibmcDevice);
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(ibmcDevice.getDeviceSerialNumber()));
        currentRow.setValueAt(colNum++, (Object)new IsmTableCell.HyperlinkCell(ibmcDevice.getIp(), (ActionListener)opAction));
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(ibmcDevice.getProductName()));
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(ibmcDevice.getMasterBMC()));
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(ibmcDevice.getCpld()));
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(ibmcDevice.getBios()));
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(ibmcDevice.getAccount().getUserName()));
        return currentRow;
    }

    public List<IBMCDevice> getSelectIbmcDevs() {
        ArrayList<IBMCDevice> devList = new ArrayList<IBMCDevice>();
        List rows = this.getDeviceTable().getMarkedRows();
        for (TableRow row : rows) {
            devList.add((IBMCDevice)row.getUserObject());
        }
        return devList;
    }

    @Override
    public void deleteServiceDev() {
        List<TableRow> rows = this.getSelectRows();
        SmartkitUtils.deleteSceneAddDialogHasedDevices(rows, this);
        for (TableRow row : rows) {
            this.getTableModel().removeRow(new TableRow[]{row});
            LogUtils.addImportLog("devicemanager.server.manager.layout.remove", ((IBMCDevice)row.getUserObject()).getIp(), true, "");
            DeviceCenterContext.getInstance().getIbmcHmmOsDevs().remove(row.getUserObject());
            LayUtil.removeDevFromAllTableDevs((AbstractDevice)row.getUserObject());
        }
        DeviceCenterContext.getInstance().notifyDeviceObserver();
        if (this.titleLabel != null) {
            this.titleLabel.setDevNum(this.getDeviceTable().getAllRows().size());
        }
        this.repaint();
    }

    private List<TableRow> getSelectRows() {
        return this.deviceTable.getMarkedRows();
    }

    public void refreshDevicesInfo() {
        BatchImportInfoDialog importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.device.refresh.dialogTitle"));
        this.ibmcListenerTables = DeviceCenterContext.getInstance().getDeviceTables().get("deviceTables");
        SmartkitUtils.addBatchImportDialog(importDialog, this.ibmcListenerTables);
        this.hwXlsDevs = new ArrayList<AbstractDevice>();
        List<IBMCDevice> ibmcDevs = this.getSelectIbmcDevs();
        for (IBMCDevice dev : ibmcDevs) {
            HwServerDevice xlsDev = dev.getHwServerDev();
            xlsDev.setStartIPAddress(dev.getIp());
            xlsDev.setEndIPAddress(dev.getIp());
            this.hwXlsDevs.add(xlsDev);
        }
        Runnable refeshIbmcDev = () -> {
            DeviceControl.getInstance().initDriverFile();
            this.result = DeviceControl.getInstance().importDevices(this.hwXlsDevs, this.ibmcListenerTables);
            DeviceControl.getInstance().refreshFile();
            if (TaskResult.Result.SUCCESS.equals((Object)this.result.getResult())) {
                log.info("find the device success.");
            } else {
                log.info("find the device failed.");
            }
        };
        Future<?> future = Executors.newSingleThreadExecutor().submit(refeshIbmcDev);
        if (log.isInfoEnabled()) {
            log.info("the result of the task is: " + future.isDone());
        }
    }

    public void modifyDevicesInfo() {
        List<IBMCDevice> ibmcDevs = this.getSelectIbmcDevs();
        if (ibmcDevs.size() > 1) {
            DialogUtils.showInfoDialog((Frame)DeviceCenterContext.getInstance().getParent(), (String)ResourceUtil.getString((String)"smartkit.devicemanager.layout.device.modifiy.oneOnly"));
            return;
        }
        IbmcDeviceAddLayout lay = new IbmcDeviceAddLayout();
        lay.getStartIp().setText("IP:");
        lay.getSymbolLabel().setText("");
        lay.getStartIpAddress().setEnabled(false);
        LayUtil.setComponentSize((JComponent)lay.getStartIpAddress(), new Dimension(200, 23));
        lay.getEndIpLabel().setVisible(false);
        lay.getEndIpField().setVisible(false);
        HwServerDevice hwServer = ibmcDevs.get(0).getHwServerDev();
        lay.getStartIpAddress().setText(LayUtil.filterItemInfo(ibmcDevs.get(0).getIp()));
        lay.getEndIpField().setText(LayUtil.filterItemInfo(ibmcDevs.get(0).getIp()));
        lay.getUserNameField().setText(LayUtil.filterItemInfo(hwServer.getUserName()));
        lay.getSnmpPortField().setText(LayUtil.filterItemInfo(hwServer.getSnmpPort() + ""));
        lay.getIpmiField().setText(LayUtil.filterItemInfo(hwServer.getIpmiPort() + ""));
        lay.getSshSfipField().setText(LayUtil.filterItemInfo(hwServer.getSshPort() + ""));
        lay.getVmField().setText(LayUtil.filterItemInfo(hwServer.getVmmPort() + ""));
        lay.getRedfishField().setText(LayUtil.filterItemInfo(hwServer.getRedFishPort() + ""));
        hwServer.setItDeviceType(ITDeviceType.SERVER_IBMC);
        IbmcDeviceAddDialog addDialog = new IbmcDeviceAddDialog(lay);
        hwServer.setStartIPAddress(ibmcDevs.get(0).getIp());
        hwServer.setEndIPAddress(ibmcDevs.get(0).getIp());
        addDialog.setDevInitHwServer(hwServer);
        SwingUtil.putParentCenter((Window)addDialog, (Window)DeviceCenterContext.getInstance().getParent());
        addDialog.setVisible(true);
    }

    @Override
    public void startCheckImportDevice(List<String> serverIpList) {
    }

    public IsmTable getDeviceTable() {
        return this.deviceTable;
    }

    public void setDeviceTable(IsmTable deviceTable) {
        this.deviceTable = deviceTable;
    }

    @Override
    public int getSelectNum() {
        return this.getDeviceTable().getSelectedRows().length;
    }

    @Override
    public void updateBtn() {
    }

    @Override
    public List<AbstractDevice> getCurrentNeedCheckPortDeviceList() {
        return this.getSelectIbmcDevs().stream().map(this::getHwServerDevice).collect(Collectors.toList());
    }

    private HwServerDevice getHwServerDevice(IBMCDevice ibmcDevice) {
        HwServerDevice hwServerDev = ibmcDevice.getHwServerDev();
        hwServerDev.setStartIPAddress(ibmcDevice.getIp());
        hwServerDev.setEndIPAddress(ibmcDevice.getIp());
        return hwServerDev;
    }

    @Override
    public String getName() {
        return IBMC_DIALOG;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(DefaultTableModel tableModel) {
        this.tableModel = tableModel;
    }

    public SerDeviTitleLabel getTitleLabel() {
        return this.titleLabel;
    }

    public void setTitleLabel(SerDeviTitleLabel titleLabel) {
        this.titleLabel = titleLabel;
    }
}

