/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog.layout;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.driver.model.TotalDriverResult;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.entity.OsDevice;
import com.huawei.ism.tool.devicecenter.service.DeviceControl;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.service.UpdateBtnServiceInterface;
import com.huawei.ism.tool.devicecenter.ui.SerDeviTitleLabel;
import com.huawei.ism.tool.devicecenter.ui.dialog.BatchImportInfoDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.OsDeviceAddDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.OsDeviceAddLayout;
import com.huawei.ism.tool.devicecenter.utils.LayUtil;
import com.huawei.ism.tool.devicecenter.utils.LogUtils;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSTablePanel
extends JPanel
implements IImportListener,
UpdateBtnServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(OSTablePanel.class);
    private static final String KER_VERSION = "kernelVersion";
    private static final String OS_DIALOG = "osDialog";
    private IsmTable deviceTable;
    private DefaultTableModel tableModel;
    private TaskResult result;
    private List<IImportListener> osListenerTables = null;
    private List<AbstractDevice> hwXlsDevs = null;
    private SerDeviTitleLabel titleLabel = null;
    private String[] ibmcTableHeader = new String[]{ResourceUtil.getString((String)"devicecenter.ismtable.header.ibmc.serialnum"), ResourceUtil.getString((String)"devicecenter.ismtable.header.os.ip"), ResourceUtil.getString((String)"devicecenter.ismtable.header.os.type"), ResourceUtil.getString((String)"devicecenter.ismtable.header.os.username"), "kernelVersion"};

    public OSTablePanel() {
        this.tableModel = new DefaultTableModel(this.ibmcTableHeader, new int[0]);
        this.deviceTable = new IsmTable((TableModel)this.tableModel);
        TableScrollPane scrollPanel = new TableScrollPane(this.deviceTable, false, false, true);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPanel, "Center");
        this.setBackground(Color.WHITE);
    }

    @Override
    public void finishedImport(TotalDriverResult totalDriverResult) {
    }

    public void startCheckImportDevice() {
    }

    @Override
    public void refreshProcess(TotalDriverResult totalDriverResult) {
    }

    @Override
    public void dealWithException(String mesage) {
    }

    @Override
    public void refreshTable(List<AbstractDevice> abstractDevices) {
        List<AbstractDevice> tableShouldRefreshDevices = LayUtil.getTableShouldRefreshDevices(this.tableModel, abstractDevices);
        DeviceCenterContext.getInstance().setIbmcHmmOsDevs(tableShouldRefreshDevices);
        LayUtil.getTableExistedDevices(this.tableModel);
        LayUtil.clearTable(this.tableModel);
        for (AbstractDevice device : tableShouldRefreshDevices) {
            if (ITDeviceType.SERVER_OS != device.getItDeviceType()) continue;
            this.tableModel.addRow(new TableRow[]{this.createOsRow((OsDevice)device)});
        }
        if (this.titleLabel != null) {
            this.titleLabel.setDevNum(this.getDeviceTable().getAllRows().size());
        }
    }

    private TableRow<OsDevice, String> createOsRow(OsDevice dev) {
        DefaultTableRow currentRow = new DefaultTableRow(this.ibmcTableHeader.length, (Object)dev, (Object)dev.getIp());
        int colNum = 0;
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(dev.getSn()));
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(dev.getIp()));
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(dev.getOsType()));
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(dev.getUserName()));
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(dev.getKernerVersion()));
        return currentRow;
    }

    @Override
    public void startCheckImportDevice(List<String> serverIpList) {
    }

    @Override
    public void deleteServiceDev() {
        List osRows = this.deviceTable.getMarkedRows();
        SmartkitUtils.deleteSceneAddDialogHasedDevices(osRows, this);
        for (TableRow osRow : osRows) {
            this.getTableModel().removeRow(new TableRow[]{osRow});
            LogUtils.addImportLog("devicemanager.server.manager.layout.remove", ((OsDevice)osRow.getUserObject()).getIp(), true, "");
            DeviceCenterContext.getInstance().getIbmcHmmOsDevs().remove(osRow.getUserObject());
            LayUtil.removeDevFromAllTableDevs((AbstractDevice)osRow.getUserObject());
        }
        DeviceCenterContext.getInstance().notifyDeviceObserver();
        if (this.titleLabel != null) {
            this.titleLabel.setDevNum(this.getDeviceTable().getAllRows().size());
        }
        this.repaint();
    }

    public void refreshDevicesInfo() {
        List<OsDevice> osDevs = this.getSelectOsDevs();
        BatchImportInfoDialog importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.device.refresh.dialogTitle"));
        this.osListenerTables = DeviceCenterContext.getInstance().getDeviceTables().get("deviceTables");
        SmartkitUtils.addBatchImportDialog(importDialog, this.osListenerTables);
        this.hwXlsDevs = new ArrayList<AbstractDevice>();
        for (OsDevice dev : osDevs) {
            HwServerDevice xlsDev = dev.getHwServerDev();
            xlsDev.setStartIPAddress(dev.getIp());
            xlsDev.setEndIPAddress(dev.getIp());
            this.hwXlsDevs.add(dev.getHwServerDev());
        }
        Runnable refreshThread = new Runnable(){

            @Override
            public void run() {
                DeviceControl.getInstance().initDriverFile();
                OSTablePanel.this.result = DeviceControl.getInstance().importDevices(OSTablePanel.this.hwXlsDevs, OSTablePanel.this.osListenerTables);
                DeviceControl.getInstance().refreshFile();
                if (TaskResult.Result.SUCCESS.equals((Object)OSTablePanel.this.result.getResult())) {
                    log.info("find the device success.");
                } else {
                    log.info("find the device failed.");
                }
            }
        };
        Future<?> future = Executors.newSingleThreadExecutor().submit(refreshThread);
        if (log.isInfoEnabled()) {
            log.info("the result of the task is: " + future.isDone());
        }
    }

    public void modifyDevicesInfo() {
        List<OsDevice> osDevs = this.getSelectOsDevs();
        if (osDevs.size() > 1) {
            DialogUtils.showInfoDialog((Frame)DeviceCenterContext.getInstance().getParent(), (String)ResourceUtil.getString((String)"smartkit.devicemanager.layout.device.modifiy.oneOnly"));
            return;
        }
        OsDeviceAddLayout lay = new OsDeviceAddLayout(false);
        lay.getStartIp().setText("IP:");
        lay.getSymbolLabel().setText("");
        lay.getStartIpAddress().setEnabled(false);
        lay.getEndIpLabel().setVisible(false);
        lay.getEndIpField().setVisible(false);
        HwServerDevice hwServer = osDevs.get(0).getHwServerDev();
        hwServer.setItDeviceType(osDevs.get(0).getItDeviceType());
        lay.getStartIpAddress().setText(LayUtil.filterItemInfo(osDevs.get(0).getIp()));
        lay.getEndIpField().setText(LayUtil.filterItemInfo(osDevs.get(0).getIp()));
        lay.getUserNameField().setText(LayUtil.filterItemInfo(hwServer.getUserName()));
        OsDeviceAddDialog addDialog = new OsDeviceAddDialog(lay);
        hwServer.setStartIPAddress(osDevs.get(0).getIp());
        hwServer.setEndIPAddress(osDevs.get(0).getIp());
        addDialog.setDevInitHwServer(hwServer);
        SwingUtil.putParentCenter((Window)addDialog, (Window)DeviceCenterContext.getInstance().getParent());
        addDialog.setVisible(true);
    }

    @Override
    public int getSelectNum() {
        return this.getDeviceTable().getSelectedRows().length;
    }

    public List<OsDevice> getSelectOsDevs() {
        ArrayList<OsDevice> devList = new ArrayList<OsDevice>();
        List rows = this.getDeviceTable().getMarkedRows();
        for (TableRow row : rows) {
            devList.add((OsDevice)row.getUserObject());
        }
        return devList;
    }

    @Override
    public void updateBtn() {
    }

    @Override
    public List<AbstractDevice> getCurrentNeedCheckPortDeviceList() {
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return OS_DIALOG;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public IsmTable getDeviceTable() {
        return this.deviceTable;
    }

    @Override
    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTitleLabel(SerDeviTitleLabel titleLabel) {
        this.titleLabel = titleLabel;
    }
}

