/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog.layout;

import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.driver.model.TotalDriverResult;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.entity.SwitchDevice;
import com.huawei.ism.tool.devicecenter.service.DeviceControl;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.service.UpdateBtnServiceInterface;
import com.huawei.ism.tool.devicecenter.ui.SerDeviTitleLabel;
import com.huawei.ism.tool.devicecenter.ui.dialog.BatchImportInfoDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.SwitchAddDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.SwitchDeviceAddLayOut;
import com.huawei.ism.tool.devicecenter.utils.LayUtil;
import com.huawei.ism.tool.devicecenter.utils.LogUtils;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SWITCHTablePanel
extends JPanel
implements IImportListener,
UpdateBtnServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(SWITCHTablePanel.class);
    private IsmTable deviceTable;
    private DefaultTableModel tableModel;
    private TaskResult result;
    private List<IImportListener> switchListenerTables = null;
    private List<AbstractDevice> hwXlsDevs = null;
    private SerDeviTitleLabel titleLabel = null;
    private String[] ibmcTableHeader = new String[]{ResourceUtil.getString((String)"devicecenter.ismtable.header.switch.ip"), ResourceUtil.getString((String)"devicecenter.ismtable.header.switch.type"), ResourceUtil.getString((String)"devicecenter.ismtable.header.switch.username"), ResourceUtil.getString((String)"devicecenter.ismtable.header.switch.software")};

    public SWITCHTablePanel() {
        this.tableModel = new DefaultTableModel(this.ibmcTableHeader, new int[0]);
        this.deviceTable = new IsmTable((TableModel)this.tableModel);
        TableScrollPane scrollPanel = new TableScrollPane(this.deviceTable, false, false, true);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPanel, "Center");
        this.setBackground(Color.WHITE);
    }

    public List<SwitchDevice> getSelectSwitchDevs() {
        ArrayList<SwitchDevice> devList = new ArrayList<SwitchDevice>();
        List rows = this.getDeviceTable().getMarkedRows();
        for (TableRow row : rows) {
            devList.add((SwitchDevice)row.getUserObject());
        }
        return devList;
    }

    @Override
    public String getName() {
        return "switchDialog";
    }

    @Override
    public void finishedImport(TotalDriverResult totalDriverResult) {
    }

    @Override
    public void startCheckImportDevice(List<String> serverIpList) {
    }

    @Override
    public void refreshProcess(TotalDriverResult totalDriverResult) {
    }

    @Override
    public void dealWithException(String mesage) {
    }

    @Override
    public void refreshTable(List<AbstractDevice> abstractDevices) {
        List<AbstractDevice> tableShouldRefreshDevices = LayUtil.getTableShouldRefreshDevices(this.tableModel, abstractDevices);
        DeviceCenterContext.getInstance().setIbmcHmmOsDevs(tableShouldRefreshDevices);
        LayUtil.getTableExistedDevices(this.tableModel);
        LayUtil.clearTable(this.tableModel);
        for (AbstractDevice device : tableShouldRefreshDevices) {
            if (device.getItDeviceType() != ITDeviceType.SWITCH) continue;
            this.tableModel.addRow(new TableRow[]{this.createSwitchRow((SwitchDevice)device)});
        }
        if (this.titleLabel != null) {
            this.titleLabel.setDevNum(this.getDeviceTable().getAllRows().size());
        }
    }

    private TableRow<SwitchDevice, String> createSwitchRow(SwitchDevice dev) {
        DefaultTableRow currentRow = new DefaultTableRow(this.ibmcTableHeader.length, (Object)dev, (Object)dev.getIp());
        int colNum = 0;
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(dev.getIp()));
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(dev.getProductName()));
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(dev.getUserName()));
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(dev.getSoftwareVersion()));
        return currentRow;
    }

    public void refreshDevicesInfo() {
        List<SwitchDevice> switchDevs = this.getSelectSwitchDevs();
        BatchImportInfoDialog importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.device.refresh.dialogTitle"));
        this.switchListenerTables = DeviceCenterContext.getInstance().getDeviceTables().get("deviceTables");
        SmartkitUtils.addBatchImportDialog(importDialog, this.switchListenerTables);
        this.hwXlsDevs = new ArrayList<AbstractDevice>();
        for (SwitchDevice dev : switchDevs) {
            HwServerDevice xlsDev = dev.getHwServerDev();
            xlsDev.setStartIPAddress(dev.getIp());
            xlsDev.setEndIPAddress(dev.getIp());
            this.hwXlsDevs.add(dev.getHwServerDev());
        }
        Callable<String> refreshThread = () -> {
            DeviceControl.getInstance().initDriverFile();
            this.result = DeviceControl.getInstance().importDevices(this.hwXlsDevs, this.switchListenerTables);
            DeviceControl.getInstance().refreshFile();
            if (TaskResult.Result.SUCCESS.equals((Object)this.result.getResult())) {
                log.info("find the device success.");
                return "task success!";
            }
            log.error("find the device failed.");
            return "task fail!";
        };
        ThreadPoolManager.getInstance().submit(refreshThread);
    }

    public void modifyDevicesInfo() {
        List<SwitchDevice> switchDevs = this.getSelectSwitchDevs();
        if (switchDevs.size() > 1) {
            DialogUtils.showInfoDialog((Frame)DeviceCenterContext.getInstance().getParent(), (String)ResourceUtil.getString((String)"smartkit.devicemanager.layout.device.modifiy.oneOnly"));
            return;
        }
        SwitchDeviceAddLayOut lay = new SwitchDeviceAddLayOut();
        lay.getStartIp().setText("IP:");
        lay.getSymbolLabel().setText("");
        lay.getStartIpAddress().setEnabled(false);
        LayUtil.setComponentSize((JComponent)lay.getStartIpAddress(), new Dimension(200, 23));
        lay.getEndIpLabel().setVisible(false);
        lay.getEndIpField().setVisible(false);
        HwServerDevice hwServer = switchDevs.get(0).getHwServerDev();
        lay.getStartIpAddress().setText(LayUtil.filterItemInfo(switchDevs.get(0).getIp()));
        lay.getEndIpField().setText(LayUtil.filterItemInfo(switchDevs.get(0).getIp()));
        lay.getUserNameField().setText(LayUtil.filterItemInfo(hwServer.getUserName()));
        lay.getSnmpPortField().setText(LayUtil.filterItemInfo(hwServer.getSnmpPort() + ""));
        lay.getIpmiField().setText(LayUtil.filterItemInfo(hwServer.getIpmiPort() + ""));
        lay.getSshSfipField().setText(LayUtil.filterItemInfo(hwServer.getSshPort() + ""));
        lay.getVmField().setText(LayUtil.filterItemInfo(hwServer.getVmmPort() + ""));
        lay.getRedfishField().setText(LayUtil.filterItemInfo(hwServer.getRedFishPort() + ""));
        hwServer.setItDeviceType(ITDeviceType.SWITCH);
        SwitchAddDialog addDialog = new SwitchAddDialog(lay);
        hwServer.setStartIPAddress(switchDevs.get(0).getIp());
        hwServer.setEndIPAddress(switchDevs.get(0).getIp());
        addDialog.setDevInitHwServer(hwServer);
        SwingUtil.putParentCenter((Window)addDialog, (Window)DeviceCenterContext.getInstance().getParent());
        addDialog.setVisible(true);
    }

    @Override
    public void deleteServiceDev() {
        List switchRows = this.deviceTable.getMarkedRows();
        SmartkitUtils.deleteSceneAddDialogHasedDevices(switchRows, this);
        for (TableRow switchRow : switchRows) {
            this.getTableModel().removeRow(new TableRow[]{switchRow});
            LogUtils.addImportLog("devicemanager.server.manager.layout.remove", ((SwitchDevice)switchRow.getUserObject()).getIp(), true, "");
            DeviceCenterContext.getInstance().getIbmcHmmOsDevs().remove(switchRow.getUserObject());
            LayUtil.removeDevFromAllTableDevs((AbstractDevice)switchRow.getUserObject());
        }
        DeviceCenterContext.getInstance().notifyDeviceObserver();
        if (this.titleLabel != null) {
            this.titleLabel.setDevNum(this.getDeviceTable().getAllRows().size());
        }
        this.repaint();
    }

    @Override
    public int getSelectNum() {
        return this.getDeviceTable().getSelectedRows().length;
    }

    @Override
    public void updateBtn() {
    }

    @Override
    public List<AbstractDevice> getCurrentNeedCheckPortDeviceList() {
        return Collections.emptyList();
    }

    public IsmTable getDeviceTable() {
        return this.deviceTable;
    }

    @Override
    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTitleLabel(SerDeviTitleLabel titleLabel) {
        this.titleLabel = titleLabel;
    }

    public SerDeviTitleLabel getTitleLabel() {
        return this.titleLabel;
    }
}

