/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog.layout;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.CommonStatus;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.ComputeNodePlate;
import com.huawei.ism.tool.devicecenter.entity.HMMDevice;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.entity.ServerComputeNode;
import com.huawei.ism.tool.devicecenter.entity.TceDevice;
import com.huawei.ism.tool.devicecenter.service.DeviceControl;
import com.huawei.ism.tool.devicecenter.ui.dialog.BatchImportInfoDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.HmmDeviceAddDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.action.OpreationAction;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.AbstractDeviceTablePanel;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.HmmDeviceAddLayout;
import com.huawei.ism.tool.devicecenter.utils.LayUtil;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.devicemanager.ui.action.support.MultiInfoDialogParams;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.SwingUtil;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TceTablePanel
extends AbstractDeviceTablePanel<TceDevice> {
    private static final Logger log = LoggerFactory.getLogger(TceTablePanel.class);

    public TceTablePanel() {
        this.initTableItems();
        this.initTableLayout();
    }

    private void initTableItems() {
        this.tableHeaders = new String[]{ResourceUtil.getString((String)"devicecenter.ismtable.header.tce.serialnum"), ResourceUtil.getString((String)"devicecenter.ismtable.header.tce.smm.ip"), ResourceUtil.getString((String)"devicecenter.ismtable.header.tce.username"), ResourceUtil.getString((String)"devicecenter.ismtable.header.tce.software"), ResourceUtil.getString((String)"devicecenter.ismtable.header.tce.compute"), ResourceUtil.getString((String)"devicecenter.ismtable.header.status"), ResourceUtil.getString((String)"devicecenter.ismtable.header.suggestion")};
        this.tableModel = new DefaultTableModel(this.tableHeaders, new int[0]);
        this.deviceTable = new IsmTable((TableModel)this.tableModel);
        this.scrollPanel = new TableScrollPane(this.deviceTable, false, false, true);
    }

    @Override
    public TableRow<AbstractDevice, String> createTableRow(AbstractDevice device) {
        if (device instanceof TceDevice) {
            TceDevice tceDevice = (TceDevice)device;
            DefaultTableRow currentRow = new DefaultTableRow(this.tableHeaders.length, (Object)tceDevice, (Object)(tceDevice.getDevice().getHwServerDev().isPortProxy() ? tceDevice.getDeviceSn() : tceDevice.getIp()));
            int colNum = 0;
            OpreationAction opAction = new OpreationAction(tceDevice);
            currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(tceDevice.getDevice().getDeviceSerialNumber()));
            currentRow.setValueAt(colNum++, (Object)new IsmTableCell.HyperlinkCell(tceDevice.getDevice().getIp(), (ActionListener)opAction));
            currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(tceDevice.getDevice().getAccount().getUserName()));
            currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(tceDevice.getDevice().getDeviceSW()));
            currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(String.valueOf(tceDevice.getDevice().getServerComputeNodes().size())));
            this.addDeviceStatusValue(tceDevice, (TableRow<AbstractDevice, String>)currentRow, colNum);
            return currentRow;
        }
        return new DefaultTableRow(this.tableHeaders.length, null, (Object)"");
    }

    private void addDeviceStatusValue(TceDevice tceDevice, TableRow<AbstractDevice, String> currentRow, int colNum) {
        JSONObject resultDetail = tceDevice.getDevice().getResultDetail();
        if (null != resultDetail && resultDetail.has("result")) {
            String nodeResult = resultDetail.getString("result");
            if ("success".equals(nodeResult)) {
                currentRow.setValueAt(colNum, (Object)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"success.png"), CommonStatus.FINISHED.getTitle()));
            } else if ("partSuccess".equals(nodeResult)) {
                this.refreshTableForPartSuccess(colNum, currentRow, resultDetail);
            } else {
                currentRow.setValueAt(colNum, (Object)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"dev_failed.png"), resultDetail.get("errMsg").toString()));
            }
        } else {
            currentRow.setValueAt(colNum, (Object)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"success.png"), CommonStatus.FINISHED.getTitle()));
        }
    }

    private void refreshTableForPartSuccess(int num, TableRow<AbstractDevice, String> row, JSONObject resultDetail) {
        String partSuccessTip = ResourceUtil.getString((String)"smartkit.devicemanager.layout.manage.info.batchimport.dialog.part.success");
        row.setValueAt(num, (Object)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"partSuccess.png"), partSuccessTip));
        if (!resultDetail.has("msgType") || "simple".equals(resultDetail.getString("msgType"))) {
            this.setSimpleErrMsg(num, row, resultDetail);
        } else if ("table".equals(resultDetail.getString("msgType"))) {
            this.refreshDetailsOfFailedSlots(num, row, resultDetail);
        } else {
            log.warn("Unsupported error message type:" + resultDetail.getString("msgType") + ", raw message: " + resultDetail.get("errMsg"));
        }
    }

    private void setSimpleErrMsg(int num, TableRow<AbstractDevice, String> row, JSONObject resultDetail) {
        String errMsg = "";
        if (resultDetail.has("errMsgZH") && resultDetail.has("errMsgEN")) {
            errMsg = LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINESE) || LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINA) ? resultDetail.getString("errMsgZH") : resultDetail.getString("errMsgEN");
        } else {
            log.error("Incompatible json key, require:{} or {}", (Object)"errMsgZH", (Object)"errMsgEN");
        }
        row.setValueAt(num + 1, (Object)errMsg);
    }

    private void refreshDetailsOfFailedSlots(int num, TableRow<AbstractDevice, String> row, JSONObject resultDetail) {
        JSONArray errMsgs = resultDetail.getJSONArray("errMsg");
        ArrayList<ArrayList<Object>> tableRows = new ArrayList<ArrayList<Object>>();
        this.addErrMsg(errMsgs, tableRows);
        this.refreshHyperLinkOnDetailLine(num, row, tableRows);
    }

    private void addErrMsg(JSONArray errMsgs, List<ArrayList<Object>> tableRows) {
        for (int i = 0; i < errMsgs.length(); ++i) {
            Object slotDetailObj = errMsgs.get(i);
            JSONObject slotDetail = new JSONObject();
            if (slotDetailObj instanceof JSONObject) {
                slotDetail = (JSONObject)slotDetailObj;
            }
            ArrayList<String> tableRow = new ArrayList<String>();
            if (slotDetail.has("objectIdZH") && slotDetail.has("objectIdEN")) {
                tableRow.add(LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINESE) || LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINA) ? slotDetail.getString("objectIdZH") : slotDetail.getString("objectIdEN"));
            } else {
                log.error("Incompatible json key, require:{} or {}", (Object)"objectIdZH", (Object)"objectIdEN");
            }
            if (slotDetail.has("errMsgZH") && slotDetail.has("errMsgEN")) {
                tableRow.add(LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINESE) || LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINA) ? slotDetail.getString("errMsgZH") : slotDetail.getString("errMsgEN"));
            } else {
                log.error("Incompatible json key, require:{} or {}", (Object)"errMsgZH", (Object)"errMsgEN");
            }
            tableRows.add(tableRow);
        }
    }

    private void refreshHyperLinkOnDetailLine(int num, TableRow<AbstractDevice, String> row, List<ArrayList<Object>> tableRows) {
        IsmTableCell.HyperlinkCell viewDetails = new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"smartkit.devicemanager.layout.manage.info.batchimport.dialog.viewdetail"), event -> {
            String[] headers = new String[]{ResourceUtil.getString((String)"partsuccess.header.slot"), ResourceUtil.getString((String)"partsuccess.header.suggestion")};
            int[] tableWidthRatio = new int[]{15, 300};
            SubDialogUtils.showMultiInfoDialog((List)tableRows, (MultiInfoDialogParams)MultiInfoDialogParams.getNewBuilder().setParent((Window)DeviceCenterContext.getInstance().getParent()).setInfoMsg(ResourceUtil.getString((String)"smartkit.devicemanager.layout.manage.info.batchimport.dialog.viewdetail.desc")).setTitles(headers).setPreferredDimension(new Dimension(550, 250)).setTableLinesWidth(tableWidthRatio).build());
        });
        row.setValueAt(num + 1, (Object)viewDetails);
    }

    @Override
    public void modifyDeviceHandle(List<TceDevice> tceDevices) {
        HMMDevice hmmDevice = null;
        TceDevice tceDev = tceDevices.get(0);
        if (!VerifyUtil.isEmpty((Object)tceDev) && tceDev instanceof TceDevice) {
            TceDevice tceDevice = tceDev;
            hmmDevice = tceDevice.getDevice();
            HwServerDevice xlsTceDevice = hmmDevice.getHwServerDev();
            HmmDeviceAddLayout lay = new HmmDeviceAddLayout(false);
            this.initDeviceAddLayout(xlsTceDevice, lay);
            lay.getStartIpAddress().setText(LayUtil.filterItemInfo(hmmDevice.getIp()));
            lay.getEndIpField().setText(LayUtil.filterItemInfo(hmmDevice.getIp()));
            lay.getUserNameField().setText(LayUtil.filterItemInfo(xlsTceDevice.getUserName()));
            lay.getSnmpPortField().setText(LayUtil.filterItemInfo(xlsTceDevice.getSnmpPort() + ""));
            lay.getIpmiPortField().setText(LayUtil.filterItemInfo(xlsTceDevice.getIpmiPort() + ""));
            lay.getSshSfipPortField().setText(LayUtil.filterItemInfo(xlsTceDevice.getSshPort() + ""));
            lay.getVMPortField().setText(LayUtil.filterItemInfo(xlsTceDevice.getVmmPort() + ""));
            lay.getWriteCommunityPortField().setText(LayUtil.filterItemInfo(xlsTceDevice.getCommunity()));
            lay.getRedfishPortPortField().setText(LayUtil.filterItemInfo(xlsTceDevice.getRedFishPort()));
            this.initSwPlantContent(xlsTceDevice, lay);
            this.initComputeContent(xlsTceDevice, lay);
            xlsTceDevice.setItDeviceType(ITDeviceType.TCE);
            HmmDeviceAddDialog addDialog = new HmmDeviceAddDialog(lay);
            xlsTceDevice.setStartIPAddress(hmmDevice.getIp());
            xlsTceDevice.setEndIPAddress(hmmDevice.getIp());
            addDialog.setDevInitHwServer(xlsTceDevice);
            SwingUtil.putParentCenter((Window)addDialog, (Window)DeviceCenterContext.getInstance().getParent());
            addDialog.setVisible(true);
        } else {
            log.error("TceDev is empty, failed to add HMM dialog.");
        }
    }

    public List<TceDevice> getTceDevice() {
        ArrayList<TceDevice> devList = new ArrayList<TceDevice>();
        List rows = this.getDeviceTable().getMarkedRows();
        for (TableRow row : rows) {
            devList.add((TceDevice)row.getUserObject());
        }
        return devList;
    }

    @Override
    public void refresh(List<TceDevice> devices) {
        this.hwXlsDevs = new ArrayList();
        for (TceDevice dev : devices) {
            HwServerDevice xlsDev = dev.getDevice().getHwServerDev();
            xlsDev.setStartIPAddress(dev.getDevice().getIp());
            xlsDev.setEndIPAddress(dev.getDevice().getIp());
            this.hwXlsDevs.add(dev.getDevice().getHwServerDev());
        }
        BatchImportInfoDialog importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.device.refresh.dialogTitle"));
        this.listeners = DeviceCenterContext.getInstance().getDeviceTables().get("deviceTables");
        SmartkitUtils.addBatchImportDialog(importDialog, this.listeners);
        Runnable refreshHmm = new Runnable(){

            @Override
            public void run() {
                DeviceControl.getInstance().initDriverFile();
                TceTablePanel.this.result = DeviceControl.getInstance().importDevices(TceTablePanel.this.hwXlsDevs, TceTablePanel.this.listeners);
                DeviceControl.getInstance().refreshFile();
                if (TaskResult.Result.SUCCESS.equals((Object)TceTablePanel.this.result.getResult())) {
                    log.info("find the device success.");
                } else {
                    log.error("find the device failed.");
                }
            }
        };
        Future<?> future = Executors.newSingleThreadExecutor().submit(refreshHmm);
        log.info("the result of the task is:{} ", (Object)future.isDone());
    }

    @Override
    public List<AbstractDevice> getCurrentNeedCheckPortDeviceList() {
        ArrayList<AbstractDevice> deviceList = new ArrayList<AbstractDevice>();
        List selectDevices = this.getSelectDevices();
        for (TceDevice tceDevice : selectDevices) {
            HwServerDevice hwServerDev = tceDevice.getDevice().getHwServerDev();
            deviceList.add(hwServerDev);
            List<ServerComputeNode> serverComputeNodes = tceDevice.getDevice().getServerComputeNodes();
            for (ServerComputeNode serverComputeNode : serverComputeNodes) {
                HwServerDevice hwServerComputeNode = serverComputeNode.getHwServerDev();
                hwServerComputeNode.setStartIPAddress(serverComputeNode.getIp());
                hwServerComputeNode.setEndIPAddress(serverComputeNode.getIp());
                if (hwServerDev.isApplyToOtherNodes()) {
                    ComputeNodePlate computeNodePlate2 = hwServerDev.getComputeNodePlateList().get(0);
                    this.setSlotInfo(hwServerComputeNode, computeNodePlate2);
                    deviceList.add(hwServerComputeNode);
                    continue;
                }
                String slot = serverComputeNode.getSlot();
                hwServerDev.getComputeNodePlateList().stream().filter(computeNodePlate -> computeNodePlate.getSlotId().equals(slot)).findFirst().ifPresent(computeNodePlate -> this.setSlotInfo(hwServerComputeNode, (ComputeNodePlate)computeNodePlate));
                if (StringUtils.isNULLStr((String)hwServerComputeNode.getUserName()) && StringUtils.isNULLStr((String)hwServerComputeNode.getUserPwd())) {
                    hwServerComputeNode.setUserName(hwServerDev.getUserName());
                    hwServerComputeNode.setUserPwd(hwServerDev.getUserPwd());
                    hwServerComputeNode.setSnmpPrivPwd(hwServerDev.getSnmpPrivPwd());
                    hwServerComputeNode.setSshPort(Integer.parseInt(serverComputeNode.getSshPort()));
                    hwServerComputeNode.setSnmpPort(Integer.parseInt(serverComputeNode.getSnmpPort()));
                    hwServerComputeNode.setIpmiPort(Integer.parseInt(serverComputeNode.getIpmiPort()));
                }
                deviceList.add(hwServerComputeNode);
            }
        }
        return deviceList;
    }

    private void setSlotInfo(HwServerDevice hwServerComputeNode, ComputeNodePlate computeNodePlate) {
        hwServerComputeNode.setUserName(computeNodePlate.getSlotUser());
        hwServerComputeNode.setUserPwd(computeNodePlate.getSlotPasswd());
        hwServerComputeNode.setSnmpPrivPwd(computeNodePlate.getSlotSnmpPrivPwd());
        hwServerComputeNode.setSshPort(Integer.parseInt(computeNodePlate.getSlotSSHPort()));
        hwServerComputeNode.setSnmpPort(Integer.parseInt(computeNodePlate.getSlotSNMPPort()));
        hwServerComputeNode.setIpmiPort(Integer.parseInt(computeNodePlate.getSlotIPMIPort()));
        hwServerComputeNode.setRedFishPort(computeNodePlate.getSlotHttpsPort());
    }
}

