/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.widget;

import com.huawei.ism.tool.base.ui.component.AbstractLeftNavPanel;
import com.huawei.ism.tool.devicecenter.ui.widget.NavigationPanel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class NavigationItem
extends AbstractLeftNavPanel {
    private static final long serialVersionUID = -8453091406774806732L;
    private static final int TASK_BAR_MARGIN_WIDTH = 18;
    private boolean isSelected = false;
    private JLabel txtLabel;
    private NavigationPanel mainPanel;
    private JPanel centerPanel;

    public NavigationItem(String navName, JPanel center, NavigationPanel main) {
        this.centerPanel = center;
        this.mainPanel = main;
        this.txtLabel = new JLabel(navName);
        this.initUi();
    }

    private void initUi() {
        this.txtLabel.setFont(NAV_TITLE_FONT);
        this.setCursor(new Cursor(12));
        this.setLayout(new BoxLayout((Container)((Object)this), 0));
        this.add(Box.createHorizontalStrut(18));
        this.add(this.txtLabel);
        this.add(Box.createHorizontalGlue());
        this.setPreferredSize(NAV_TASKBAR_SIZE);
        this.setMaximumSize(NAV_TASKBAR_SIZE);
        this.setMinimumSize(NAV_TASKBAR_SIZE);
        this.addMouseListener(new ItemMouseListener(this));
    }

    private void setTitleColor(boolean isSel) {
        Color clr = Color.BLACK;
        if (isSel) {
            clr = FONT_COLOR_SELECTED;
        }
        this.txtLabel.setForeground(clr);
    }

    public String getUIClassID() {
        UIDefaults defaultUI = UIManager.getDefaults();
        defaultUI.put("NavigationItemUI", "com.huawei.ism.tool.devicecenter.ui.surface.NavigationItemUI");
        return "NavigationItemUI";
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public JPanel getCenterPanel() {
        return this.centerPanel;
    }

    public void setSelected(boolean status) {
        this.isSelected = status;
        this.setTitleColor(status);
    }

    public JLabel getTxtLabel() {
        return this.txtLabel;
    }

    private class ItemMouseListener
    implements MouseListener {
        private NavigationItem navItem;

        public ItemMouseListener(NavigationItem item) {
            this.navItem = item;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            NavigationItem.this.mainPanel.navItemSwitch(this.navItem);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this.navItem.isSelected()) {
                return;
            }
            NavigationItem.this.setTitleColor(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.navItem.isSelected()) {
                return;
            }
            NavigationItem.this.setTitleColor(false);
        }
    }
}

